/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.sqlserver;

import java.sql.Connection;
import java.util.Properties;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.FlywayEditionUpgradeRequiredException;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.UrlUtils;
import org.flywaydb.database.sqlserver.SQLServerConfigurationExtension;
import org.flywaydb.database.sqlserver.SQLServerDatabase;
import org.flywaydb.database.sqlserver.SQLServerParser;

public class SQLServerDatabaseType
extends BaseDatabaseType {
    private static final Log LOG = LogFactory.getLog(SQLServerDatabaseType.class);

    public String getName() {
        return "SQL Server";
    }

    public int getNullType() {
        return 12;
    }

    protected boolean supportsJTDS() {
        return true;
    }

    public boolean handlesJDBCUrl(String url) {
        return UrlUtils.isSecretManagerUrl((String)url, (String)"sqlserver") || url.startsWith("jdbc:sqlserver:") || this.supportsJTDS() && url.startsWith("jdbc:jtds:") || url.startsWith("jdbc:p6spy:sqlserver:") || this.supportsJTDS() && url.startsWith("jdbc:p6spy:jtds:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:sqlserver:") || this.supportsJTDS() && url.startsWith("jdbc:p6spy:jtds:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        if (url.startsWith("jdbc:jtds:")) {
            if (this.supportsJTDS()) {
                return "net.sourceforge.jtds.jdbc.Driver";
            }
            if (!this.supportsJTDS()) {
                LOG.warn("JTDS does not support this database. Using the Microsoft JDBC driver instead");
            }
        }
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("Microsoft SQL Server");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new SQLServerDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new SQLServerParser(configuration, parsingContext);
    }

    public void setDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
        props.put("applicationName", "Flyway by Redgate");
    }

    public void setConfigConnectionProps(Configuration config, Properties props, ClassLoader classLoader) {
        if (config != null) {
            SQLServerConfigurationExtension configurationExtension = (SQLServerConfigurationExtension)config.getPluginRegister().getPlugin(SQLServerConfigurationExtension.class);
            if (StringUtils.hasText((String)configurationExtension.getKerberos().getLogin().getFile())) {
                throw new FlywayEditionUpgradeRequiredException(Tier.TEAMS, LicenseGuard.getTier((Configuration)config), "sqlserver.kerberos.login.file");
            }
            if (StringUtils.hasText((String)config.getKerberosConfigFile())) {
                throw new FlywayEditionUpgradeRequiredException(Tier.TEAMS, LicenseGuard.getTier((Configuration)config), "sqlserver.kerberos.config.file");
            }
        }
    }

    public boolean detectUserRequiredByUrl(String url) {
        return !url.contains("integratedSecurity=") && !url.contains("authentication=ActiveDirectoryIntegrated") && !url.contains("authentication=ActiveDirectoryMSI");
    }

    public boolean detectPasswordRequiredByUrl(String url) {
        return !url.contains("integratedSecurity=") && !url.contains("authentication=ActiveDirectoryIntegrated") && !url.contains("authentication=ActiveDirectoryMSI");
    }
}

