/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.snowflake;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.database.snowflake.SnowflakeConnection;

public class SnowflakeDatabase
extends Database<SnowflakeConnection> {
    private static final Log LOG = LogFactory.getLog(SnowflakeDatabase.class);
    private final boolean quotedIdentifiersIgnoreCase;

    public SnowflakeDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
        this.quotedIdentifiersIgnoreCase = SnowflakeDatabase.getQuotedIdentifiersIgnoreCase(this.jdbcTemplate);
        LOG.info("QUOTED_IDENTIFIERS_IGNORE_CASE option is " + this.quotedIdentifiersIgnoreCase);
    }

    private static boolean getQuotedIdentifiersIgnoreCase(JdbcTemplate jdbcTemplate) {
        try {
            List result = jdbcTemplate.queryForList("SHOW PARAMETERS LIKE 'QUOTED_IDENTIFIERS_IGNORE_CASE'", new Object[0]);
            Map row = (Map)result.get(0);
            return "TRUE".equals(((String)row.get("value")).toUpperCase(Locale.ENGLISH));
        }
        catch (SQLException e) {
            LOG.warn("Could not query for parameter QUOTED_IDENTIFIERS_IGNORE_CASE.");
            return false;
        }
    }

    protected SnowflakeConnection doGetConnection(Connection connection) {
        return new SnowflakeConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
        this.ensureDatabaseIsRecentEnough("3.0");
        this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("3", Tier.PREMIUM, configuration);
        this.recommendFlywayUpgradeIfNecessaryForMajorVersion("7.33");
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + table + " (\n" + this.quote(new String[]{"installed_rank"}) + " NUMBER(38,0) NOT NULL,\n" + this.quote(new String[]{"version"}) + " VARCHAR(50),\n" + this.quote(new String[]{"description"}) + " VARCHAR(200),\n" + this.quote(new String[]{"type"}) + " VARCHAR(20) NOT NULL,\n" + this.quote(new String[]{"script"}) + " VARCHAR(1000) NOT NULL,\n" + this.quote(new String[]{"checksum"}) + " NUMBER(38,0),\n" + this.quote(new String[]{"installed_by"}) + " VARCHAR(100) NOT NULL,\n" + this.quote(new String[]{"installed_on"}) + " TIMESTAMP_LTZ(9) NOT NULL DEFAULT CURRENT_TIMESTAMP(),\n" + this.quote(new String[]{"execution_time"}) + " NUMBER(38,0) NOT NULL,\n" + this.quote(new String[]{"success"}) + " BOOLEAN NOT NULL,\nprimary key (" + this.quote(new String[]{"installed_rank"}) + "));\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "");
    }

    public String getSelectStatement(Table table) {
        return "SELECT " + this.quote(new String[]{"installed_rank"}) + "," + this.quote(new String[]{"version"}) + "," + this.quote(new String[]{"description"}) + "," + this.quote(new String[]{"type"}) + "," + this.quote(new String[]{"script"}) + "," + this.quote(new String[]{"checksum"}) + "," + this.quote(new String[]{"installed_on"}) + "," + this.quote(new String[]{"installed_by"}) + "," + this.quote(new String[]{"execution_time"}) + "," + this.quote(new String[]{"success"}) + " FROM " + table + " WHERE " + this.quote(new String[]{"installed_rank"}) + " > ? ORDER BY " + this.quote(new String[]{"installed_rank"});
    }

    public String getInsertStatement(Table table) {
        return "INSERT INTO " + table + " (" + this.quote(new String[]{"installed_rank"}) + ", " + this.quote(new String[]{"version"}) + ", " + this.quote(new String[]{"description"}) + ", " + this.quote(new String[]{"type"}) + ", " + this.quote(new String[]{"script"}) + ", " + this.quote(new String[]{"checksum"}) + ", " + this.quote(new String[]{"installed_by"}) + ", " + this.quote(new String[]{"execution_time"}) + ", " + this.quote(new String[]{"success"}) + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "true";
    }

    public String getBooleanFalse() {
        return "false";
    }

    public boolean catalogIsSchema() {
        return false;
    }
}

