/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.mongodb;

import com.dbschema.mongo.MongoConnection;
import com.dbschema.mongo.resultSet.ListResultSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.bson.Document;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.jdbc.JdbcNullTypes;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.jdbc.RowMapper;

public class MongoDBJdbcTemplate
extends JdbcTemplate {
    public MongoDBJdbcTemplate(Connection connection) {
        super(connection, DatabaseTypeRegister.getDatabaseTypeForConnection((Connection)connection));
    }

    protected PreparedStatement prepareStatement(String sql, Object[] params) throws SQLException {
        MongoConnection mongoConnection = (MongoConnection)this.connection;
        Object[] params2 = new Object[params.length];
        String replaceMe = sql.replaceAll("\\?", "%s");
        for (int i = 0; i < params.length; ++i) {
            Object object = params[i];
            if (object instanceof Integer) {
                Integer integerValue = (Integer)object;
                params2[i] = integerValue;
                continue;
            }
            object = params[i];
            if (object instanceof Boolean) {
                Boolean booleanValue = (Boolean)object;
                params2[i] = booleanValue;
                continue;
            }
            object = params[i];
            if (object instanceof String) {
                String stringValue = (String)object;
                params2[i] = "'" + stringValue + "'";
                continue;
            }
            if (params[i] == null || params[i] == JdbcNullTypes.StringNull || params[i] == JdbcNullTypes.IntegerNull || params[i] == JdbcNullTypes.BooleanNull) {
                params2[i] = null;
                continue;
            }
            throw new FlywayException("Unhandled object of type '" + params[i].getClass().getName() + "'. Please contact support or leave an issue on GitHub.");
        }
        String statementString = String.format(replaceMe, params2);
        return mongoConnection.prepareStatement(statementString);
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Object ... params) throws SQLException {
        ArrayList<Object> results;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement(sql, params);
            resultSet = statement.executeQuery();
            results = new ArrayList<Object>();
            while (resultSet.next()) {
                ResultSet rs = MongoDBJdbcTemplate.convertMongoResultset(resultSet);
                while (rs.next()) {
                    results.add(rowMapper.mapRow(rs));
                }
            }
        }
        catch (Exception eeeee) {
            try {
                throw new FlywayException("Error executing statement " + sql, (Throwable)eeeee);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement((Statement)statement);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet((ResultSet)resultSet);
        JdbcUtils.closeStatement((Statement)statement);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryForString(String query, String ... params) throws SQLException {
        String result;
        ResultSet resultSet;
        PreparedStatement statement;
        block5: {
            statement = null;
            resultSet = null;
            try {
                statement = this.prepareStatement(query, params);
                resultSet = statement.executeQuery();
                result = null;
                if (!resultSet.next()) break block5;
                try {
                    ResultSet rs = MongoDBJdbcTemplate.convertMongoResultset(resultSet);
                    while (rs.next()) {
                        result = rs.getString(1);
                    }
                }
                catch (Exception e) {
                    result = resultSet.getString(1);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement((Statement)statement);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet((ResultSet)resultSet);
        JdbcUtils.closeStatement((Statement)statement);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String sql, Object ... params) throws SQLException {
        if (sql.contains("updateOne")) {
            ArrayList<Object> tmp = new ArrayList<Object>(List.of(params));
            tmp.add(0, tmp.get(tmp.size() - 1));
            tmp.remove(tmp.size() - 1);
            params = tmp.toArray();
        }
        PreparedStatement statement = null;
        try {
            statement = this.prepareStatement(sql, params);
            statement.executeUpdate();
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(statement);
            throw throwable;
        }
        JdbcUtils.closeStatement((Statement)statement);
    }

    @NonNull
    private static ResultSet convertMongoResultset(ResultSet resultSet) throws SQLException {
        Document doc = (Document)resultSet.getObject(1);
        doc.remove((Object)"_id");
        String[] columnNames = doc.keySet().stream().toList().toArray(new String[0]);
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        Collection vals = doc.values();
        Object[] valsArray = vals.toArray();
        data.add(valsArray);
        return new ListResultSet(data, columnNames);
    }
}

