/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.mongodb;

import java.sql.Connection;
import java.sql.Timestamp;
import java.time.Instant;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.util.AbbreviationUtils;
import org.flywaydb.database.mongodb.MongoDBConnection;

public class MongoDBDatabase
extends Database<MongoDBConnection> {
    public MongoDBDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected MongoDBConnection doGetConnection(Connection connection) {
        return new MongoDBConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "true";
    }

    public String getBooleanFalse() {
        return "false";
    }

    public boolean catalogIsSchema() {
        return true;
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "db.getSiblingDB('" + table.getSchema().getName() + "').createCollection(" + this.quote(new String[]{table.getName()}) + ");\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "db." + table.getName() + ".createIndex({ success: -1 })";
    }

    public String getInsertStatement(Table table) {
        return "db.getSiblingDB('" + table.getSchema().getName() + "')." + table.getName() + ".insertOne({" + this.quote(new String[]{"installed_rank"}) + ": ?, " + this.quote(new String[]{"version"}) + ": ?, " + this.quote(new String[]{"description"}) + ": ?, " + this.quote(new String[]{"type"}) + ": ?, " + this.quote(new String[]{"script"}) + ": ?, " + this.quote(new String[]{"checksum"}) + ": ?, " + this.quote(new String[]{"installed_by"}) + ": ?, " + this.quote(new String[]{"installed_on"}) + ": '" + Timestamp.from(Instant.now()) + "', " + this.quote(new String[]{"execution_time"}) + ": ?, " + this.quote(new String[]{"success"}) + ": ?})";
    }

    public String getUpdateStatement(Table table) {
        return "db.getSiblingDB('" + table.getSchema().getName() + "')." + table.getName() + ".updateOne({" + this.quote(new String[]{"installed_rank"}) + ": ?}, {$set: {" + this.quote(new String[]{"description"}) + ": ?," + this.quote(new String[]{"type"}) + ": ?," + this.quote(new String[]{"checksum"}) + ": ?}})";
    }

    public String getSelectStatement(Table table) {
        return "db.getSiblingDB('" + table.getSchema().getName() + "')." + table.getName() + ".find({" + this.quote(new String[]{"installed_rank"}) + ": { $gt: ? }}).sort({" + this.quote(new String[]{"installed_rank"}) + ": 1})";
    }

    public String getDeleteStatement(Table table, boolean version) {
        return "db.getSiblingDB('" + table.getSchema().getName() + "')." + table.getName() + ".deleteMany({ 'success': " + this.getBooleanFalse() + ", " + (version ? "'version': ? " : "'desciption': ? ") + "})";
    }

    protected String getBaselineStatement(Table table) {
        return String.format(this.getInsertStatement(table).replace("?", "%s"), 1, this.quoteIfNotNull(this.configuration.getBaselineVersion().toString()), this.quoteIfNotNull(AbbreviationUtils.abbreviateDescription((String)this.configuration.getBaselineDescription())), this.quoteIfNotNull(CoreMigrationType.BASELINE.toString()), this.quoteIfNotNull(AbbreviationUtils.abbreviateScript((String)this.configuration.getBaselineDescription())), null, this.quoteIfNotNull(this.getInstalledBy()), 0, this.getBooleanTrue());
    }

    private String quoteIfNotNull(String value) {
        return value == null ? null : this.quote(new String[]{value});
    }
}

