/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.iris;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Stream;
import org.flywaydb.community.database.iris.IRISDatabase;
import org.flywaydb.community.database.iris.IRISTable;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.SchemaObject;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class IRISSchema
extends Schema<IRISDatabase, IRISTable> {
    public IRISSchema(JdbcTemplate jdbcTemplate, IRISDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() {
        return true;
    }

    protected boolean doEmpty() {
        return false;
    }

    protected void doCreate() {
        throw new UnsupportedOperationException("InterSystems IRIS does not support schema creation. Schema not created");
    }

    protected void doDrop() {
        throw new UnsupportedOperationException("InterSystems IRIS does not support dropping schemas. Schema not dropped");
    }

    protected void doClean() {
        Stream.of((IRISTable[])this.allTables()).forEach(SchemaObject::drop);
    }

    protected IRISTable[] doAllTables() throws SQLException {
        List tableNames = this.jdbcTemplate.queryForStringList("SELECT SqlTableName from %dictionary.compiledclass where SqlSchemaName = ?", new String[]{this.name});
        return (IRISTable[])tableNames.stream().map(tableName -> new IRISTable(this.jdbcTemplate, (IRISDatabase)this.database, this, (String)tableName)).toArray(IRISTable[]::new);
    }

    public IRISTable getTable(String tableName) {
        return new IRISTable(this.jdbcTemplate, (IRISDatabase)this.database, this, tableName);
    }
}

