/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.iris;

import java.sql.Connection;
import org.flywaydb.community.database.iris.IRISConnection;
import org.flywaydb.community.database.iris.IRISDatabaseType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;

public class IRISDatabase
extends Database<IRISConnection> {
    public IRISDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected IRISConnection doGetConnection(Connection connection) {
        return new IRISConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
        MigrationVersion version = this.getVersion();
        if (Integer.parseInt(version.getMajorAsString()) < 2019) {
            throw new FlywayDbUpgradeRequiredException((DatabaseType)new IRISDatabaseType(), version.toString(), "2019.1");
        }
    }

    public boolean supportsDdlTransactions() {
        return true;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        String schemaName = table.getSchema().getName();
        String tableName = table.getName();
        return "CREATE TABLE \"" + schemaName + "\".\"" + tableName + "\" (\n  \"installed_rank\" INTEGER NOT NULL,\n  \"version\" VARCHAR(50),\n  \"description\" VARCHAR(200) NOT NULL,\n  \"type\" VARCHAR(20) NOT NULL,\n  \"script\" VARCHAR(1000) NOT NULL,\n  \"checksum\" INTEGER,\n  \"installed_by\" VARCHAR(100) NOT NULL,\n  \"installed_on\" TIMESTAMP NOT NULL DEFAULT getdate(),\n  \"execution_time\" INTEGER NOT NULL,\n  \"success\" BIT NOT NULL\n);\nALTER TABLE \"" + schemaName + "\".\"" + tableName + "\" ADD CONSTRAINT \"" + tableName + "_pk\" PRIMARY KEY (\"installed_rank\");";
    }
}

