/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.InfoOutput;
import org.flywaydb.core.extensibility.RgDomainChecker;
import org.flywaydb.core.extensibility.RootTelemetryModel;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.util.StringUtils;

public class TelemetryUtils {
    public static RootTelemetryModel populateRootTelemetry(RootTelemetryModel rootTelemetryModel, Configuration configuration, boolean isRedgateEmployee) {
        ClassicConfiguration classicConfiguration;
        rootTelemetryModel.setRedgateEmployee(isRedgateEmployee);
        if (configuration != null && (classicConfiguration = new ClassicConfiguration(configuration)).getDataSource() != null) {
            try (JdbcConnectionFactory jdbcConnectionFactory = new JdbcConnectionFactory(classicConfiguration.getDataSource(), (Configuration)classicConfiguration, null);){
                RootTelemetryModel rootTelemetryModel2;
                block12: {
                    Database database = jdbcConnectionFactory.getDatabaseType().createDatabase(configuration, false, jdbcConnectionFactory, null);
                    try {
                        rootTelemetryModel.setDatabaseEngine(database.getDatabaseType().getName());
                        rootTelemetryModel.setDatabaseVersion(database.getVersion().toString());
                        rootTelemetryModel2 = rootTelemetryModel;
                        if (database == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (database != null) {
                            try {
                                database.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    database.close();
                }
                return rootTelemetryModel2;
            }
        }
        rootTelemetryModel.setDatabaseEngine("UNKNOWN");
        return rootTelemetryModel;
    }

    public static boolean isRedgateEmployee(PluginRegister pluginRegister, Configuration configuration) {
        RgDomainChecker domainChecker = (RgDomainChecker)pluginRegister.getPlugin(RgDomainChecker.class);
        if (domainChecker == null) {
            return false;
        }
        return domainChecker.isInDomain(configuration);
    }

    public static String getOldestMigration(List<InfoOutput> infos) {
        if (infos == null) {
            return "";
        }
        ArrayList migrationDates = new ArrayList();
        infos.stream().filter(output -> StringUtils.hasText((String)output.installedOnUTC)).forEach(output -> migrationDates.add(output.installedOnUTC));
        if (!migrationDates.isEmpty()) {
            migrationDates.sort(Comparator.naturalOrder());
            return (String)migrationDates.get(0);
        }
        return "";
    }

    private TelemetryUtils() {
    }
}

