/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flywaydb.commandline.CommandLineArguments;
import org.flywaydb.commandline.MavenVersionChecker;
import org.flywaydb.commandline.RedgateUpdateChecker;
import org.flywaydb.commandline.logging.console.ConsoleLog;
import org.flywaydb.commandline.logging.console.ConsoleLogCreator;
import org.flywaydb.commandline.logging.file.FileLogCreator;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogCreator;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CompositeResult;
import org.flywaydb.core.api.output.ErrorOutput;
import org.flywaydb.core.api.output.MigrateErrorResult;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.PluginMetadata;
import org.flywaydb.core.internal.command.DbMigrate;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.info.MigrationInfoDumper;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.logging.EvolvingLog;
import org.flywaydb.core.internal.logging.buffered.BufferedLog;
import org.flywaydb.core.internal.logging.multi.MultiLogCreator;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.LocalDateTimeSerializer;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;

public class Main {
    private static Log LOG;
    private static final PluginRegister pluginRegister;

    static LogCreator getLogCreator(CommandLineArguments commandLineArguments) {
        if (commandLineArguments.shouldOutputJson() || commandLineArguments.hasOperation("info") && commandLineArguments.isFilterOnMigrationIds()) {
            return MultiLogCreator.empty();
        }
        ArrayList<Object> logCreators = new ArrayList<Object>();
        logCreators.add(new ConsoleLogCreator(commandLineArguments));
        if (commandLineArguments.isOutputFileSet()) {
            logCreators.add(new FileLogCreator(commandLineArguments));
        }
        return new MultiLogCreator(logCreators);
    }

    static void initLogging(CommandLineArguments commandLineArguments) {
        LogFactory.setFallbackLogCreator((LogCreator)Main.getLogCreator(commandLineArguments));
        LOG = LogFactory.getLog(Main.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CommandLineArguments commandLineArguments = new CommandLineArguments(pluginRegister, args);
        Main.initLogging(commandLineArguments);
        try {
            OperationResult result;
            Flyway flyway;
            block34: {
                commandLineArguments.validate();
                if (commandLineArguments.hasOperation("help") || commandLineArguments.shouldPrintUsage()) {
                    boolean helpAsFlagWithOperation;
                    StringBuilder helpText = new StringBuilder();
                    boolean helpAsVerbWithOperation = commandLineArguments.hasOperation("help") && commandLineArguments.getOperations().size() > 1;
                    boolean bl = helpAsFlagWithOperation = commandLineArguments.shouldPrintUsage() && commandLineArguments.getOperations().size() > 0;
                    if (helpAsVerbWithOperation || helpAsFlagWithOperation) {
                        for (String operation : commandLineArguments.getOperations()) {
                            String helpTextForOperation = pluginRegister.getPlugins(CommandExtension.class).stream().filter(e -> e.handlesCommand(operation)).map(PluginMetadata::getHelpText).collect(Collectors.joining("\n\n"));
                            if (!StringUtils.hasText((String)helpTextForOperation)) continue;
                            helpText.append(helpTextForOperation).append("\n\n");
                        }
                    }
                    if (!StringUtils.hasText((String)helpText.toString())) {
                        Main.printUsage();
                    } else {
                        LOG.info(helpText.toString());
                    }
                    return;
                }
                Map envVars = ConfigUtils.environmentVariablesToPropertyMap();
                Map<String, String> config = new HashMap<String, String>();
                Main.initializeDefaults(config, commandLineArguments);
                Main.loadConfigurationFromConfigFiles(config, commandLineArguments, envVars);
                config.putAll(envVars);
                config = Main.overrideConfiguration(config, commandLineArguments.getConfiguration());
                if (commandLineArguments.isWorkingDirectorySet()) {
                    Main.makeRelativeLocationsBasedOnWorkingDirectory(commandLineArguments, config);
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                ArrayList<File> jarFiles = new ArrayList<File>();
                jarFiles.addAll(Main.getJdbcDriverJarFiles());
                jarFiles.addAll(Main.getJavaMigrationJarFiles(config));
                if (!jarFiles.isEmpty()) {
                    classLoader = ClassUtils.addJarsOrDirectoriesToClasspath((ClassLoader)classLoader, jarFiles);
                }
                if (!commandLineArguments.shouldSuppressPrompt()) {
                    Main.promptForCredentialsIfMissing(config);
                }
                ConfigUtils.dumpConfiguration(config);
                Main.filterProperties(config);
                FluentConfiguration configuration = new FluentConfiguration(classLoader).configuration(config);
                flyway = Flyway.configure((ClassLoader)classLoader).configuration((Configuration)configuration).load();
                if (!commandLineArguments.skipCheckForUpdate()) {
                    if (RedgateUpdateChecker.isEnabled() && configuration.getDataSource() != null) {
                        try (JdbcConnectionFactory jdbcConnectionFactory = new JdbcConnectionFactory(configuration.getDataSource(), (Configuration)configuration, null);
                             Database database = jdbcConnectionFactory.getDatabaseType().createDatabase((Configuration)configuration, false, jdbcConnectionFactory, null);){
                            RedgateUpdateChecker.Context context = new RedgateUpdateChecker.Context(config, commandLineArguments.getOperations(), database.getDatabaseType().getName(), database.getVersion().getVersion(), pluginRegister);
                            RedgateUpdateChecker.checkForVersionUpdates(context);
                            break block34;
                        }
                    }
                    MavenVersionChecker.checkForVersionUpdates();
                }
            }
            if (commandLineArguments.getOperations().size() == 1) {
                String operation = commandLineArguments.getOperations().get(0);
                result = Main.executeOperation(flyway, operation, commandLineArguments);
            } else {
                CompositeResult compositeResult = new CompositeResult();
                for (String operation : commandLineArguments.getOperations()) {
                    compositeResult.individualResults.add(Main.executeOperation(flyway, operation, commandLineArguments));
                }
                result = compositeResult;
            }
            if (commandLineArguments.isCommunityFallback()) {
                LOG.warn("A Flyway License was not been provided; fell back to Community Edition. Please contact sales at sales@flywaydb.org for license information.");
            }
            if (commandLineArguments.shouldOutputJson()) {
                Main.printJson(commandLineArguments, result);
            }
        }
        catch (DbMigrate.FlywayMigrateException e2) {
            MigrateErrorResult errorResult = ErrorOutput.fromMigrateException((DbMigrate.FlywayMigrateException)e2);
            Main.printError(commandLineArguments, (Exception)((Object)e2), (OperationResult)errorResult);
            System.exit(1);
        }
        catch (Exception e3) {
            ErrorOutput errorOutput = ErrorOutput.fromException((Exception)e3);
            Main.printError(commandLineArguments, e3, (OperationResult)errorOutput);
            System.exit(1);
        }
        finally {
            Main.flushLog(commandLineArguments);
        }
    }

    private static void printError(CommandLineArguments commandLineArguments, Exception e, OperationResult errorResult) {
        if (commandLineArguments.shouldOutputJson()) {
            Main.printJson(commandLineArguments, errorResult);
        } else if (commandLineArguments.getLogLevel() == ConsoleLog.Level.DEBUG) {
            LOG.error("Unexpected error", e);
        } else {
            LOG.error(Main.getMessagesFromException(e));
        }
        Main.flushLog(commandLineArguments);
    }

    private static void flushLog(CommandLineArguments commandLineArguments) {
        Log currentLog = ((EvolvingLog)LOG).getLog();
        if (currentLog instanceof BufferedLog) {
            ((BufferedLog)currentLog).flush(Main.getLogCreator(commandLineArguments).createLogger(Main.class));
        }
    }

    private static void makeRelativeLocationsBasedOnWorkingDirectory(CommandLineArguments commandLineArguments, Map<String, String> config) {
        Object[] locations = config.get("flyway.locations").split(",");
        for (int i = 0; i < locations.length; ++i) {
            if (!locations[i].startsWith("filesystem:")) continue;
            String newLocation = ((String)locations[i]).substring("filesystem:".length());
            File file = new File(newLocation);
            if (!file.isAbsolute()) {
                file = new File(commandLineArguments.getWorkingDirectory(), newLocation);
            }
            locations[i] = "filesystem:" + file.getAbsolutePath();
        }
        config.put("flyway.locations", StringUtils.arrayToCommaDelimitedString((Object[])locations));
    }

    private static Map<String, String> overrideConfiguration(Map<String, String> existingConfiguration, Map<String, String> newConfiguration) {
        HashMap<String, String> combinedConfiguration = new HashMap<String, String>();
        combinedConfiguration.putAll(existingConfiguration);
        combinedConfiguration.putAll(newConfiguration);
        return combinedConfiguration;
    }

    static String getMessagesFromException(Throwable e) {
        StringBuilder condensedMessages = new StringBuilder();
        String preamble = "";
        while (e != null) {
            if (e instanceof FlywayException) {
                condensedMessages.append(preamble).append(e.getMessage());
            } else {
                condensedMessages.append(preamble).append(e);
            }
            preamble = "\r\nCaused by: ";
            e = e.getCause();
        }
        return condensedMessages.toString();
    }

    private static OperationResult executeOperation(Flyway flyway, String operation, CommandLineArguments commandLineArguments) {
        Object result = null;
        if ("clean".equals(operation)) {
            result = flyway.clean();
        } else if ("baseline".equals(operation)) {
            result = flyway.baseline();
        } else if ("migrate".equals(operation)) {
            result = flyway.migrate();
        } else if ("undo".equals(operation)) {
            result = flyway.undo();
        } else if ("validate".equals(operation)) {
            if (commandLineArguments.shouldOutputJson()) {
                result = flyway.validateWithResult();
            } else {
                flyway.validate();
            }
        } else if ("info".equals(operation)) {
            MigrationInfoService info = flyway.info();
            MigrationInfo current = info.current();
            MigrationVersion currentSchemaVersion = current == null ? MigrationVersion.EMPTY : current.getVersion();
            MigrationVersion schemaVersionToOutput = currentSchemaVersion == null ? MigrationVersion.EMPTY : currentSchemaVersion;
            LOG.info("Schema version: " + schemaVersionToOutput);
            LOG.info("");
            result = info.getInfoResult();
            MigrationInfo[] infos = info.all();
            if (commandLineArguments.isFilterOnMigrationIds()) {
                System.out.print(Arrays.stream(infos).map(m -> m.getVersion() == null ? m.getDescription() : m.getVersion().getVersion()).collect(Collectors.joining(",")));
            } else {
                LOG.info(MigrationInfoDumper.dumpToAsciiTable((MigrationInfo[])infos));
            }
        } else {
            result = "repair".equals(operation) ? flyway.repair() : pluginRegister.getPlugins(CommandExtension.class).stream().filter(commandExtension -> commandExtension.handlesCommand(operation)).findFirst().map(commandExtension -> commandExtension.handle(operation, flyway.getConfiguration(), commandLineArguments.getFlags())).orElseThrow(() -> new FlywayException("No command extension found to handle command: " + operation));
        }
        return result;
    }

    private static void printJson(CommandLineArguments commandLineArguments, OperationResult object) {
        String json = Main.convertObjectToJsonString(object);
        if (commandLineArguments.isOutputFileSet()) {
            Path path = Paths.get(commandLineArguments.getOutputFile(), new String[0]);
            byte[] bytes = json.getBytes();
            try {
                Files.write(path, bytes, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                throw new FlywayException("Could not write to output file " + commandLineArguments.getOutputFile(), (Throwable)e);
            }
        }
        System.out.println(json);
    }

    private static String convertObjectToJsonString(Object object) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeSerializer()).create();
        return gson.toJson(object);
    }

    private static void initializeDefaults(Map<String, String> config, CommandLineArguments commandLineArguments) {
        String workingDirectory = commandLineArguments.isWorkingDirectorySet() ? commandLineArguments.getWorkingDirectory() : Main.getInstallationDir();
        config.put("flyway.locations", "filesystem:" + new File(workingDirectory, "sql").getAbsolutePath());
        File jarDir = new File(workingDirectory, "jars");
        if (jarDir.exists()) {
            config.put("flyway.jarDirs", jarDir.getAbsolutePath());
        }
    }

    private static void filterProperties(Map<String, String> config) {
        config.remove("flyway.jarDirs");
        config.remove("flyway.configFiles");
        config.remove("flyway.configFileEncoding");
    }

    private static void printUsage() {
        String indent = "    ";
        LOG.info("Usage");
        LOG.info(indent + "flyway [options] command");
        LOG.info("");
        LOG.info("By default, the configuration will be read from conf/flyway.conf.");
        LOG.info("Options passed from the command-line override the configuration.");
        LOG.info("");
        LOG.info("Commands");
        List<Pair> usages = pluginRegister.getPlugins(CommandExtension.class).stream().flatMap(e -> e.getUsage().stream()).collect(Collectors.toList());
        int padSize = usages.stream().max(Comparator.comparingInt(u -> ((String)u.getLeft()).length())).map(u -> ((String)u.getLeft()).length() + 3).orElse(11);
        LOG.info(indent + StringUtils.rightPad((String)"migrate", (int)padSize, (char)' ') + "Migrates the database");
        LOG.info(indent + StringUtils.rightPad((String)"clean", (int)padSize, (char)' ') + "Drops all objects in the configured schemas");
        LOG.info(indent + StringUtils.rightPad((String)"info", (int)padSize, (char)' ') + "Prints the information about applied, current and pending migrations");
        LOG.info(indent + StringUtils.rightPad((String)"validate", (int)padSize, (char)' ') + "Validates the applied migrations against the ones on the classpath");
        LOG.info(indent + StringUtils.rightPad((String)"baseline", (int)padSize, (char)' ') + "Baselines an existing database at the baselineVersion");
        LOG.info(indent + StringUtils.rightPad((String)"repair", (int)padSize, (char)' ') + "Repairs the schema history table");
        usages.forEach(u -> LOG.info(indent + StringUtils.rightPad((String)((String)u.getLeft()), (int)padSize, (char)' ') + (String)u.getRight()));
        LOG.info("");
        LOG.info("Configuration parameters (Format: -key=value)");
        LOG.info(indent + "driver                         Fully qualified classname of the JDBC driver");
        LOG.info(indent + "url                            Jdbc url to use to connect to the database");
        LOG.info(indent + "user                           User to use to connect to the database");
        LOG.info(indent + "password                       Password to use to connect to the database");
        LOG.info(indent + "connectRetries                 Maximum number of retries when attempting to connect to the database");
        LOG.info(indent + "initSql                        SQL statements to run to initialize a new database connection");
        LOG.info(indent + "schemas                        Comma-separated list of the schemas managed by Flyway");
        LOG.info(indent + "table                          Name of Flyway's schema history table");
        LOG.info(indent + "locations                      Classpath locations to scan recursively for migrations");
        LOG.info(indent + "failOnMissingLocations         Whether to fail if a location specified in the flyway.locations option doesn't exist");
        LOG.info(indent + "resolvers                      Comma-separated list of custom MigrationResolvers");
        LOG.info(indent + "skipDefaultResolvers           Skips default resolvers (jdbc, sql and Spring-jdbc)");
        LOG.info(indent + "sqlMigrationPrefix             File name prefix for versioned SQL migrations");
        LOG.info(indent + "undoSqlMigrationPrefix         [teams] File name prefix for undo SQL migrations");
        LOG.info(indent + "repeatableSqlMigrationPrefix   File name prefix for repeatable SQL migrations");
        LOG.info(indent + "sqlMigrationSeparator          File name separator for SQL migrations");
        LOG.info(indent + "sqlMigrationSuffixes           Comma-separated list of file name suffixes for SQL migrations");
        LOG.info(indent + "stream                         [teams] Stream SQL migrations when executing them");
        LOG.info(indent + "batch                          [teams] Batch SQL statements when executing them");
        LOG.info(indent + "mixed                          Allow mixing transactional and non-transactional statements");
        LOG.info(indent + "encoding                       Encoding of SQL migrations");
        LOG.info(indent + "detectEncoding                 [teams] Whether Flyway should try to automatically detect SQL migration file encoding");
        LOG.info(indent + "placeholderReplacement         Whether placeholders should be replaced");
        LOG.info(indent + "placeholders                   Placeholders to replace in sql migrations");
        LOG.info(indent + "placeholderPrefix              Prefix of every placeholder");
        LOG.info(indent + "placeholderSuffix              Suffix of every placeholder");
        LOG.info(indent + "scriptPlaceholderPrefix        Prefix of every script placeholder");
        LOG.info(indent + "scriptPlaceholderSuffix        Suffix of every script placeholder");
        LOG.info(indent + "lockRetryCount                 The maximum number of retries when trying to obtain a lock");
        LOG.info(indent + "jdbcProperties                 Properties to pass to the JDBC driver object");
        LOG.info(indent + "installedBy                    Username that will be recorded in the schema history table");
        LOG.info(indent + "target                         Target version up to which Flyway should use migrations");
        LOG.info(indent + "cherryPick                     [teams] Comma separated list of migrations that Flyway should consider when migrating");
        LOG.info(indent + "skipExecutingMigrations        [teams] Whether Flyway should skip actually executing the contents of the migrations");
        LOG.info(indent + "outOfOrder                     Allows migrations to be run \"out of order\"");
        LOG.info(indent + "callbacks                      Comma-separated list of FlywayCallback classes, or locations to scan for FlywayCallback classes");
        LOG.info(indent + "skipDefaultCallbacks           Skips default callbacks (sql)");
        LOG.info(indent + "validateOnMigrate              Validate when running migrate");
        LOG.info(indent + "validateMigrationNaming        Validate file names of SQL migrations (including callbacks)");
        LOG.info(indent + "ignoreMigrationPatterns        Patterns of migrations and states to ignore during validate");
        LOG.info(indent + "cleanOnValidationError         Automatically clean on a validation error");
        LOG.info(indent + "cleanDisabled                  Whether to disable clean");
        LOG.info(indent + "baselineVersion                Version to tag schema with when executing baseline");
        LOG.info(indent + "baselineDescription            Description to tag schema with when executing baseline");
        LOG.info(indent + "baselineOnMigrate              Baseline on migrate against uninitialized non-empty schema");
        LOG.info(indent + "configFiles                    Comma-separated list of config files to use");
        LOG.info(indent + "configFileEncoding             Encoding to use when loading the config files");
        LOG.info(indent + "jarDirs                        Comma-separated list of dirs for Jdbc drivers & Java migrations");
        LOG.info(indent + "createSchemas                  Whether Flyway should attempt to create the schemas specified in the schemas property");
        LOG.info(indent + "dryRunOutput                   [teams] File where to output the SQL statements of a migration dry run");
        LOG.info(indent + "errorOverrides                 [teams] Rules to override specific SQL states and errors codes");
        LOG.info(indent + "oracle.sqlplus                 [teams] Enable Oracle SQL*Plus command support");
        LOG.info(indent + "licenseKey                     [teams] Your Flyway license key");
        LOG.info(indent + "color                          Whether to colorize output. Values: always, never, or auto (default)");
        LOG.info(indent + "outputFile                     Send output to the specified file alongside the console");
        LOG.info(indent + "outputType                     Serialise the output in the given format, Values: json");
        LOG.info("");
        LOG.info("Flags");
        LOG.info(indent + "-X                Print debug output");
        LOG.info(indent + "-q                Suppress all output, except for errors and warnings");
        LOG.info(indent + "-n                Suppress prompting for a user and password");
        LOG.info(indent + "--help, -h, -?    Print this usage info and exit");
        LOG.info(indent + "-community        Run the Flyway Community Edition (default)");
        LOG.info(indent + "-teams            Run the Flyway Teams Edition");
        LOG.info("");
        LOG.info("Flyway Usage Example");
        LOG.info(indent + "flyway -user=myuser -password=s3cr3t -url=jdbc:h2:mem -placeholders.abc=def migrate");
        LOG.info("");
        LOG.info("More info at https://rd.gt/3Cc1xKC");
        LOG.info("Learn more about Flyway Teams edition at https://rd.gt/2VzHpkY");
    }

    private static List<File> getJdbcDriverJarFiles() {
        File driversDir = new File(Main.getInstallationDir(), "drivers");
        File[] files = driversDir.listFiles((dir, name) -> name.endsWith(".jar"));
        if (files == null) {
            LOG.debug("Directory for Jdbc Drivers not found: " + driversDir.getAbsolutePath());
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    private static List<File> getJavaMigrationJarFiles(Map<String, String> config) {
        String jarDirs = config.get("flyway.jarDirs");
        if (!StringUtils.hasLength((String)jarDirs)) {
            return Collections.emptyList();
        }
        jarDirs = jarDirs.replace(File.pathSeparator, ",");
        String[] dirs = StringUtils.tokenizeToStringArray((String)jarDirs, (String)",");
        ArrayList<File> jarFiles = new ArrayList<File>();
        for (String dirName : dirs) {
            File dir = new File(dirName);
            File[] files = dir.listFiles((dir1, name) -> name.endsWith(".jar"));
            if (files == null) {
                throw new FlywayException("Directory for Java Migrations not found: " + dirName);
            }
            jarFiles.addAll(Arrays.asList(files));
        }
        return jarFiles;
    }

    protected static void loadConfigurationFromConfigFiles(Map<String, String> config, CommandLineArguments commandLineArguments, Map<String, String> envVars) {
        String encoding = Main.determineConfigurationFileEncoding(commandLineArguments, envVars);
        File installationDir = new File(Main.getInstallationDir());
        config.putAll(ConfigUtils.loadDefaultConfigurationFiles((File)installationDir, (String)encoding));
        for (File configFile : Main.determineConfigFilesFromArgs(commandLineArguments, envVars)) {
            config.putAll(ConfigUtils.loadConfigurationFile((File)configFile, (String)encoding, (boolean)true));
        }
    }

    private static void promptForCredentialsIfMissing(Map<String, String> config) {
        Console console = System.console();
        if (console == null) {
            return;
        }
        if (!config.containsKey("flyway.url")) {
            return;
        }
        String url = config.get("flyway.url");
        if (!config.containsKey("flyway.user") && Main.needsUser(url, config.getOrDefault("flyway.password", null))) {
            config.put("flyway.user", console.readLine("Database user: ", new Object[0]));
        }
        if (!config.containsKey("flyway.password") && Main.needsPassword(url, config.get("flyway.user"))) {
            char[] password = console.readPassword("Database password: ", new Object[0]);
            config.put("flyway.password", password == null ? "" : String.valueOf(password));
        }
    }

    protected static boolean needsUser(String url, String password) {
        DatabaseType databaseType = DatabaseTypeRegister.getDatabaseTypeForUrl((String)url);
        return databaseType.detectUserRequiredByUrl(url);
    }

    protected static boolean needsPassword(String url, String username) {
        DatabaseType databaseType = DatabaseTypeRegister.getDatabaseTypeForUrl((String)url);
        return databaseType.detectPasswordRequiredByUrl(url);
    }

    private static List<File> determineConfigFilesFromArgs(CommandLineArguments commandLineArguments, Map<String, String> envVars) {
        String workingDirectory = commandLineArguments.isWorkingDirectorySet() ? commandLineArguments.getWorkingDirectory() : null;
        Stream configFilePaths = envVars.containsKey("flyway.configFiles") ? Arrays.stream(StringUtils.tokenizeToStringArray((String)envVars.get("flyway.configFiles"), (String)",")) : commandLineArguments.getConfigFiles().stream();
        return configFilePaths.map(path -> Paths.get(path, new String[0]).isAbsolute() ? new File((String)path) : new File(workingDirectory, (String)path)).collect(Collectors.toList());
    }

    private static String getInstallationDir() {
        String path = ClassUtils.getLocationOnDisk(Main.class);
        return new File(path).getParentFile().getParentFile().getParentFile().getAbsolutePath();
    }

    private static String determineConfigurationFileEncoding(CommandLineArguments commandLineArguments, Map<String, String> envVars) {
        if (envVars.containsKey("flyway.configFileEncoding")) {
            return envVars.get("flyway.configFileEncoding");
        }
        if (commandLineArguments.isConfigFileEncodingSet()) {
            return commandLineArguments.getConfigFileEncoding();
        }
        return "UTF-8";
    }

    static {
        pluginRegister = new PluginRegister();
    }
}

