/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resource.teams;

import com.google.cloud.storage.Blob;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;

public class GCSResource
extends LoadableResource {
    private static final Log LOG = LogFactory.getLog(GCSResource.class);
    private final Blob blob;
    private final Charset encoding;

    @Override
    public Reader read() {
        try {
            return Channels.newReader((ReadableByteChannel)this.blob.reader(new Blob.BlobSourceOption[0]), this.encoding.name());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            throw new FlywayException("Failed to get object from gcs: " + e.getMessage(), e);
        }
    }

    @Override
    public String getAbsolutePath() {
        return this.blob.getBucket().concat("/").concat(this.blob.getName());
    }

    @Override
    public String getAbsolutePathOnDisk() {
        return this.getAbsolutePath();
    }

    @Override
    public String getFilename() {
        String objectName = this.blob.getName();
        return objectName.substring(objectName.lastIndexOf(47) + 1);
    }

    @Override
    public String getRelativePath() {
        return this.getAbsolutePath();
    }

    public GCSResource(Blob blob, Charset encoding) {
        this.blob = blob;
        this.encoding = encoding;
    }
}

