/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.teams.db2zos;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.flywaydb.core.internal.database.base.Function;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.base.Type;
import org.flywaydb.core.internal.database.teams.db2zos.DB2zOSDatabase;
import org.flywaydb.core.internal.database.teams.db2zos.DB2zOSFunction;
import org.flywaydb.core.internal.database.teams.db2zos.DB2zOSTable;
import org.flywaydb.core.internal.database.teams.db2zos.DB2zOSType;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class DB2zOSSchema
extends Schema<DB2zOSDatabase, DB2zOSTable> {
    private final String tablespace;

    DB2zOSSchema(JdbcTemplate jdbcTemplate, DB2zOSDatabase database, String name, String tablespace) {
        super(jdbcTemplate, database, name);
        this.tablespace = tablespace;
    }

    @Override
    protected boolean doExists() throws SQLException {
        return true;
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        return this.jdbcTemplate.queryForInt("select count(*) from (select distinct SCHEMA\nfrom (select creator as SCHEMA from sysibm.systables\n         union all\n      select SCHEMA from sysibm.sysdatatypes\n         union all\n      select SCHEMA from sysibm.sysroutines\n         union all\n      select SCHEMA from sysibm.systriggers\n     ) a WHERE SCHEMA = ?)", this.name) == 0;
    }

    @Override
    protected void doCreate() {
    }

    @Override
    protected void doDrop() throws SQLException {
        this.clean();
    }

    @Override
    protected void doClean() throws SQLException {
        List<String> dropVersioningStatements = this.generateDropVersioningStatement();
        if (!dropVersioningStatements.isEmpty()) {
            for (String dropTableStatement : this.generateDropStatements("S", "TABLE")) {
                this.jdbcTemplate.execute(dropTableStatement, new Object[0]);
            }
        }
        for (String dropVersioningStatement : dropVersioningStatements) {
            this.jdbcTemplate.execute(dropVersioningStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatementsForViews()) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatements("A", "ALIAS")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatements("G", "TABLE")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatementsForTablespaces()) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (DB2zOSTable table : (DB2zOSTable[])this.allTables()) {
            table.drop();
        }
        for (String dropStatement : this.generateDropStatementsForSequences()) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatementsForProcedures()) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatementsForTriggers()) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (Function function : this.allFunctions()) {
            function.drop();
        }
        for (Type type : this.allTypes()) {
            type.drop();
        }
    }

    private List<String> generateDropStatementsForProcedures() throws SQLException {
        String dropProcGenQuery = "select SPECIFICNAME from SYSIBM.SYSROUTINES where ROUTINETYPE='P' and SCHEMA = '" + this.name + "'";
        return this.buildDropStatements("DROP PROCEDURE", dropProcGenQuery);
    }

    private List<String> generateDropStatementsForTriggers() throws SQLException {
        String dropTrigGenQuery = "select NAME from SYSIBM.SYSTRIGGERS where SCHEMA = '" + this.name + "'";
        return this.buildDropStatements("DROP TRIGGER", dropTrigGenQuery);
    }

    private List<String> generateDropStatementsForSequences() throws SQLException {
        String dropSeqGenQuery = "select NAME from SYSIBM.SYSSEQUENCES where SCHEMA = '" + this.name + "' and SEQTYPE='S'";
        return this.buildDropStatements("DROP SEQUENCE", dropSeqGenQuery);
    }

    private List<String> generateDropStatementsForViews() throws SQLException {
        String dropSeqGenQuery = "select NAME from sysibm.systables where CREATOR = '" + this.name + "' and TYPE='V'";
        return this.buildDropStatements("DROP VIEW", dropSeqGenQuery);
    }

    private List<String> generateDropStatementsForTablespaces() throws SQLException {
        ArrayList<String> dropStatements = new ArrayList<String>();
        HashSet<String> tablespaces = new HashSet<String>(this.jdbcTemplate.queryForStringList("select concat(DBNAME, concat('.', TSNAME)) from sysibm.systables where TYPE='T' and CREATOR = '" + this.name + "'", new String[0]));
        tablespaces.remove(this.tablespace);
        for (String ts : tablespaces) {
            dropStatements.add("DROP TABLESPACE " + ts);
        }
        return dropStatements;
    }

    private List<String> generateDropStatements(String tableType, String objectType) throws SQLException {
        String dropTablesGenQuery = "select NAME from sysibm.systables where TYPE='" + tableType + "' and CREATOR = '" + this.name + "'";
        return this.buildDropStatements("DROP " + objectType, dropTablesGenQuery);
    }

    private List<String> buildDropStatements(String dropPrefix, String query) throws SQLException {
        ArrayList<String> dropStatements = new ArrayList<String>();
        List<String> dbObjects = this.jdbcTemplate.queryForStringList(query, new String[0]);
        for (String dbObject : dbObjects) {
            dropStatements.add(dropPrefix + " " + ((DB2zOSDatabase)this.database).quote(this.name, dbObject));
        }
        return dropStatements;
    }

    private List<String> generateDropVersioningStatement() throws SQLException {
        DB2zOSTable[] versioningTables;
        ArrayList<String> dropVersioningStatements = new ArrayList<String>();
        for (DB2zOSTable table : versioningTables = this.findTables("select NAME from sysibm.systables where VERSIONING_TABLE <> '' and CREATOR = ?", this.name)) {
            dropVersioningStatements.add("ALTER TABLE " + table.toString() + " DROP VERSIONING");
        }
        return dropVersioningStatements;
    }

    private DB2zOSTable[] findTables(String sqlQuery, String ... params) throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList(sqlQuery, params);
        DB2zOSTable[] tables = new DB2zOSTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new DB2zOSTable(this.jdbcTemplate, (DB2zOSDatabase)this.database, this, tableNames.get(i));
        }
        return tables;
    }

    protected DB2zOSTable[] doAllTables() throws SQLException {
        return this.findTables("select NAME from sysibm.systables where TYPE='T' and CREATOR = ?", this.name);
    }

    @Override
    protected Function[] doAllFunctions() throws SQLException {
        List<String> functionNames = this.jdbcTemplate.queryForStringList("select SPECIFICNAME from SYSIBM.SYSROUTINES where ROUTINETYPE='F' AND ORIGIN <> 'S' and SCHEMA = ?", this.name);
        ArrayList<Function> functions = new ArrayList<Function>();
        for (String functionName : functionNames) {
            functions.add(this.getFunction(functionName, new String[0]));
        }
        return functions.toArray(new Function[0]);
    }

    @Override
    public Table getTable(String tableName) {
        return new DB2zOSTable(this.jdbcTemplate, (DB2zOSDatabase)this.database, this, tableName);
    }

    @Override
    protected Type getType(String typeName) {
        return new DB2zOSType(this.jdbcTemplate, (DB2zOSDatabase)this.database, this, typeName);
    }

    @Override
    public Function getFunction(String functionName, String ... args) {
        return new DB2zOSFunction(this.jdbcTemplate, this.database, this, functionName, args);
    }
}

