/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.sqlserver.teams;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.LicenseGuard;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.configuration.cleanmode.tier2.CleanModeConfigurationExtension;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.database.sqlserver.SQLServerConnection;

public class SQLServerDatabase
extends org.flywaydb.database.sqlserver.SQLServerDatabase {
    public SQLServerDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
        LicenseGuard.guard((Configuration)configuration, Arrays.asList(Edition.ENTERPRISE, Edition.PRO, Edition.TIER3), (String)"SQL Server Teams Extension");
    }

    protected void doCleanPostSchemas(Schema[] schemas) throws SQLException {
        super.doCleanPostSchemas(schemas);
        CleanModeConfigurationExtension cleanModeConfigurationExtension = (CleanModeConfigurationExtension)PluginRegister.getPlugin(CleanModeConfigurationExtension.class);
        if (cleanModeConfigurationExtension.getCleanMode() != CleanModeConfigurationExtension.Mode.ALL) {
            return;
        }
        if (this.supportsColumnEncryptionKeys()) {
            for (String statement : this.cleanColumnEncryptionKeys()) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (this.supportsColumnMasterKeys()) {
            for (String statement : this.cleanColumnMasterKeys()) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        for (String statement : this.cleanSymmetricKey()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanEventNotifications()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanDatabaseExtendedProperties()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanDatabaseRoles()) {
            this.executeIgnoringErrors(statement);
        }
        boolean oldAutoCommit = this.jdbcTemplate.getConnection().getAutoCommit();
        this.jdbcTemplate.getConnection().setAutoCommit(true);
        for (String statement : this.cleanFulltextStoplist()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanSearchPropertyList()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanFullTextCatalogs()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        this.jdbcTemplate.getConnection().setAutoCommit(oldAutoCommit);
    }

    private void executeIgnoringErrors(String statement) {
        try {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean supportsColumnEncryptionKeys() {
        return this.getVersion().isAtLeast("13");
    }

    private boolean supportsColumnMasterKeys() {
        return this.getVersion().isAtLeast("13");
    }

    private List<String> cleanFullTextCatalogs() throws SQLException {
        return this.jdbcTemplate.queryForStringList("SELECT name FROM sys.fulltext_catalogs", new String[0]).stream().map(name -> "DROP FULLTEXT CATALOG " + this.quote(new String[]{name})).collect(Collectors.toList());
    }

    private List<String> cleanColumnEncryptionKeys() throws SQLException {
        return this.jdbcTemplate.queryForStringList("SELECT name FROM sys.column_encryption_keys", new String[0]).stream().map(name -> "DROP COLUMN ENCRYPTION KEY " + this.quote(new String[]{name})).collect(Collectors.toList());
    }

    private List<String> cleanColumnMasterKeys() throws SQLException {
        return this.jdbcTemplate.queryForStringList("SELECT name FROM sys.column_master_keys", new String[0]).stream().map(name -> "DROP COLUMN MASTER KEY " + this.quote(new String[]{name})).collect(Collectors.toList());
    }

    private List<String> cleanSymmetricKey() throws SQLException {
        return this.jdbcTemplate.queryForStringList("SELECT name FROM sys.symmetric_keys", new String[0]).stream().map(name -> "DROP SYMMETRIC KEY " + this.quote(new String[]{name})).collect(Collectors.toList());
    }

    private List<String> cleanEventNotifications() throws SQLException {
        return this.jdbcTemplate.queryForStringList("SELECT name FROM sys.event_notifications", new String[0]).stream().map(name -> "DROP EVENT NOTIFICATION " + this.quote(new String[]{name}) + " ON DATABASE").collect(Collectors.toList());
    }

    private List<String> cleanDatabaseExtendedProperties() throws SQLException {
        return this.jdbcTemplate.queryForStringList("SELECT name FROM sys.extended_properties WHERE class = 0", new String[0]).stream().map(name -> "EXEC sp_dropextendedproperty  @name= " + this.quote(new String[]{name})).collect(Collectors.toList());
    }

    private List<String> cleanDatabaseRoles() throws SQLException {
        return this.jdbcTemplate.queryForStringList("SELECT name FROM sys.database_principals WHERE (type = 'A' OR type = 'R') AND is_fixed_role = 0", new String[0]).stream().map(name -> "DROP ROLE " + this.quote(new String[]{name})).collect(Collectors.toList());
    }

    private List<String> cleanFulltextStoplist() throws SQLException {
        return this.jdbcTemplate.queryForStringList("SELECT name FROM sys.fulltext_stoplists", new String[0]).stream().map(name -> "DROP FULLTEXT STOPLIST " + this.quote(new String[]{name}) + ";").collect(Collectors.toList());
    }

    private List<String> cleanSearchPropertyList() throws SQLException {
        return this.jdbcTemplate.queryForStringList("SELECT name FROM sys.registered_search_property_lists", new String[0]).stream().map(name -> "DROP SEARCH PROPERTY LIST " + this.quote(new String[]{name}) + ";").collect(Collectors.toList());
    }

    public Schema[] getAllSchemas() {
        try {
            List allSchemaNames = this.jdbcTemplate.queryForStringList("(SELECT s.name\nFROM sys.schemas s\nINNER JOIN sys.sysusers u ON u.uid = s.principal_id\nWHERE u.issqluser = 1 AND u.name NOT IN ('sys', 'guest', 'INFORMATION_SCHEMA')\n) UNION (\nSELECT s.name\nFROM sys.schemas s\nINNER JOIN sys.sysusers u ON u.uid = s.schema_id\nWHERE u.islogin = 1 AND u.name NOT IN ('sys', 'guest', 'INFORMATION_SCHEMA')\n) UNION (\nSELECT DISTINCT s.name\nFROM sys.schemas s\nINNER JOIN sys.objects o ON o.schema_id = s.schema_id\nWHERE o.is_ms_shipped = 0)", new String[0]);
            return (Schema[])allSchemaNames.stream().map(n -> ((SQLServerConnection)this.getMainConnection()).getSchema(n)).toArray(Schema[]::new);
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to determine all schemas", (Throwable)e);
        }
    }
}

