/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.secretsmanagement;

import java.util.Map;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.ConfigurationExtension;

public class DaprConfigurationExtension
implements ConfigurationExtension {
    private static final Log LOG = LogFactory.getLog(DaprConfigurationExtension.class);
    private static final String DAPR_URL = "flyway.plugins.dapr.url";
    private static final String DAPR_SECRETS = "flyway.plugins.dapr.secrets";
    private static final String DAPR_URL_DEPRECATED = "flyway.dapr.url";
    private static final String DAPR_SECRETS_DEPRECATED = "flyway.dapr.secrets";
    private String daprUrl;
    private String[] daprSecrets;

    public void extractParametersFromConfiguration(Map<String, String> configuration) {
        if (configuration.containsKey(DAPR_URL_DEPRECATED)) {
            LOG.warn("The 'flyway.dapr' parameters have been deprecated, and will be replaced with 'flyway.plugins.dapr'. Update your configuration to use the new names, see: https://rd.gt/3mUUFvE");
            this.extractDeprecatedConfiguration(configuration);
        } else {
            this.extractConfiguration(configuration);
        }
    }

    private void extractConfiguration(Map<String, String> configuration) {
        this.daprUrl = configuration.getOrDefault(DAPR_URL, this.daprUrl);
        String daprSecretsString = configuration.getOrDefault(DAPR_SECRETS, null);
        if (daprSecretsString != null) {
            this.daprSecrets = daprSecretsString.split(",");
        }
        configuration.remove(DAPR_URL);
        configuration.remove(DAPR_SECRETS);
    }

    private void extractDeprecatedConfiguration(Map<String, String> configuration) {
        this.daprUrl = configuration.getOrDefault(DAPR_URL_DEPRECATED, this.daprUrl);
        String daprSecretsString = configuration.getOrDefault(DAPR_SECRETS_DEPRECATED, null);
        if (daprSecretsString != null) {
            this.daprSecrets = daprSecretsString.split(",");
        }
        configuration.remove(DAPR_URL_DEPRECATED);
        configuration.remove(DAPR_SECRETS_DEPRECATED);
    }

    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        switch (environmentVariable) {
            case "FLYWAY_PLUGINS_DAPR_URL": {
                return DAPR_URL;
            }
            case "FLYWAY_PLUGINS_DAPR_SECRETS": {
                return DAPR_SECRETS;
            }
            case "FLYWAY_DAPR_URL": {
                return DAPR_URL_DEPRECATED;
            }
            case "FLYWAY_DAPR_SECRETS": {
                return DAPR_SECRETS_DEPRECATED;
            }
        }
        return null;
    }

    public void setDaprSecrets(String ... daprSecrets) {
        this.daprSecrets = daprSecrets;
    }

    public String getDaprUrl() {
        return this.daprUrl;
    }

    public String[] getDaprSecrets() {
        return this.daprSecrets;
    }

    public void setDaprUrl(String daprUrl) {
        this.daprUrl = daprUrl;
    }
}

