/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeVariable;
import org.hsqldb.SchemaObject;
import org.hsqldb.Table;
import org.hsqldb.types.Type;

public class Token {
    String tokenString = "";
    int tokenType = -1;
    Type dataType;
    Object tokenValue;
    String namePrefix;
    String namePrePrefix;
    String namePrePrePrefix;
    String charsetSchema;
    String charsetName;
    String fullString;
    int lobMultiplierType = -1;
    boolean isDelimiter;
    boolean isDelimitedIdentifier;
    boolean isDelimitedPrefix;
    boolean isDelimitedPrePrefix;
    boolean isDelimitedPrePrePrefix;
    boolean isUndelimitedIdentifier;
    boolean hasIrregularChar;
    boolean isReservedIdentifier;
    boolean isCoreReservedIdentifier;
    boolean isHostParameter;
    boolean isMalformed;
    int position;
    Object expression;
    boolean hasColumnList;

    void reset() {
        this.tokenString = "";
        this.tokenType = -1;
        this.dataType = null;
        this.tokenValue = null;
        this.namePrefix = null;
        this.namePrePrefix = null;
        this.namePrePrePrefix = null;
        this.charsetSchema = null;
        this.charsetName = null;
        this.fullString = null;
        this.lobMultiplierType = -1;
        this.isDelimiter = false;
        this.isDelimitedIdentifier = false;
        this.isDelimitedPrefix = false;
        this.isDelimitedPrePrefix = false;
        this.isDelimitedPrePrePrefix = false;
        this.isUndelimitedIdentifier = false;
        this.hasIrregularChar = false;
        this.isReservedIdentifier = false;
        this.isCoreReservedIdentifier = false;
        this.isHostParameter = false;
        this.isMalformed = false;
        this.expression = null;
        this.hasColumnList = false;
    }

    Token duplicate() {
        Token token = new Token();
        this.copyTo(token);
        return token;
    }

    private void copyTo(Token token) {
        token.tokenString = this.tokenString;
        token.tokenType = this.tokenType;
        token.dataType = this.dataType;
        token.tokenValue = this.tokenValue;
        token.namePrefix = this.namePrefix;
        token.namePrePrefix = this.namePrePrefix;
        token.namePrePrePrefix = this.namePrePrePrefix;
        token.charsetSchema = this.charsetSchema;
        token.charsetName = this.charsetName;
        token.fullString = this.fullString;
        token.lobMultiplierType = this.lobMultiplierType;
        token.isDelimiter = this.isDelimiter;
        token.isDelimitedIdentifier = this.isDelimitedIdentifier;
        token.isDelimitedPrefix = this.isDelimitedPrefix;
        token.isDelimitedPrePrefix = this.isDelimitedPrePrefix;
        token.isDelimitedPrePrePrefix = this.isDelimitedPrePrePrefix;
        token.isUndelimitedIdentifier = this.isUndelimitedIdentifier;
        token.hasIrregularChar = this.hasIrregularChar;
        token.isReservedIdentifier = this.isReservedIdentifier;
        token.isCoreReservedIdentifier = this.isCoreReservedIdentifier;
        token.isHostParameter = this.isHostParameter;
        token.isMalformed = this.isMalformed;
    }

    public String getFullString() {
        return this.fullString;
    }

    public void setExpression(Object object) {
        this.expression = object;
    }

    public void setWithColumnList() {
        this.hasColumnList = true;
    }

    String getSQL() {
        if (this.expression instanceof ExpressionColumn) {
            if (this.tokenType == 921) {
                StringBuilder stringBuilder = new StringBuilder();
                Expression expression = (Expression)this.expression;
                if (expression.opType == 98 && expression.nodes.length > 0) {
                    stringBuilder.append(' ');
                    for (int i = 0; i < expression.nodes.length; ++i) {
                        Object object;
                        Expression expression2 = expression.nodes[i];
                        ColumnSchema columnSchema = expression2.getColumn();
                        if (expression2.opType == 3) {
                            if (i > 0) {
                                stringBuilder.append(',');
                            }
                            stringBuilder.append(expression2.getColumnName());
                            continue;
                        }
                        if (expression2.getRangeVariable().tableAlias == null) {
                            object = columnSchema.getName().getSchemaQualifiedStatementName();
                        } else {
                            RangeVariable rangeVariable = expression2.getRangeVariable();
                            object = rangeVariable.tableAlias.getStatementName() + "." + columnSchema.getName().statementName;
                        }
                        if (i > 0) {
                            stringBuilder.append(',');
                        }
                        stringBuilder.append((String)object);
                    }
                } else {
                    return this.tokenString;
                }
                stringBuilder.append(' ');
                return stringBuilder.toString();
            }
        } else {
            if (this.expression instanceof Type) {
                this.isDelimiter = false;
                Type type = (Type)this.expression;
                if (type.isDistinctType() || type.isDomainType()) {
                    return type.getName().getSchemaQualifiedStatementName();
                }
                return type.getNameString();
            }
            if (this.expression instanceof ColumnSchema) {
                this.isDelimiter = false;
                ColumnSchema columnSchema = (ColumnSchema)this.expression;
                return columnSchema.getName().getSchemaQualifiedStatementName();
            }
            if (this.expression instanceof SchemaObject) {
                this.isDelimiter = false;
                Object object = ((SchemaObject)this.expression).getName().getSchemaQualifiedStatementName();
                if (this.hasColumnList) {
                    Table table = (Table)this.expression;
                    object = (String)object + table.getColumnListSQL(table.defaultColumnMap, table.defaultColumnMap.length);
                }
                return object;
            }
        }
        if (this.namePrefix == null && this.isUndelimitedIdentifier) {
            return this.tokenString;
        }
        if (this.tokenType == 1011) {
            return this.dataType.convertToSQLString(this.tokenValue);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.namePrePrefix != null) {
            if (this.isDelimitedPrePrefix) {
                stringBuilder.append('\"');
                stringBuilder.append(this.namePrePrefix);
                stringBuilder.append('\"');
            } else {
                stringBuilder.append(this.namePrePrefix);
            }
            stringBuilder.append('.');
        }
        if (this.namePrefix != null) {
            if (this.isDelimitedPrefix) {
                stringBuilder.append('\"');
                stringBuilder.append(this.namePrefix);
                stringBuilder.append('\"');
            } else {
                stringBuilder.append(this.namePrefix);
            }
            stringBuilder.append('.');
        }
        if (this.isDelimitedIdentifier) {
            stringBuilder.append('\"');
            stringBuilder.append(this.tokenString);
            stringBuilder.append('\"');
            this.isDelimiter = false;
        } else {
            stringBuilder.append(this.tokenString);
        }
        return stringBuilder.toString();
    }

    static String getSQL(Token[] tokenArray) {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < tokenArray.length; ++i) {
            String string = tokenArray[i].getSQL();
            if (!tokenArray[i].isDelimiter && !bl) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
            bl = tokenArray[i].isDelimiter;
        }
        return stringBuilder.toString();
    }

    static Object[] getSimplifiedTokens(Token[] tokenArray) {
        Object[] objectArray = new Object[tokenArray.length];
        for (int i = 0; i < tokenArray.length; ++i) {
            objectArray[i] = tokenArray[i].expression == null ? tokenArray[i].getSQL() : tokenArray[i].expression;
        }
        return objectArray;
    }
}

