/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import java.util.List;
import org.flywaydb.core.api.logging.Log;

class MultiLogger
implements Log {
    private final List<Log> logs;

    public MultiLogger(List<Log> logs) {
        this.logs = logs;
    }

    public boolean isDebugEnabled() {
        for (Log log : this.logs) {
            if (log.isDebugEnabled()) continue;
            return false;
        }
        return true;
    }

    public void debug(String message) {
        for (Log log : this.logs) {
            log.debug(message);
        }
    }

    public void info(String message) {
        for (Log log : this.logs) {
            log.info(message);
        }
    }

    public void warn(String message) {
        for (Log log : this.logs) {
            log.warn(message);
        }
    }

    public void error(String message) {
        for (Log log : this.logs) {
            log.error(message);
        }
    }

    public void error(String message, Exception e) {
        for (Log log : this.logs) {
            log.error(message, e);
        }
    }
}

