/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.configuration;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.flywaydb.commandline.Main;
import org.flywaydb.commandline.configuration.CommandLineArguments;
import org.flywaydb.commandline.configuration.CommandLineConfigurationUtils;
import org.flywaydb.commandline.configuration.ConfigurationManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.configuration.TomlUtils;
import org.flywaydb.core.internal.configuration.models.ConfigurationModel;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.configuration.models.FlywayEnvironmentModel;
import org.flywaydb.core.internal.license.FlywayRedgateEditionRequiredException;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.MergeUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class ModernConfigurationManager
implements ConfigurationManager {
    private static final Log LOG = LogFactory.getLog(ModernConfigurationManager.class);
    private static final Pattern ANY_WORD_BETWEEN_TWO_QUOTES_PATTERN = Pattern.compile("\\[\"([^\"]*)\"]");
    private static final String UNABLE_TO_PARSE_FIELD = "Unable to parse parameter '%s'.";
    private static final String FLYWAY_NAMESPACE = "flyway";

    @Override
    public Configuration getConfiguration(CommandLineArguments commandLineArguments) {
        String installDirectory = commandLineArguments.isWorkingDirectorySet() ? commandLineArguments.getWorkingDirectory() : ClassUtils.getInstallDir(Main.class);
        String workingDirectory = commandLineArguments.getWorkingDirectoryOrNull();
        List tomlFiles = ConfigUtils.getDefaultTomlConfigFileLocations((File)new File(ClassUtils.getInstallDir(Main.class)), (String)commandLineArguments.getWorkingDirectoryOrNull());
        tomlFiles.addAll(commandLineArguments.getConfigFilePathsFromEnv(true));
        tomlFiles.addAll(commandLineArguments.getConfigFiles().stream().map(File::new).toList());
        ConfigurationModel config = TomlUtils.loadConfigurationFiles(tomlFiles.stream().filter(File::exists).collect(Collectors.toList()));
        ConfigurationModel commandLineArgumentsModel = TomlUtils.loadConfigurationFromCommandlineArgs(commandLineArguments.getConfiguration(true));
        ConfigurationModel environmentVariablesModel = TomlUtils.loadConfigurationFromEnvironment();
        if (ConfigUtils.detectNullConfigModel((ConfigurationModel)environmentVariablesModel)) {
            LOG.debug("Skipping empty environment variables");
        } else {
            ConfigUtils.dumpConfigurationModel((ConfigurationModel)environmentVariablesModel, (String)"Loading configuration from environment variables:");
            config = config.merge(environmentVariablesModel);
        }
        if (ConfigUtils.detectNullConfigModel((ConfigurationModel)commandLineArgumentsModel)) {
            LOG.debug("No flyway namespace variables found in command line");
        } else {
            ConfigUtils.dumpConfigurationModel((ConfigurationModel)commandLineArgumentsModel, (String)"Loading configuration from command line arguments:");
            config = config.merge(commandLineArgumentsModel);
        }
        if (commandLineArgumentsModel.getEnvironments().containsKey("tempConfigEnvironment") || environmentVariablesModel.getEnvironments().containsKey("tempConfigEnvironment")) {
            EnvironmentModel defaultEnv = (EnvironmentModel)config.getEnvironments().get(config.getFlyway().getEnvironment());
            EnvironmentModel mergedModel = null;
            if (environmentVariablesModel.getEnvironments().containsKey("tempConfigEnvironment")) {
                EnvironmentModel environmentVariablesEnv = (EnvironmentModel)environmentVariablesModel.getEnvironments().get("tempConfigEnvironment");
                EnvironmentModel environmentModel = mergedModel = defaultEnv == null ? environmentVariablesEnv : defaultEnv.merge(environmentVariablesEnv);
            }
            if (commandLineArgumentsModel.getEnvironments().containsKey("tempConfigEnvironment")) {
                EnvironmentModel commandLineArgumentsEnv = (EnvironmentModel)commandLineArgumentsModel.getEnvironments().get("tempConfigEnvironment");
                EnvironmentModel environmentModel = mergedModel == null ? (defaultEnv == null ? commandLineArgumentsEnv : defaultEnv.merge(commandLineArgumentsEnv)) : (mergedModel = mergedModel.merge(commandLineArgumentsEnv));
            }
            if (mergedModel != null) {
                LOG.debug("Merged tempConfigEnvironment into the " + config.getFlyway().getEnvironment() + " environment");
                config.getEnvironments().put(config.getFlyway().getEnvironment(), mergedModel);
            }
            config.getEnvironments().remove("tempConfigEnvironment");
        }
        Map<String, Map<String, String>> envConfigs = commandLineArguments.getEnvironmentConfiguration();
        ObjectMapper objectMapper = new ObjectMapper();
        for (String envKey : envConfigs.keySet()) {
            try {
                Map<String, String> envValue = envConfigs.get(envKey);
                HashMap<String, FlywayEnvironmentModel> envValueObject = new HashMap<String, FlywayEnvironmentModel>();
                HashMap flywayEnvironmentModelArguments = new HashMap();
                envValue.entrySet().forEach(entry -> {
                    if (((String)entry.getKey()).startsWith("jdbcProperties.")) {
                        envValueObject.computeIfAbsent("jdbcProperties", s -> new HashMap());
                        ((Map)envValueObject.get("jdbcProperties")).put(((String)entry.getKey()).substring("jdbcProperties.".length()), (String)entry.getValue());
                    } else if (((String)entry.getKey()).startsWith("flyway.")) {
                        flywayEnvironmentModelArguments.put((String)entry.getKey(), (String)entry.getValue());
                    } else if (((String)entry.getKey()).equals("schemas")) {
                        envValueObject.put((String)entry.getKey(), (FlywayEnvironmentModel)Arrays.stream(((String)entry.getValue()).split(",")).map(String::trim).toList());
                    } else if (((String)entry.getKey()).startsWith("resolvers.")) {
                        ModernConfigurationManager.handleResolverCommandLineArgs(envKey, entry, envValueObject);
                    } else {
                        envValueObject.put((String)entry.getKey(), (FlywayEnvironmentModel)entry.getValue());
                    }
                });
                envValueObject.put(FLYWAY_NAMESPACE, new FlywayEnvironmentModel().merge((FlywayEnvironmentModel)TomlUtils.loadConfigurationFromCommandlineArgs(flywayEnvironmentModelArguments).getFlyway()));
                EnvironmentModel env = (EnvironmentModel)objectMapper.convertValue(envValueObject, EnvironmentModel.class);
                ConfigUtils.dumpEnvironmentModel((EnvironmentModel)env, (String)envKey, (String)"Loading environment configuration from command line:");
                if (config.getEnvironments().containsKey(envKey)) {
                    env = ((EnvironmentModel)config.getEnvironments().get(envKey)).merge(env);
                }
                config.getEnvironments().put(envKey, env);
            }
            catch (IllegalArgumentException exc) {
                String fieldName = exc.getMessage().split("\"")[1];
                throw new FlywayException(String.format("Failed to configure parameter: '%s' in your '%s' environment", fieldName, envKey));
            }
        }
        ConfigUtils.warnForUnknownEnvParameters((Map)config.getEnvironments());
        if (workingDirectory != null) {
            ConfigUtils.makeRelativeLocationsBasedOnWorkingDirectory((String)workingDirectory, (List)config.getFlyway().getLocations());
            ConfigUtils.makeRelativeLocationsInEnvironmentsBasedOnWorkingDirectory((String)workingDirectory, (Map)config.getEnvironments());
            ConfigUtils.makeRelativeJarDirsBasedOnWorkingDirectory((String)workingDirectory, (List)config.getFlyway().getJarDirs());
            ConfigUtils.makeRelativeJarDirsInEnvironmentsBasedOnWorkingDirectory((String)workingDirectory, (Map)config.getEnvironments());
        }
        ConfigUtils.dumpConfigurationModel((ConfigurationModel)config, (String)"Using configuration:");
        ClassicConfiguration cfg = new ClassicConfiguration(config);
        cfg.setWorkingDirectory(workingDirectory);
        this.configurePlugins(config, cfg);
        ModernConfigurationManager.loadJarDirsAndAddToClasspath(installDirectory, cfg);
        ModernConfigurationManager.setDefaultSqlLocation(installDirectory, cfg);
        return cfg;
    }

    private static void handleResolverCommandLineArgs(String environment, Map.Entry<String, String> resolverEntry, Map<? super String, Object> envValueObject) {
        String[] resolverParts = resolverEntry.getKey().split("\\.");
        if (resolverParts.length != 3) {
            throw new FlywayException(String.format("Invalid resolver configuration for environment %s: %s", environment, resolverEntry.getKey()));
        }
        Map resolvers = (Map)envValueObject.computeIfAbsent(resolverParts[0], s -> new HashMap());
        Map resolver = resolvers.computeIfAbsent(resolverParts[1], s -> new HashMap());
        resolver.put(resolverParts[2], resolverEntry.getValue());
    }

    private void configurePlugins(ConfigurationModel config, ClassicConfiguration cfg) {
        ArrayList<String> configuredPluginParameters = new ArrayList<String>();
        for (ConfigurationExtension configurationExtension : cfg.getPluginRegister().getPlugins(ConfigurationExtension.class)) {
            if (configurationExtension.getNamespace().isEmpty()) {
                this.processParametersByNamespace("plugins", config, configurationExtension, configuredPluginParameters);
            }
            this.processParametersByNamespace(configurationExtension.getNamespace(), config, configurationExtension, configuredPluginParameters);
        }
        boolean rootConfigurationsIsEmpty = config.getRootConfigurations().isEmpty();
        ArrayList<FlywayException> configurationExceptions = new ArrayList<FlywayException>();
        try {
            this.checkUnknownParamsInFlywayNamespace((FlywayEnvironmentModel)config.getFlyway(), configuredPluginParameters, rootConfigurationsIsEmpty, "flyway.");
        }
        catch (FlywayException e) {
            configurationExceptions.add(e);
        }
        try {
            this.checkUnknownParamsInFlywayNamespace(((EnvironmentModel)config.getEnvironments().get(cfg.getCurrentEnvironmentName())).getFlyway(), Collections.emptyList(), rootConfigurationsIsEmpty, "environments." + cfg.getCurrentEnvironmentName() + ".flyway.");
        }
        catch (FlywayException e) {
            configurationExceptions.add(e);
        }
        if (!configurationExceptions.isEmpty()) {
            ModernConfigurationManager.combineConfigurationExceptions(configurationExceptions);
        }
    }

    private static void setDefaultSqlLocation(String installDirectory, ClassicConfiguration cfg) {
        File sqlFolder = new File(installDirectory, "sql");
        Object[] defaultLocations = new Locations(ConfigurationModel.defaults().getFlyway().getLocations().toArray(new String[0])).getLocations().toArray(new Location[0]);
        if (ConfigUtils.shouldUseDefaultCliSqlLocation((File)sqlFolder, (!Arrays.equals(cfg.getLocations(), defaultLocations) ? 1 : 0) != 0)) {
            cfg.setLocations(new Location[]{new Location("filesystem:" + sqlFolder.getAbsolutePath())});
        }
    }

    private static void loadJarDirsAndAddToClasspath(String workingDirectory, ClassicConfiguration cfg) {
        ArrayList<String> jarDirs = new ArrayList<String>();
        File jarDir = new File(workingDirectory, "jars");
        ConfigUtils.warnIfUsingDeprecatedMigrationsFolder((File)jarDir, (String)".jar");
        if (jarDir.exists()) {
            jarDirs.add(jarDir.getAbsolutePath());
        }
        jarDirs.addAll(cfg.getJarDirs());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<File> jarFiles = new ArrayList<File>();
        jarFiles.addAll(CommandLineConfigurationUtils.getJdbcDriverJarFiles());
        jarFiles.addAll(CommandLineConfigurationUtils.getJavaMigrationJarFiles(jarDirs.toArray(new String[0])));
        if (!jarFiles.isEmpty()) {
            classLoader = ClassUtils.addJarsOrDirectoriesToClasspath((ClassLoader)classLoader, jarFiles);
        }
        cfg.setClassLoader(classLoader);
    }

    private void processParametersByNamespace(String namespace, ConfigurationModel config, ConfigurationExtension configurationExtension, List<String> configuredPluginParameters) {
        Map<String, Object> pluginConfigs = config.getFlyway().getPluginConfigurations();
        boolean suppressError = false;
        if (namespace.startsWith("\\")) {
            suppressError = true;
            namespace = namespace.substring(1);
            pluginConfigs = config.getRootConfigurations();
        }
        if (pluginConfigs.containsKey(namespace) || namespace.isEmpty()) {
            List<String> fields = Arrays.stream(configurationExtension.getClass().getDeclaredFields()).map(Field::getName).toList();
            Map<String, Object> values = !namespace.isEmpty() ? (Map)pluginConfigs.get(namespace) : pluginConfigs;
            values = values.entrySet().stream().filter(p -> fields.stream().anyMatch(k -> k.equalsIgnoreCase((String)p.getKey()))).collect(Collectors.toMap(p -> fields.stream().filter(q -> q.equalsIgnoreCase((String)p.getKey())).findFirst().orElse((String)p.getKey()), Map.Entry::getValue));
            try {
                if (configurationExtension.isStub() && new HashSet<String>(configuredPluginParameters).containsAll(values.keySet())) {
                    return;
                }
                Map<String, Object> finalValues = values;
                Arrays.stream(configurationExtension.getClass().getDeclaredFields()).filter(f -> List.of(Collection.class, List.class, String[].class).contains(f.getType())).forEach(f -> {
                    String fieldName = f.getName();
                    Object fieldValue = finalValues.get(fieldName);
                    if (fieldValue instanceof String) {
                        String fieldValueString = (String)fieldValue;
                        finalValues.put(fieldName, StringUtils.hasText((String)fieldValueString) ? fieldValueString.split(",") : new String[]{});
                    }
                });
                ObjectMapper mapper = new ObjectMapper();
                if (suppressError) {
                    mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                }
                ConfigurationExtension newConfigurationExtension = (ConfigurationExtension)mapper.convertValue(finalValues, configurationExtension.getClass());
                if (suppressError) {
                    try {
                        ConfigurationExtension configurationExtension2 = (ConfigurationExtension)new ObjectMapper().convertValue(finalValues, configurationExtension.getClass());
                    }
                    catch (IllegalArgumentException e) {
                        String string = ModernConfigurationManager.getFullFieldNameFromException(namespace, e);
                        LOG.warn(String.format(UNABLE_TO_PARSE_FIELD, string));
                    }
                }
                MergeUtils.mergeModel((Object)newConfigurationExtension, (Object)configurationExtension);
                if (!values.isEmpty()) {
                    for (Map.Entry entry : values.entrySet()) {
                        if ("plugins".equals(namespace)) {
                            LOG.warn("Deprecated namespace configured: 'plugins." + (String)entry.getKey() + "'. Please see https://rd.gt/4hA3C7Y");
                        }
                        if (entry.getValue() instanceof Map && namespace.isEmpty()) {
                            Map temp = (Map)entry.getValue();
                            configuredPluginParameters.addAll(temp.keySet());
                            continue;
                        }
                        configuredPluginParameters.add((String)entry.getKey());
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Throwable newConfigurationExtension = ExceptionUtils.getRootCause((Throwable)e);
                if (newConfigurationExtension instanceof FlywayRedgateEditionRequiredException) {
                    FlywayRedgateEditionRequiredException cause = (FlywayRedgateEditionRequiredException)newConfigurationExtension;
                    throw cause;
                }
                String fullFieldName = ModernConfigurationManager.getFullFieldNameFromException(namespace, e);
                Object message = String.format(UNABLE_TO_PARSE_FIELD, fullFieldName);
                message = (String)message + ExceptionUtils.getFlywayExceptionMessage((Throwable)e).map(text -> " " + text).orElse("");
                if (suppressError) {
                    LOG.warn((String)message);
                }
                LOG.error((String)message);
            }
        }
    }

    private static String getFullFieldNameFromException(String namespace, IllegalArgumentException e) {
        Matcher matcher = ANY_WORD_BETWEEN_TWO_QUOTES_PATTERN.matcher(e.getMessage());
        StringBuilder fullFieldName = new StringBuilder();
        if (!namespace.isEmpty()) {
            fullFieldName.append(namespace);
        }
        while (matcher.find()) {
            if (!fullFieldName.isEmpty()) {
                fullFieldName.append(".");
            }
            fullFieldName.append(matcher.group(1));
        }
        return fullFieldName.toString();
    }

    private void checkUnknownParamsInFlywayNamespace(FlywayEnvironmentModel flyway, Collection<String> configuredPluginParameters, boolean rootConfigurationsIsEmpty, String prefix) {
        Map pluginConfigurations = flyway.getPluginConfigurations();
        Map<String, List<String>> pluginParametersWhichShouldHaveBeenConfigured = this.getPluginParametersWhichShouldHaveBeenConfigured(pluginConfigurations);
        Map<String, List<String>> missingParams = ModernConfigurationManager.getUnrecognisedParameters(pluginParametersWhichShouldHaveBeenConfigured, configuredPluginParameters);
        if (!missingParams.isEmpty()) {
            ModernConfigurationManager.throwMissingParameters(flyway, missingParams, rootConfigurationsIsEmpty, prefix);
        }
    }

    private static Map<String, List<String>> getUnrecognisedParameters(Map<String, List<String>> pluginParametersWhichShouldHaveBeenConfigured, Collection<String> configuredPluginParameters) {
        HashMap<String, List<String>> missingParams = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : pluginParametersWhichShouldHaveBeenConfigured.entrySet()) {
            List missing = entry.getValue().stream().filter(p -> !configuredPluginParameters.contains(p)).collect(Collectors.toList());
            if (missing.isEmpty()) continue;
            missingParams.put(entry.getKey(), missing);
        }
        return missingParams;
    }

    private Map<String, List<String>> getPluginParametersWhichShouldHaveBeenConfigured(Map<String, Object> pluginConfigurations) {
        HashMap<String, List<String>> pluginParametersWhichShouldHaveBeenConfigured = new HashMap<String, List<String>>();
        for (Map.Entry<String, Object> configuration : pluginConfigurations.entrySet()) {
            Object object = configuration.getValue();
            if (object instanceof Map) {
                Map temp = (Map)object;
                pluginParametersWhichShouldHaveBeenConfigured.put(configuration.getKey(), temp.keySet().stream().map(Object::toString).toList());
                continue;
            }
            if (!pluginParametersWhichShouldHaveBeenConfigured.containsKey(FLYWAY_NAMESPACE)) {
                pluginParametersWhichShouldHaveBeenConfigured.put(FLYWAY_NAMESPACE, new ArrayList());
            }
            ((List)pluginParametersWhichShouldHaveBeenConfigured.get(FLYWAY_NAMESPACE)).add(configuration.getKey());
        }
        return pluginParametersWhichShouldHaveBeenConfigured;
    }

    private static void throwMissingParameters(FlywayEnvironmentModel model, Map<String, ? extends List<String>> missingParams, boolean rootConfigurationsIsEmpty, String prefix) {
        if (rootConfigurationsIsEmpty) {
            StringBuilder exceptionMessage = new StringBuilder();
            if (missingParams.containsKey(FLYWAY_NAMESPACE)) {
                Map<String, List> possibleConfiguration = missingParams.get(FLYWAY_NAMESPACE).stream().collect(Collectors.toMap(p -> p, p -> ConfigUtils.getPossibleFlywayConfigurations((String)p, (FlywayEnvironmentModel)model)));
                for (Map.Entry<String, List> entry : possibleConfiguration.entrySet()) {
                    exceptionMessage.append("\t").append("Parameter: ").append(prefix).append(entry.getKey()).append("\n");
                    if (entry.getValue().isEmpty()) continue;
                    exceptionMessage.append("\t\t").append("Possible values:").append("\n");
                    entry.getValue().forEach(v -> exceptionMessage.append("\t\t").append("- ").append(prefix).append((String)v).append("\n"));
                }
            }
            missingParams.entrySet().stream().filter(e -> !((String)e.getKey()).equals(FLYWAY_NAMESPACE)).forEach(e -> ((List)e.getValue()).forEach(p -> exceptionMessage.append("\t").append("Parameter:").append(prefix).append((String)e.getKey()).append(".").append((String)p).append("\n")));
            exceptionMessage.deleteCharAt(exceptionMessage.length() - 1);
            throw new FlywayException(exceptionMessage.toString());
        }
    }

    private static void combineConfigurationExceptions(Iterable<? extends FlywayException> configurationExceptions) {
        StringBuilder exceptionMessage = new StringBuilder("Failed to configure parameters:").append("\n");
        configurationExceptions.forEach(e -> exceptionMessage.append(e.getMessage()).append("\n"));
        exceptionMessage.deleteCharAt(exceptionMessage.length() - 1);
        FlywayException flywayException = new FlywayException(exceptionMessage.toString());
        configurationExceptions.forEach(flywayException::addSuppressed);
        throw flywayException;
    }
}

