/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.configuration;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.flywaydb.commandline.Main;
import org.flywaydb.commandline.configuration.CommandLineArguments;
import org.flywaydb.commandline.configuration.ConfigurationManager;
import org.flywaydb.commandline.configuration.LegacyConfigurationManager;
import org.flywaydb.commandline.configuration.ModernConfigurationManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.util.ClassUtils;

public class ConfigurationManagerImpl
implements ConfigurationManager {
    @Generated
    private static final Log LOG = LogFactory.getLog(ConfigurationManagerImpl.class);

    @Override
    public Configuration getConfiguration(CommandLineArguments commandLineArguments) {
        ConfigurationManager configurationManager = this.useModernConfig(commandLineArguments) ? new ModernConfigurationManager() : new LegacyConfigurationManager();
        return configurationManager.getConfiguration(commandLineArguments);
    }

    boolean useModernConfig(CommandLineArguments commandLineArguments) {
        List<File> legacyFiles;
        List<File> legacyConfigFiles;
        List<File> tomlConfigFiles;
        Boolean result;
        List<String> configFiles = commandLineArguments.getConfigFiles();
        List<File> configFilesExist = configFiles.stream().map(File::new).filter(File::exists).toList();
        if (configFilesExist.size() != configFiles.size()) {
            LOG.warn("One or more specified configuration files could not be found: " + configFiles.stream().map(File::new).filter(x -> !configFilesExist.contains(x)).map(File::getAbsolutePath).collect(Collectors.joining(", ")) + System.lineSeparator());
        }
        if ((result = this.useModernConfigBasedOnFileLists(tomlConfigFiles = configFiles.stream().filter(s -> s.endsWith(".toml")).map(File::new).filter(File::exists).toList(), legacyConfigFiles = configFilesExist.stream().filter(x -> !tomlConfigFiles.contains(x)).toList(), true, null)) != null) {
            return result;
        }
        List<File> tomlFiles = commandLineArguments.getConfigFilePathsFromEnv(true);
        result = this.useModernConfigBasedOnFileLists(tomlFiles, legacyFiles = commandLineArguments.getConfigFilePathsFromEnv(false), true, null);
        if (result != null) {
            return result;
        }
        String workingDirectory = commandLineArguments.getWorkingDirectoryOrNull();
        tomlFiles = ConfigUtils.getDefaultTomlConfigFileLocations((File)new File(ClassUtils.getInstallDir(Main.class)), (String)workingDirectory).stream().filter(File::exists).toList();
        legacyFiles = ConfigUtils.getDefaultLegacyConfigurationFiles((File)new File(ClassUtils.getInstallDir(Main.class)), (String)workingDirectory).stream().filter(File::exists).toList();
        return this.useModernConfigBasedOnFileLists(tomlFiles, legacyFiles, false, true);
    }

    private Boolean useModernConfigBasedOnFileLists(List<File> tomlConfigFiles, List<File> legacyConfigFiles, boolean throwsExceptionIfCoexistent, Boolean defaultResult) {
        if (!tomlConfigFiles.isEmpty()) {
            if (!legacyConfigFiles.isEmpty() && throwsExceptionIfCoexistent) {
                throw new FlywayException("Using both TOML configuration and CONF configuration is not supported. Please remove the CONF configuration files.\nTOML files: " + tomlConfigFiles.stream().map(File::getAbsolutePath).collect(Collectors.joining(", ")) + System.lineSeparator() + "CONF files: " + legacyConfigFiles.stream().map(File::getAbsolutePath).collect(Collectors.joining(", ")) + System.lineSeparator());
            }
            return true;
        }
        if (!legacyConfigFiles.isEmpty()) {
            LOG.debug("Using legacy configuration as CONF files detected on disk or specified in commandline or environment variables: " + legacyConfigFiles.stream().map(File::getAbsolutePath).collect(Collectors.joining(", ")) + System.lineSeparator());
            return false;
        }
        return defaultResult;
    }
}

