/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.commandline.Main;
import org.flywaydb.commandline.configuration.CommandLineArguments;
import org.flywaydb.commandline.configuration.CommandLineConfigurationUtils;
import org.flywaydb.commandline.configuration.ConfigurationManager;
import org.flywaydb.commandline.configuration.LegacyConfigurationManager;
import org.flywaydb.commandline.configuration.ModernConfigurationManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.util.ClassUtils;

public class ConfigurationManagerImpl
implements ConfigurationManager {
    private static final Log LOG = LogFactory.getLog(ConfigurationManagerImpl.class);

    @Override
    public Configuration getConfiguration(CommandLineArguments commandLineArguments) {
        ConfigurationManager configurationManager = this.useModernConfig(commandLineArguments) ? new ModernConfigurationManager() : new LegacyConfigurationManager();
        return configurationManager.getConfiguration(commandLineArguments);
    }

    private boolean useModernConfig(CommandLineArguments commandLineArguments) {
        List<File> configFilesExist;
        List<File> tomlConfigFiles = commandLineArguments.getConfigFiles().stream().filter(s -> s.endsWith(".toml")).map(File::new).toList();
        if (!tomlConfigFiles.isEmpty() && (configFilesExist = commandLineArguments.getConfigFiles().stream().map(File::new).filter(File::exists).toList()).size() != tomlConfigFiles.size()) {
            throw new FlywayException("Using both TOML configuration and CONF configuration is not supported. Please remove the CONF configuration files.\nTOML files: " + tomlConfigFiles.stream().map(File::getAbsolutePath).collect(Collectors.joining(", ")) + "\nCONF files: " + configFilesExist.stream().map(File::getAbsolutePath).collect(Collectors.joining(", ")) + "\n");
        }
        if (tomlConfigFiles.stream().anyMatch(File::exists)) {
            return true;
        }
        ArrayList<File> tomlFiles = new ArrayList<File>();
        tomlFiles.addAll(ConfigUtils.getDefaultTomlConfigFileLocations((File)new File(ClassUtils.getInstallDir(Main.class))));
        tomlFiles.addAll(CommandLineConfigurationUtils.getTomlConfigFilePaths());
        return tomlFiles.stream().anyMatch(File::exists);
    }
}

