/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.command.version;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.commandline.command.version.PluginVersionResult;
import org.flywaydb.commandline.command.version.VersionResult;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.extensibility.Plugin;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;

public class VersionCommandExtension
implements CommandExtension {
    private static final Log LOG = LogFactory.getLog(VersionCommandExtension.class);
    public static final String VERSION = "version";
    public static final List<String> FLAGS = Arrays.asList("-v", "--version");

    public boolean handlesCommand(String command) {
        return command.equals(VERSION);
    }

    public String getCommandForFlag(String flag) {
        if (FLAGS.contains(flag.toLowerCase())) {
            return VERSION;
        }
        return super.getCommandForFlag(flag);
    }

    public boolean handlesParameter(String parameter) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OperationResult handle(String command, Configuration config, List<String> flags, FlywayTelemetryManager flywayTelemetryManager) throws FlywayException {
        EventTelemetryModel telemetryModel = new EventTelemetryModel(VERSION, flywayTelemetryManager);
        try {
            LOG.debug("Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
            LOG.debug(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "\n");
            List allPlugins = config.getPluginRegister().getPlugins(Plugin.class);
            List<PluginVersionResult> pluginVersions = allPlugins.stream().map(p -> new PluginVersionResult(p.getName(), p.getPluginVersion(config), p.isLicensed(config))).filter(p -> StringUtils.hasText((String)p.version)).collect(Collectors.toList());
            if (!pluginVersions.isEmpty()) {
                int nameLength = pluginVersions.stream().map(p -> p.name.length()).max(Integer::compare).get() + 2;
                int versionLength = pluginVersions.stream().map(p -> p.version.length()).max(Integer::compare).get() + 2;
                LOG.info(StringUtils.rightPad((String)"Plugin Name", (int)nameLength, (char)' ') + " | " + StringUtils.rightPad((String)"Version", (int)versionLength, (char)' '));
                LOG.info(StringUtils.rightPad((String)StringUtils.leftPad((String)"", (int)nameLength, (char)'-'), (int)nameLength, (char)' ') + " | " + StringUtils.rightPad((String)StringUtils.leftPad((String)"", (int)versionLength, (char)'-'), (int)versionLength, (char)' '));
                for (PluginVersionResult p2 : pluginVersions) {
                    LOG.info(StringUtils.rightPad((String)p2.name, (int)nameLength, (char)' ') + " | " + StringUtils.rightPad((String)p2.version, (int)versionLength, (char)' '));
                }
            }
            VersionResult versionResult = new VersionResult(VersionPrinter.getVersion(), command, LicenseGuard.getTier((Configuration)config), pluginVersions);
            return versionResult;
        }
        catch (Exception e) {
            telemetryModel.setException(e);
            throw e;
        }
        finally {
            try {
                telemetryModel.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public List<Pair<String, String>> getUsage() {
        return Collections.singletonList(Pair.of((Object)("version, " + String.join((CharSequence)", ", FLAGS)), (Object)"Print the Flyway version and edition"));
    }
}

