/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.configuration;

import java.io.Console;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flywaydb.commandline.Main;
import org.flywaydb.commandline.configuration.CommandLineArguments;
import org.flywaydb.commandline.configuration.CommandLineConfigurationUtils;
import org.flywaydb.commandline.configuration.ConfigurationManager;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class LegacyConfigurationManager
implements ConfigurationManager {
    @Override
    public Configuration getConfiguration(CommandLineArguments commandLineArguments) {
        Map<String, String> config = new HashMap<String, String>();
        String workingDirectory = commandLineArguments.isWorkingDirectorySet() ? commandLineArguments.getWorkingDirectory() : ClassUtils.getInstallDir(Main.class);
        File jarDir = new File(workingDirectory, "jars");
        ConfigUtils.warnIfUsingDeprecatedMigrationsFolder((File)jarDir, (String)".jar");
        if (jarDir.exists()) {
            config.put("flyway.jarDirs", jarDir.getAbsolutePath());
        }
        Map envVars = ConfigUtils.environmentVariablesToPropertyMap();
        this.loadConfigurationFromConfigFiles(config, commandLineArguments, envVars);
        config.putAll(envVars);
        config = LegacyConfigurationManager.overrideConfiguration(config, commandLineArguments.getConfiguration(false));
        File sqlFolder = new File(workingDirectory, "sql");
        if (ConfigUtils.shouldUseDefaultCliSqlLocation((File)sqlFolder, (boolean)StringUtils.hasText((String)config.get("flyway.locations")))) {
            config.put("flyway.locations", "filesystem:" + sqlFolder.getAbsolutePath());
        }
        if (commandLineArguments.isWorkingDirectorySet()) {
            ConfigUtils.makeRelativeLocationsBasedOnWorkingDirectory((String)commandLineArguments.getWorkingDirectory(), config);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<File> jarFiles = new ArrayList<File>(CommandLineConfigurationUtils.getJdbcDriverJarFiles());
        String jarDirs = config.get("flyway.jarDirs");
        if (StringUtils.hasText((String)jarDirs)) {
            jarFiles.addAll(CommandLineConfigurationUtils.getJavaMigrationJarFiles(StringUtils.tokenizeToStringArray((String)jarDirs.replace(File.pathSeparator, ","), (String)",")));
        }
        if (!jarFiles.isEmpty()) {
            classLoader = ClassUtils.addJarsOrDirectoriesToClasspath((ClassLoader)classLoader, jarFiles);
        }
        ConfigUtils.dumpConfigurationMap(config);
        this.filterProperties(config);
        FluentConfiguration configuration = new FluentConfiguration(classLoader).configuration(config).workingDirectory(workingDirectory);
        if (!commandLineArguments.shouldSuppressPrompt()) {
            this.promptForCredentialsIfMissing(config, (Configuration)configuration);
        }
        return configuration;
    }

    protected void loadConfigurationFromConfigFiles(Map<String, String> config, CommandLineArguments commandLineArguments, Map<String, String> envVars) {
        String encoding = LegacyConfigurationManager.determineConfigurationFileEncoding(commandLineArguments, envVars);
        File installationDir = new File(ClassUtils.getInstallDir(Main.class));
        config.putAll(ConfigUtils.loadDefaultConfigurationFiles((File)installationDir, (String)encoding));
        for (File configFile : LegacyConfigurationManager.determineLegacyConfigFilesFromArgs(commandLineArguments, envVars)) {
            config.putAll(ConfigUtils.loadConfigurationFile((File)configFile, (String)encoding, (boolean)true));
        }
    }

    private static String determineConfigurationFileEncoding(CommandLineArguments commandLineArguments, Map<String, String> envVars) {
        if (envVars.containsKey("flyway.configFileEncoding")) {
            return envVars.get("flyway.configFileEncoding");
        }
        if (commandLineArguments.isConfigFileEncodingSet()) {
            return commandLineArguments.getConfigFileEncoding();
        }
        return "UTF-8";
    }

    private static List<File> determineLegacyConfigFilesFromArgs(CommandLineArguments commandLineArguments, Map<String, String> envVars) {
        String workingDirectory = commandLineArguments.isWorkingDirectorySet() ? commandLineArguments.getWorkingDirectory() : null;
        Stream configFilePaths = envVars.containsKey("flyway.configFiles") ? Arrays.stream(StringUtils.tokenizeToStringArray((String)envVars.get("flyway.configFiles"), (String)",")) : commandLineArguments.getConfigFiles().stream();
        return configFilePaths.map(path -> Paths.get(path, new String[0]).isAbsolute() ? new File((String)path) : new File(workingDirectory, (String)path)).collect(Collectors.toList());
    }

    private static Map<String, String> overrideConfiguration(Map<String, String> existingConfiguration, Map<String, String> newConfiguration) {
        HashMap<String, String> combinedConfiguration = new HashMap<String, String>();
        combinedConfiguration.putAll(existingConfiguration);
        combinedConfiguration.putAll(newConfiguration);
        return combinedConfiguration;
    }

    private void promptForCredentialsIfMissing(Map<String, String> config, Configuration configuration) {
        boolean hasPassword;
        boolean hasUser;
        Console console = System.console();
        if (console == null) {
            return;
        }
        if (!config.containsKey("flyway.url")) {
            return;
        }
        String url = config.get("flyway.url");
        boolean bl = hasUser = config.containsKey("flyway.user") || config.keySet().stream().anyMatch(p -> p.toLowerCase().endsWith(".user"));
        if (!hasUser && this.needsUser(url, config.getOrDefault("flyway.password", null), configuration)) {
            config.put("flyway.user", console.readLine("Database user: ", new Object[0]));
        }
        boolean bl2 = hasPassword = config.containsKey("flyway.password") || config.keySet().stream().anyMatch(p -> p.toLowerCase().endsWith(".password"));
        if (!hasPassword && this.needsPassword(url, config.get("flyway.user"), configuration)) {
            char[] password = console.readPassword("Database password: ", new Object[0]);
            config.put("flyway.password", password == null ? "" : String.valueOf(password));
        }
    }

    boolean needsUser(String url, String password, Configuration configuration) {
        DatabaseType databaseType = DatabaseTypeRegister.getDatabaseTypeForUrl((String)url);
        return databaseType.detectUserRequiredByUrl(url);
    }

    boolean needsPassword(String url, String username, Configuration configuration) {
        DatabaseType databaseType = DatabaseTypeRegister.getDatabaseTypeForUrl((String)url);
        return databaseType.detectPasswordRequiredByUrl(url);
    }

    private void filterProperties(Map<String, String> config) {
        config.remove("flyway.jarDirs");
        config.remove("flyway.configFiles");
        config.remove("flyway.configFileEncoding");
    }
}

