/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter.junit;

import java.util.ArrayList;
import java.util.List;
import org.fluentlenium.adapter.junit.After;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class FluentTestRule
implements TestRule {
    private final Object target;
    private final TestClass testClass;
    private final List<FrameworkMethod> afters;
    boolean customAftersTriggered;

    public FluentTestRule(Object target) {
        this.target = target;
        this.testClass = new TestClass(target.getClass());
        this.afters = this.testClass.getAnnotatedMethods(After.class);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors;
                block15: {
                    errors = new ArrayList<Throwable>();
                    FluentTestRule.this.starting(description);
                    base.evaluate();
                    FluentTestRule.this.succeeded(description);
                    try {
                        if (!FluentTestRule.this.customAftersTriggered) {
                            FluentTestRule.this.triggerCustomAfters(errors);
                        }
                        FluentTestRule.this.finished(description);
                    }
                    catch (Throwable failedException) {
                        errors.add(failedException);
                    }
                    break block15;
                    catch (Throwable e) {
                        try {
                            errors.add(e);
                            try {
                                FluentTestRule.this.failed(e, description);
                            }
                            catch (Throwable failedException) {
                                errors.add(failedException);
                            }
                            FluentTestRule.this.triggerCustomAfters(errors);
                        }
                        catch (Throwable throwable) {
                            try {
                                if (!FluentTestRule.this.customAftersTriggered) {
                                    FluentTestRule.this.triggerCustomAfters(errors);
                                }
                                FluentTestRule.this.finished(description);
                            }
                            catch (Throwable failedException) {
                                errors.add(failedException);
                            }
                            throw throwable;
                        }
                        try {
                            if (!FluentTestRule.this.customAftersTriggered) {
                                FluentTestRule.this.triggerCustomAfters(errors);
                            }
                            FluentTestRule.this.finished(description);
                        }
                        catch (Throwable failedException) {
                            errors.add(failedException);
                        }
                    }
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    void triggerCustomAfters(List<Throwable> errors) {
        for (FrameworkMethod each : this.afters) {
            try {
                each.invokeExplosively(this.target, new Object[0]);
            }
            catch (Throwable afterException) {
                errors.add(afterException);
            }
        }
        this.customAftersTriggered = true;
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable e, Description description) {
    }

    protected void starting(Description description) {
    }

    protected void finished(Description description) {
    }
}

