/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter.junit;

import java.util.ArrayList;
import java.util.List;
import org.fluentlenium.adapter.junit.After;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

class FluentTestRule
implements TestRule {
    private final Object target;
    private final TestClass testClass;
    private final List<FrameworkMethod> afters;

    FluentTestRule(Object target) {
        this.target = target;
        this.testClass = new TestClass(target.getClass());
        this.afters = this.testClass.getAnnotatedMethods(After.class);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                try {
                    FluentTestRule.this.starting(description);
                    base.evaluate();
                    FluentTestRule.this.succeeded(description);
                }
                catch (Throwable e) {
                    errors.add(e);
                    try {
                        FluentTestRule.this.failed(e, description);
                    }
                    catch (Throwable failedException) {
                        errors.add(failedException);
                    }
                    for (FrameworkMethod each : FluentTestRule.this.afters) {
                        try {
                            each.invokeExplosively(FluentTestRule.this.target, new Object[0]);
                        }
                        catch (Throwable afterException) {
                            errors.add(afterException);
                        }
                    }
                }
                finally {
                    try {
                        FluentTestRule.this.finished(description);
                    }
                    catch (Throwable failedException) {
                        errors.add(failedException);
                    }
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable e, Description description) {
    }

    protected void starting(Description description) {
    }

    protected void finished(Description description) {
    }
}

