/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.assertj.custom;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.fluentlenium.core.domain.FluentWebElement;

public class FluentWebElementAssert
extends AbstractAssert<FluentWebElementAssert, FluentWebElement> {
    public FluentWebElementAssert(FluentWebElement actual) {
        super((Object)actual, FluentWebElementAssert.class);
    }

    private void failIsEnabled() {
        this.failWithMessage("Object not enabled");
    }

    private void failIsNotEnabled() {
        this.failWithMessage("Object is enabled");
    }

    public FluentWebElementAssert isEnabled() {
        if (!((FluentWebElement)this.actual).enabled()) {
            this.failIsEnabled();
        }
        return this;
    }

    public FluentWebElementAssert isNotEnabled() {
        if (((FluentWebElement)this.actual).enabled()) {
            this.failIsNotEnabled();
        }
        return this;
    }

    public FluentWebElementAssert isDisplayed() {
        if (!((FluentWebElement)this.actual).displayed()) {
            this.failIsNotDisplayed();
        }
        return this;
    }

    public FluentWebElementAssert isNotDisplayed() {
        if (((FluentWebElement)this.actual).displayed()) {
            this.failIsDisplayed();
        }
        return this;
    }

    private void failIsDisplayed() {
        this.failWithMessage("Object not displayed");
    }

    private void failIsNotDisplayed() {
        this.failWithMessage("Object is displayed");
    }

    public FluentWebElementAssert isSelected() {
        if (!((FluentWebElement)this.actual).selected()) {
            this.failIsSelected();
        }
        return this;
    }

    public FluentWebElementAssert isNotSelected() {
        if (((FluentWebElement)this.actual).selected()) {
            this.failIsNotSelected();
        }
        return this;
    }

    protected void failWithMessage(String errorMessage) {
        super.failWithMessage(errorMessage.replaceAll("(?:[^%]|\\A)%(?:[^%]|\\z)", "%%"), new Object[0]);
    }

    public FluentWebElementAssert hasText(String textToFind) {
        String actualText = ((FluentWebElement)this.actual).text();
        if (!actualText.contains(textToFind)) {
            this.failWithMessage("The element does not contain the text: " + textToFind + " . Actual text found : " + actualText);
        }
        return this;
    }

    public FluentWebElementAssert hasTextMatching(String regexToBeMatched) {
        String actualText = ((FluentWebElement)this.actual).text();
        if (!actualText.matches(regexToBeMatched)) {
            this.failWithMessage("The element does not match the regex: " + regexToBeMatched + " . Actual text found : " + actualText);
        }
        return this;
    }

    public FluentWebElementAssert hasNotText(String textToFind) {
        if (((FluentWebElement)this.actual).text().contains(textToFind)) {
            this.failWithMessage("The element contain the text: " + textToFind);
        }
        return this;
    }

    private void failIsSelected() {
        this.failWithMessage("Object not selected");
    }

    private void failIsNotSelected() {
        this.failWithMessage("Object is selected");
    }

    public FluentWebElementAssert hasId(String idToFind) {
        String actualId = ((FluentWebElement)this.actual).id();
        if (!actualId.equals(idToFind)) {
            this.failWithMessage("The element does not have the id: " + idToFind + " . Actual id found : " + actualId);
        }
        return this;
    }

    public FluentWebElementAssert hasClass(String classToFind) {
        String actualClasses = ((FluentWebElement)this.actual).attribute("class");
        if (!this.getClasses(actualClasses).contains(classToFind)) {
            this.failWithMessage("The element does not have the class: " + classToFind + " . Actual class found : " + actualClasses);
        }
        return this;
    }

    private List<String> getClasses(String classString) {
        String[] primitiveList = classString.split(" ");
        return Arrays.asList(primitiveList);
    }
}

