/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.assertj.custom;

import org.fluentlenium.assertj.custom.FluentListAssert;

public class FluentListSizeBuilder {
    private final int actualSize;
    private final FluentListAssert listAssert;
    private static final String ACTUAL_SIZE = "Actual size: ";

    public FluentListSizeBuilder(int size, FluentListAssert listAssert) {
        this.actualSize = size;
        this.listAssert = listAssert;
    }

    public FluentListAssert lessThan(int size) {
        if (this.actualSize >= size) {
            this.listAssert.failWithMessage(ACTUAL_SIZE + this.actualSize + " is not less than: " + size, new Object[0]);
        }
        return this.listAssert;
    }

    public Object lessThanOrEqualTo(int size) {
        if (this.actualSize > size) {
            this.listAssert.failWithMessage(ACTUAL_SIZE + this.actualSize + " is not less than or equal to: " + size, new Object[0]);
        }
        return this.listAssert;
    }

    public FluentListAssert greaterThan(int size) {
        if (this.actualSize <= size) {
            this.listAssert.failWithMessage(ACTUAL_SIZE + this.actualSize + " is not greater than: " + size, new Object[0]);
        }
        return this.listAssert;
    }

    public Object greaterThanOrEqualTo(int size) {
        if (this.actualSize < size) {
            this.listAssert.failWithMessage(ACTUAL_SIZE + this.actualSize + " is not greater than or equal to: " + size, new Object[0]);
        }
        return this.listAssert;
    }
}

