/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.assertj.custom;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.fluentlenium.assertj.custom.FluentListSizeBuilder;
import org.fluentlenium.core.domain.FluentList;

public class FluentListAssert
extends AbstractAssert<FluentListAssert, FluentList> {
    public FluentListAssert(FluentList<?> actual) {
        super(actual, FluentListAssert.class);
    }

    public FluentListAssert hasText(String textToFind) {
        List actualTexts = ((FluentList)this.actual).texts();
        for (String text : actualTexts) {
            if (!text.contains(textToFind)) continue;
            return this;
        }
        super.failWithMessage("No selected elements contains text: " + textToFind + " . Actual texts found : " + actualTexts, new Object[0]);
        return this;
    }

    public FluentListAssert hasNotText(String textToFind) {
        List actualTexts = ((FluentList)this.actual).texts();
        for (String text : actualTexts) {
            if (!text.contains(textToFind)) continue;
            super.failWithMessage("At least one selected elements contains text: " + textToFind + " . Actual texts found : " + actualTexts, new Object[0]);
        }
        return this;
    }

    public FluentListAssert hasSize(int expectedSize) {
        int actualSize = ((FluentList)this.actual).size();
        if (actualSize != expectedSize) {
            super.failWithMessage("Expected size: " + expectedSize + ". Actual size: " + actualSize + ".", new Object[0]);
        }
        return this;
    }

    public FluentListSizeBuilder hasSize() {
        return new FluentListSizeBuilder(((FluentList)this.actual).size(), this);
    }

    public FluentListAssert hasId(String idToFind) {
        List actualIds = ((FluentList)this.actual).ids();
        if (!actualIds.contains(idToFind)) {
            super.failWithMessage("No selected elements has id: " + idToFind + " . Actual texts found : " + actualIds, new Object[0]);
        }
        return this;
    }

    public FluentListAssert hasClass(String classToFind) {
        List classes = ((FluentList)this.actual).attributes("class");
        for (String classesStr : classes) {
            List<String> classesLst = Arrays.asList(classesStr.split(" "));
            if (!classesLst.contains(classToFind)) continue;
            return this;
        }
        StringBuilder builder = new StringBuilder();
        for (String classFromElement : classes) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(classFromElement);
        }
        super.failWithMessage("No selected elements has class: " + classToFind + " . Actual classes found : " + builder.toString(), new Object[0]);
        return this;
    }

    protected void failWithMessage(String errorMessage, Object ... arguments) {
        super.failWithMessage(errorMessage, new Object[0]);
    }
}

