/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.task.model.runtime.CreateTaskRepresentation;
import org.flowable.ui.task.model.runtime.TaskRepresentation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class TasksResource {
    @Autowired
    protected TaskService taskService;

    @PostMapping(value={"/rest/tasks"})
    public TaskRepresentation createNewTask(@RequestBody CreateTaskRepresentation taskRepresentation, HttpServletRequest request) {
        if (StringUtils.isEmpty((CharSequence)taskRepresentation.getName())) {
            throw new BadRequestException("Task name is required");
        }
        TaskEntity task = (TaskEntity)this.taskService.newTask();
        task.setName(taskRepresentation.getName());
        task.setDescription(taskRepresentation.getDescription());
        task.setParentTaskId(taskRepresentation.getParentTaskId());
        if (StringUtils.isNotEmpty((CharSequence)taskRepresentation.getCategory())) {
            task.setCategory(taskRepresentation.getCategory());
        }
        task.setAssignee(taskRepresentation.getAssignee() != null ? taskRepresentation.getAssignee() : SecurityUtils.getCurrentUserId());
        this.taskService.saveTask((Task)task);
        return new TaskRepresentation((Task)((TaskQuery)this.taskService.createTaskQuery().taskId(task.getId())).singleResult());
    }
}

