/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import org.flowable.form.api.FormInfo;
import org.flowable.form.model.SimpleFormModel;
import org.flowable.ui.task.model.runtime.CompleteFormRepresentation;
import org.flowable.ui.task.model.runtime.FormModelRepresentation;
import org.flowable.ui.task.model.runtime.SaveFormRepresentation;
import org.flowable.ui.task.service.runtime.FlowableTaskFormService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/rest/task-forms"})
public class TaskFormResource {
    @Autowired
    protected FlowableTaskFormService taskFormService;

    @GetMapping(value={"/{taskId}"}, produces={"application/json"})
    public FormModelRepresentation getTaskForm(@PathVariable String taskId) {
        FormInfo formInfo = this.taskFormService.getTaskForm(taskId);
        SimpleFormModel formModel = (SimpleFormModel)formInfo.getFormModel();
        return new FormModelRepresentation(formInfo, formModel);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"/{taskId}"}, produces={"application/json"})
    public void completeTaskForm(@PathVariable String taskId, @RequestBody CompleteFormRepresentation completeTaskFormRepresentation) {
        this.taskFormService.completeTaskForm(taskId, completeTaskFormRepresentation);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"/{taskId}/save-form"}, produces={"application/json"})
    public void saveTaskForm(@PathVariable String taskId, @RequestBody SaveFormRepresentation saveFormRepresentation) {
        this.taskFormService.saveTaskForm(taskId, saveFormRepresentation);
    }
}

