/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import javax.servlet.http.HttpServletResponse;
import org.flowable.form.api.FormInfo;
import org.flowable.form.model.SimpleFormModel;
import org.flowable.ui.task.model.runtime.FormModelRepresentation;
import org.flowable.ui.task.model.runtime.ProcessInstanceRepresentation;
import org.flowable.ui.task.service.runtime.FlowableProcessInstanceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class ProcessInstanceResource {
    @Autowired
    protected FlowableProcessInstanceService processInstanceService;

    @GetMapping(value={"/rest/process-instances/{processInstanceId}"}, produces={"application/json"})
    public ProcessInstanceRepresentation getProcessInstance(@PathVariable String processInstanceId, HttpServletResponse response) {
        return this.processInstanceService.getProcessInstance(processInstanceId, response);
    }

    @GetMapping(value={"/rest/process-instances/{processInstanceId}/start-form"}, produces={"application/json"})
    public FormModelRepresentation getProcessInstanceStartForm(@PathVariable String processInstanceId, HttpServletResponse response) {
        FormInfo formInfo = this.processInstanceService.getProcessInstanceStartForm(processInstanceId, response);
        SimpleFormModel formModel = (SimpleFormModel)formInfo.getFormModel();
        return new FormModelRepresentation(formInfo, formModel);
    }

    @DeleteMapping(value={"/rest/process-instances/{processInstanceId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteProcessInstance(@PathVariable String processInstanceId) {
        this.processInstanceService.deleteProcessInstance(processInstanceId);
    }
}

