/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.task.model.runtime.CommentRepresentation;
import org.flowable.ui.task.service.runtime.FlowableCommentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class CommentsResource {
    @Autowired
    protected FlowableCommentService commentService;

    @GetMapping(value={"/rest/tasks/{taskId}/comments"}, produces={"application/json"})
    public ResultListDataRepresentation getTaskComments(@PathVariable(value="taskId") String taskId) {
        return this.commentService.getTaskComments(taskId);
    }

    @PostMapping(value={"/rest/tasks/{taskId}/comments"}, produces={"application/json"})
    public CommentRepresentation addTaskComment(@RequestBody CommentRepresentation commentRequest, @PathVariable(value="taskId") String taskId) {
        return this.commentService.addTaskComment(commentRequest, taskId);
    }

    @GetMapping(value={"/rest/process-instances/{processInstanceId}/comments"}, produces={"application/json"})
    public ResultListDataRepresentation getProcessInstanceComments(@PathVariable(value="processInstanceId") String processInstanceId) {
        return this.commentService.getProcessInstanceComments(processInstanceId);
    }

    @PostMapping(value={"/rest/process-instances/{processInstanceId}/comments"}, produces={"application/json"})
    public CommentRepresentation addProcessInstanceComment(@RequestBody CommentRepresentation commentRequest, @PathVariable(value="processInstanceId") String processInstanceId) {
        return this.commentService.addProcessInstanceComment(commentRequest, processInstanceId);
    }
}

