/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import javax.servlet.http.HttpServletResponse;
import org.flowable.form.api.FormInfo;
import org.flowable.form.model.SimpleFormModel;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.task.model.runtime.CaseInstanceRepresentation;
import org.flowable.ui.task.model.runtime.FormModelRepresentation;
import org.flowable.ui.task.service.runtime.FlowableCaseInstanceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class CaseInstanceResource {
    @Autowired
    protected FlowableCaseInstanceService caseInstanceService;

    @GetMapping(value={"/rest/case-instances/{caseInstanceId}"}, produces={"application/json"})
    public CaseInstanceRepresentation getCaseInstance(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstance(caseInstanceId);
    }

    @GetMapping(value={"/rest/case-instances/{caseInstanceId}/start-form"}, produces={"application/json"})
    public FormModelRepresentation getCaseInstanceStartForm(@PathVariable String caseInstanceId, HttpServletResponse response) {
        FormInfo formInfo = this.caseInstanceService.getCaseInstanceStartForm(caseInstanceId);
        SimpleFormModel formModel = (SimpleFormModel)formInfo.getFormModel();
        return new FormModelRepresentation(formInfo, formModel);
    }

    @GetMapping(value={"/rest/case-instances/{caseInstanceId}/active-stages"}, produces={"application/json"})
    public ResultListDataRepresentation getCaseInstanceActiveStages(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstanceActiveStages(caseInstanceId);
    }

    @GetMapping(value={"/rest/case-instances/{caseInstanceId}/ended-stages"}, produces={"application/json"})
    public ResultListDataRepresentation getCaseInstanceEndedStages(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstanceEndedStages(caseInstanceId);
    }

    @GetMapping(value={"/rest/case-instances/{caseInstanceId}/available-milestones"}, produces={"application/json"})
    public ResultListDataRepresentation getCaseInstanceAvailableMilestones(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstanceAvailableMilestones(caseInstanceId);
    }

    @GetMapping(value={"/rest/case-instances/{caseInstanceId}/ended-milestones"}, produces={"application/json"})
    public ResultListDataRepresentation getCaseInstanceEndedMilestones(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstanceEndedMilestones(caseInstanceId);
    }

    @GetMapping(value={"/rest/case-instances/{caseInstanceId}/available-user-event-listeners"}, produces={"application/json"})
    public ResultListDataRepresentation getCaseInstanceAvailableUserEventListeners(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstanceAvailableUserEventListeners(caseInstanceId);
    }

    @GetMapping(value={"/rest/case-instances/{caseInstanceId}/completed-user-event-listeners"}, produces={"application/json"})
    public ResultListDataRepresentation getCaseInstanceCompletedUserEventListeners(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstanceCompletedUserEventListeners(caseInstanceId);
    }

    @PostMapping(value={"/rest/case-instances/{caseInstanceId}/trigger-user-event-listener/{userEventListenerId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void triggerUserEventListener(@PathVariable String caseInstanceId, @PathVariable String userEventListenerId) {
        this.caseInstanceService.triggerUserEventListener(caseInstanceId, userEventListenerId);
    }

    @GetMapping(value={"/rest/case-instances/{caseInstanceId}/enabled-planitem-instances"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResultListDataRepresentation getCaseInstanceEnabledPlanItemInstances(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstanceEnabledPlanItemInstances(caseInstanceId);
    }

    @PostMapping(value={"/rest/case-instances/{caseInstanceId}/enabled-planitem-instances/{planItemInstanceId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void startEnabledPlanItemInstance(@PathVariable String caseInstanceId, @PathVariable String planItemInstanceId) {
        this.caseInstanceService.startEnabledPlanItemInstance(caseInstanceId, planItemInstanceId);
    }

    @DeleteMapping(value={"/rest/case-instances/{caseInstanceId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteCaseInstance(@PathVariable String caseInstanceId) {
        this.caseInstanceService.deleteCaseInstance(caseInstanceId);
    }
}

