/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.service.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.api.repository.AppDefinitionQuery;
import org.flowable.app.api.repository.AppDeployment;
import org.flowable.app.engine.impl.deployer.BaseAppModel;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.DeploymentQuery;
import org.flowable.form.api.FormDeployment;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.security.SecurityScope;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.task.model.runtime.AppDefinitionRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ClassUtils;

@Service
@Transactional
public class FlowableAppDefinitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableAppDefinitionService.class);
    @Autowired
    protected AppRepositoryService appRepositoryService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected CmmnRepositoryService cmmnRepositoryService;
    @Autowired
    protected DmnRepositoryService dmnRepositoryService;
    @Autowired
    protected FormRepositoryService formRepositoryService;
    @Autowired
    protected ObjectMapper objectMapper;
    protected static final AppDefinitionRepresentation taskAppDefinitionRepresentation = AppDefinitionRepresentation.createDefaultAppDefinitionRepresentation("tasks");
    protected static final AppDefinitionRepresentation adminAppDefinitionRepresentation = ClassUtils.isPresent((String)"org.flowable.ui.admin.conf.ApplicationConfiguration", null) ? AppDefinitionRepresentation.createDefaultAppDefinitionRepresentation("admin") : null;
    protected static final AppDefinitionRepresentation idmAppDefinitionRepresentation = ClassUtils.isPresent((String)"org.flowable.ui.idm.service.GroupServiceImpl", null) ? AppDefinitionRepresentation.createDefaultAppDefinitionRepresentation("idm") : null;
    protected static final AppDefinitionRepresentation modelerAppDefinitionRepresentation = ClassUtils.isPresent((String)"org.flowable.ui.modeler.conf.ApplicationConfiguration", null) ? AppDefinitionRepresentation.createDefaultAppDefinitionRepresentation("modeler") : null;

    public ResultListDataRepresentation getAppDefinitions() {
        ArrayList<AppDefinitionRepresentation> resultList = new ArrayList<AppDefinitionRepresentation>();
        SecurityScope currentSecurityScope = SecurityUtils.getAuthenticatedSecurityScope();
        boolean hasAccessToTask = currentSecurityScope.hasAuthority("access-task");
        if (hasAccessToTask) {
            resultList.add(taskAppDefinitionRepresentation);
        }
        if (modelerAppDefinitionRepresentation != null && currentSecurityScope.hasAuthority("access-modeler")) {
            resultList.add(modelerAppDefinitionRepresentation);
        }
        if (adminAppDefinitionRepresentation != null && currentSecurityScope.hasAuthority("access-admin")) {
            resultList.add(adminAppDefinitionRepresentation);
        }
        if (idmAppDefinitionRepresentation != null && currentSecurityScope.hasAuthority("access-idm")) {
            resultList.add(idmAppDefinitionRepresentation);
        }
        if (hasAccessToTask) {
            resultList.addAll(this.getTaskAppList(currentSecurityScope));
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(resultList);
        return result;
    }

    protected List<AppDefinitionRepresentation> getTaskAppList(SecurityScope currentUser) {
        ArrayList<AppDefinitionRepresentation> resultList = new ArrayList<AppDefinitionRepresentation>();
        List appDefinitions = ((AppDefinitionQuery)this.appRepositoryService.createAppDefinitionQuery().latestVersion()).list();
        boolean appDefinitionHaveAccessControl = false;
        for (AppDefinition appDefinition : appDefinitions) {
            BaseAppModel baseAppModel = (BaseAppModel)this.appRepositoryService.getAppModel(appDefinition.getId());
            if (StringUtils.isNotEmpty((CharSequence)baseAppModel.getUsersAccess()) || StringUtils.isNotEmpty((CharSequence)baseAppModel.getGroupsAccess())) {
                appDefinitionHaveAccessControl = true;
            }
            resultList.add(this.createRepresentation(appDefinition, baseAppModel));
        }
        if (appDefinitionHaveAccessControl) {
            String userId = currentUser.getUserId();
            Set groups = currentUser.getGroupIds();
            ArrayList<AppDefinitionRepresentation> appDefinitionList = new ArrayList<AppDefinitionRepresentation>(resultList);
            resultList.clear();
            for (AppDefinitionRepresentation appDefinition : appDefinitionList) {
                if (!this.hasAppAccess(appDefinition, userId, groups)) continue;
                resultList.add(appDefinition);
            }
        }
        return resultList;
    }

    public AppDefinitionRepresentation getAppDefinition(String appDefinitionKey) {
        AppDefinition appDefinition = (AppDefinition)((AppDefinitionQuery)((AppDefinitionQuery)this.appRepositoryService.createAppDefinitionQuery().appDefinitionKey(appDefinitionKey)).latestVersion()).singleResult();
        if (appDefinition == null) {
            throw new NotFoundException("No app definition is found with key: " + appDefinitionKey);
        }
        BaseAppModel appModel = (BaseAppModel)this.appRepositoryService.getAppModel(appDefinition.getId());
        return this.createRepresentation(appDefinition, appModel);
    }

    public String migrateAppDefinitions() {
        ArrayList<Deployment> deployments = new ArrayList<Deployment>();
        List processDeployments = ((DeploymentQuery)this.repositoryService.createDeploymentQuery().orderByDeploymentTime().asc()).list();
        for (Deployment deployment : processDeployments) {
            if (deployment.getKey() == null || deployment.getParentDeploymentId() != null) continue;
            deployments.add(deployment);
        }
        HashMap<String, String> deploymentIdMap = new HashMap<String, String>();
        for (Deployment deployment : deployments) {
            List resourceNames = this.repositoryService.getDeploymentResourceNames(deployment.getId());
            Object resourceAppName = null;
            for (String resourceName : resourceNames) {
                if (resourceName == null || !resourceName.endsWith(".app")) continue;
                resourceAppName = resourceName;
                break;
            }
            if (resourceAppName == null) continue;
            AppDeployment appDeployment = this.appRepositoryService.createDeployment().addInputStream(resourceAppName, this.repositoryService.getResourceAsStream(deployment.getId(), resourceAppName)).deploy();
            deploymentIdMap.put(deployment.getId(), appDeployment.getId());
        }
        for (String oldDeploymentId : deploymentIdMap.keySet()) {
            List formDeployments;
            List dmnDeployments;
            List cmmnDeployments = this.cmmnRepositoryService.createDeploymentQuery().parentDeploymentId(oldDeploymentId).list();
            if (cmmnDeployments != null) {
                for (Object cmmnDeployment : cmmnDeployments) {
                    this.cmmnRepositoryService.changeDeploymentParentDeploymentId(cmmnDeployment.getId(), (String)deploymentIdMap.get(oldDeploymentId));
                }
            }
            if ((dmnDeployments = this.dmnRepositoryService.createDeploymentQuery().parentDeploymentId(oldDeploymentId).list()) != null) {
                Object cmmnDeployment;
                cmmnDeployment = dmnDeployments.iterator();
                while (cmmnDeployment.hasNext()) {
                    DmnDeployment dmnDeployment = (DmnDeployment)cmmnDeployment.next();
                    this.dmnRepositoryService.changeDeploymentParentDeploymentId(dmnDeployment.getId(), (String)deploymentIdMap.get(oldDeploymentId));
                }
            }
            if ((formDeployments = this.formRepositoryService.createDeploymentQuery().parentDeploymentId(oldDeploymentId).list()) != null) {
                for (FormDeployment formDeployment : formDeployments) {
                    this.formRepositoryService.changeDeploymentParentDeploymentId(formDeployment.getId(), (String)deploymentIdMap.get(oldDeploymentId));
                }
            }
            this.repositoryService.changeDeploymentParentDeploymentId(oldDeploymentId, (String)deploymentIdMap.get(oldDeploymentId));
        }
        return "Migrated " + deploymentIdMap.size() + " app deployments";
    }

    protected boolean hasAppAccess(AppDefinitionRepresentation appDefinition, String userId, Collection<String> groups) {
        if (CollectionUtils.isEmpty(appDefinition.getUsersAccess()) && CollectionUtils.isEmpty(appDefinition.getGroupsAccess())) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(appDefinition.getUsersAccess()) && appDefinition.getUsersAccess().contains(userId)) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(appDefinition.getGroupsAccess())) {
            for (String groupId : appDefinition.getGroupsAccess()) {
                for (String group : groups) {
                    if (!group.equals(groupId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected AppDefinitionRepresentation createDefaultAppDefinition(String id) {
        AppDefinitionRepresentation app = new AppDefinitionRepresentation();
        return app;
    }

    protected AppDefinitionRepresentation createRepresentation(AppDefinition appDefinition, BaseAppModel baseAppModel) {
        AppDefinitionRepresentation resultAppDef = new AppDefinitionRepresentation();
        resultAppDef.setAppDefinitionId(appDefinition.getId());
        resultAppDef.setAppDefinitionKey(appDefinition.getKey());
        resultAppDef.setName(appDefinition.getName());
        resultAppDef.setTheme(baseAppModel.getTheme());
        resultAppDef.setIcon(baseAppModel.getIcon());
        resultAppDef.setDescription(baseAppModel.getDescription());
        resultAppDef.setTenantId(appDefinition.getTenantId());
        if (StringUtils.isNotEmpty((CharSequence)baseAppModel.getUsersAccess())) {
            resultAppDef.setUsersAccess(this.convertToList(baseAppModel.getUsersAccess()));
        }
        if (StringUtils.isNotEmpty((CharSequence)baseAppModel.getGroupsAccess())) {
            resultAppDef.setGroupsAccess(this.convertToList(baseAppModel.getGroupsAccess()));
        }
        return resultAppDef;
    }

    protected List<String> convertToList(String commaSeperatedString) {
        String[] stringArray = commaSeperatedString.split(",");
        ArrayList<String> resultList = new ArrayList<String>(Arrays.asList(stringArray));
        return resultList;
    }
}

