/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.rest.app;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.domain.ModelHistory;
import org.flowable.ui.modeler.model.ModelRepresentation;
import org.flowable.ui.modeler.repository.ModelHistoryRepository;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AbstractModelHistoryResource {
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ModelHistoryRepository modelHistoryRepository;
    @Autowired
    protected ObjectMapper objectMapper;

    public ResultListDataRepresentation getModelHistoryCollection(String modelId, Boolean includeLatestVersion) {
        Model model = this.modelService.getModel(modelId);
        List history = this.modelHistoryRepository.findByModelId(model.getId());
        ResultListDataRepresentation result = new ResultListDataRepresentation();
        ArrayList<ModelRepresentation> representations = new ArrayList<ModelRepresentation>();
        if (Boolean.TRUE.equals(includeLatestVersion)) {
            representations.add(new ModelRepresentation((AbstractModel)model));
        }
        if (history.size() > 0) {
            for (ModelHistory modelHistory : history) {
                representations.add(new ModelRepresentation((AbstractModel)modelHistory));
            }
            result.setData(representations);
        }
        result.setSize(Integer.valueOf(representations.size()));
        result.setTotal(Long.valueOf(representations.size()));
        result.setStart(Integer.valueOf(0));
        return result;
    }

    public ModelRepresentation getProcessModelHistory(String modelId, String modelHistoryId) {
        ModelHistory modelHistory = this.modelService.getModelHistory(modelId, modelHistoryId);
        return new ModelRepresentation((AbstractModel)modelHistory);
    }
}

