/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.bpmn.model.SendEventServiceTask;
import org.flowable.eventregistry.model.ChannelEventKeyDetection;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.EventPayload;
import org.flowable.eventregistry.model.JmsInboundChannelModel;
import org.flowable.eventregistry.model.JmsOutboundChannelModel;
import org.flowable.eventregistry.model.KafkaInboundChannelModel;
import org.flowable.eventregistry.model.KafkaOutboundChannelModel;
import org.flowable.eventregistry.model.RabbitInboundChannelModel;
import org.flowable.eventregistry.model.RabbitOutboundChannelModel;

public class BpmnEventModelUtil {
    public static void fillChannelModelMap(List<FlowElement> flowElements, Map<String, ChannelModel> channelModelMap) {
        for (FlowElement elementObject : flowElements) {
            String channelKey = BpmnEventModelUtil.getElementValue("channelKey", elementObject);
            String channelType = BpmnEventModelUtil.getElementValue("channelType", elementObject);
            String channelDestination = BpmnEventModelUtil.getElementValue("channelDestination", elementObject);
            if (!StringUtils.isNotEmpty((CharSequence)channelKey) || channelModelMap.containsKey(channelKey) || !StringUtils.isNotEmpty((CharSequence)channelType) || !StringUtils.isNotEmpty((CharSequence)channelDestination)) continue;
            if (elementObject instanceof SendEventServiceTask) {
                BpmnEventModelUtil.createOutboundChannelInMap(channelKey, channelType, channelDestination, elementObject, channelModelMap);
                SendEventServiceTask task = (SendEventServiceTask)elementObject;
                String triggerChannelKey = BpmnEventModelUtil.getElementValue("triggerChannelKey", elementObject);
                String triggerChannelType = BpmnEventModelUtil.getElementValue("triggerChannelType", elementObject);
                String triggerChannelDestination = BpmnEventModelUtil.getElementValue("triggerChannelDestination", elementObject);
                if (!task.isTriggerable() || !StringUtils.isNotEmpty((CharSequence)triggerChannelKey) || channelModelMap.containsKey(triggerChannelKey) || !StringUtils.isNotEmpty((CharSequence)triggerChannelType) || !StringUtils.isNotEmpty((CharSequence)triggerChannelDestination)) continue;
                BpmnEventModelUtil.createInboundChannelInMap(triggerChannelKey, triggerChannelType, triggerChannelDestination, "triggerChannelName", elementObject, channelModelMap);
                continue;
            }
            BpmnEventModelUtil.createInboundChannelInMap(channelKey, channelType, channelDestination, "channelName", elementObject, channelModelMap);
        }
    }

    public static void fillEventModelMap(List<FlowElement> flowElements, Map<String, EventModel> eventModelMap) {
        for (FlowElement flowElement : flowElements) {
            String eventKey = null;
            if (flowElement instanceof SendEventServiceTask) {
                SendEventServiceTask task = (SendEventServiceTask)flowElement;
                eventKey = task.getEventType();
            } else {
                eventKey = BpmnEventModelUtil.getElementValue("eventType", flowElement);
            }
            if (!StringUtils.isNotEmpty((CharSequence)eventKey) || eventModelMap.containsKey(eventKey)) continue;
            EventModel eventModel = new EventModel();
            String eventName = BpmnEventModelUtil.getElementValue("eventName", flowElement);
            eventModel.setKey(eventKey);
            if (StringUtils.isNotEmpty((CharSequence)eventName)) {
                eventModel.setName(eventName);
            } else {
                eventModel.setName(eventKey);
            }
            if (flowElement instanceof SendEventServiceTask) {
                SendEventServiceTask task = (SendEventServiceTask)flowElement;
                if (task.isTriggerable() && StringUtils.isNotEmpty((CharSequence)task.getTriggerEventType())) {
                    eventModel.setPayload(BpmnEventModelUtil.getInIOParameterEventPayload(task.getEventInParameters()));
                    EventModel triggerEventModel = new EventModel();
                    String triggerEventName = BpmnEventModelUtil.getElementValue("triggerEventName", flowElement);
                    triggerEventModel.setKey(task.getTriggerEventType());
                    if (StringUtils.isNotEmpty((CharSequence)triggerEventName)) {
                        triggerEventModel.setName(triggerEventName);
                    } else {
                        triggerEventModel.setName(task.getTriggerEventType());
                    }
                    Map<String, EventPayload> payload = BpmnEventModelUtil.getOutIOParameterEventPayload(task.getEventOutParameters());
                    BpmnEventModelUtil.fillEventCorrelationParameters(payload, (List)flowElement.getExtensionElements().get("triggerEventCorrelationParameter"));
                    triggerEventModel.setPayload(payload.values());
                    eventModelMap.put(task.getTriggerEventType(), triggerEventModel);
                }
            } else {
                Map<String, EventPayload> payload = BpmnEventModelUtil.getOutParameterEventPayload((List)flowElement.getExtensionElements().get("eventOutParameter"));
                BpmnEventModelUtil.fillEventCorrelationParameters(payload, (List)flowElement.getExtensionElements().get("eventCorrelationParameter"));
                eventModel.setPayload(payload.values());
            }
            eventModelMap.put(eventKey, eventModel);
        }
    }

    protected static void createOutboundChannelInMap(String channelKey, String channelType, String channelDestination, FlowElement elementObject, Map<String, ChannelModel> channelModelMap) {
        JmsOutboundChannelModel channelModel = null;
        if ("jms".equalsIgnoreCase(channelType)) {
            JmsOutboundChannelModel jmsChannelModel = new JmsOutboundChannelModel();
            jmsChannelModel.setDestination(channelDestination);
            channelModel = jmsChannelModel;
        } else if ("kafka".equalsIgnoreCase(channelType)) {
            KafkaOutboundChannelModel kafkaChannelModel = new KafkaOutboundChannelModel();
            kafkaChannelModel.setTopic(channelDestination);
            channelModel = kafkaChannelModel;
        } else if ("rabbitmq".equalsIgnoreCase(channelType)) {
            RabbitOutboundChannelModel rabbitChannelModel = new RabbitOutboundChannelModel();
            rabbitChannelModel.setRoutingKey(channelDestination);
            channelModel = rabbitChannelModel;
        }
        String channelName = BpmnEventModelUtil.getElementValue("channelName", elementObject);
        channelModel.setKey(channelKey);
        if (StringUtils.isNotEmpty((CharSequence)channelName)) {
            channelModel.setName(channelName);
        } else {
            channelModel.setName(channelKey);
        }
        channelModel.setChannelType("outbound");
        String serializerType = BpmnEventModelUtil.getElementValue("serializerType", elementObject);
        if (StringUtils.isEmpty((CharSequence)serializerType)) {
            serializerType = "json";
        }
        channelModel.setSerializerType(serializerType);
        channelModelMap.put(channelKey, (ChannelModel)channelModel);
    }

    protected static void createInboundChannelInMap(String channelKey, String channelType, String channelDestination, String channelNameProperty, FlowElement elementObject, Map<String, ChannelModel> channelModelMap) {
        JmsInboundChannelModel channelModel = null;
        if ("jms".equalsIgnoreCase(channelType)) {
            JmsInboundChannelModel jmsChannelModel = new JmsInboundChannelModel();
            jmsChannelModel.setDestination(channelDestination);
            channelModel = jmsChannelModel;
        } else if ("kafka".equalsIgnoreCase(channelType)) {
            KafkaInboundChannelModel kafkaChannelModel = new KafkaInboundChannelModel();
            kafkaChannelModel.setTopics(Collections.singletonList(channelDestination));
            channelModel = kafkaChannelModel;
        } else if ("rabbitmq".equalsIgnoreCase(channelType)) {
            RabbitInboundChannelModel rabbitChannelModel = new RabbitInboundChannelModel();
            rabbitChannelModel.setQueues(Collections.singletonList(channelDestination));
            channelModel = rabbitChannelModel;
        }
        String channelName = BpmnEventModelUtil.getElementValue(channelNameProperty, elementObject);
        channelModel.setKey(channelKey);
        if (StringUtils.isNotEmpty((CharSequence)channelName)) {
            channelModel.setName(channelName);
        } else {
            channelModel.setName(channelKey);
        }
        channelModel.setChannelType("inbound");
        String deserializerType = BpmnEventModelUtil.getElementValue("deserializerType", elementObject);
        if (StringUtils.isEmpty((CharSequence)deserializerType)) {
            deserializerType = "json";
        }
        channelModel.setDeserializerType(deserializerType);
        String keyDetectionType = BpmnEventModelUtil.getElementValue("keyDetectionType", elementObject);
        String keyDetectionValue = BpmnEventModelUtil.getElementValue("keyDetectionValue", elementObject);
        if (StringUtils.isNotEmpty((CharSequence)keyDetectionType) && StringUtils.isNotEmpty((CharSequence)keyDetectionValue)) {
            ChannelEventKeyDetection channelEventKeyDetection = new ChannelEventKeyDetection();
            if ("fixedValue".equalsIgnoreCase(keyDetectionType)) {
                channelEventKeyDetection.setFixedValue(keyDetectionValue);
            } else if ("jsonField".equalsIgnoreCase(keyDetectionType)) {
                channelEventKeyDetection.setJsonField(keyDetectionValue);
            } else if ("jsonPointer".equalsIgnoreCase(keyDetectionType)) {
                channelEventKeyDetection.setJsonPointerExpression(keyDetectionValue);
            }
            channelModel.setChannelEventKeyDetection(channelEventKeyDetection);
        }
        channelModelMap.put(channelKey, (ChannelModel)channelModel);
    }

    protected static Map<String, EventPayload> getOutParameterEventPayload(List<ExtensionElement> parameterList) {
        LinkedHashMap<String, EventPayload> eventPayload = new LinkedHashMap<String, EventPayload>();
        if (parameterList != null && parameterList.size() > 0) {
            for (ExtensionElement parameterElement : parameterList) {
                String name = parameterElement.getAttributeValue(null, "source");
                String type = parameterElement.getAttributeValue(null, "sourceType");
                if (StringUtils.isEmpty((CharSequence)type)) {
                    type = "string";
                }
                eventPayload.put(name, new EventPayload(name, type));
            }
        }
        return eventPayload;
    }

    protected static Map<String, EventPayload> getOutIOParameterEventPayload(List<IOParameter> parameterList) {
        LinkedHashMap<String, EventPayload> eventPayload = new LinkedHashMap<String, EventPayload>();
        if (parameterList != null && parameterList.size() > 0) {
            for (IOParameter parameter : parameterList) {
                String name = parameter.getSource();
                String type = parameter.getAttributeValue(null, "sourceType");
                if (StringUtils.isEmpty((CharSequence)type)) {
                    type = "string";
                }
                eventPayload.put(name, new EventPayload(name, type));
            }
        }
        return eventPayload;
    }

    protected static List<EventPayload> getInIOParameterEventPayload(List<IOParameter> parameterList) {
        ArrayList<EventPayload> eventPayloadList = new ArrayList<EventPayload>();
        if (parameterList != null && parameterList.size() > 0) {
            for (IOParameter parameter : parameterList) {
                String name = parameter.getTarget();
                String type = parameter.getAttributeValue(null, "targetType");
                if (StringUtils.isEmpty((CharSequence)type)) {
                    type = "string";
                }
                eventPayloadList.add(new EventPayload(name, type));
            }
        }
        return eventPayloadList;
    }

    protected static void fillEventCorrelationParameters(Map<String, EventPayload> currentPayload, List<ExtensionElement> parameterList) {
        if (parameterList != null && parameterList.size() > 0) {
            for (ExtensionElement parameterElement : parameterList) {
                EventPayload eventPayload;
                String name = parameterElement.getAttributeValue(null, "name");
                String type = parameterElement.getAttributeValue(null, "type");
                if (StringUtils.isEmpty((CharSequence)type)) {
                    type = "string";
                }
                if ((eventPayload = currentPayload.get(name)) != null) {
                    eventPayload.setCorrelationParameter(true);
                    continue;
                }
                currentPayload.put(name, EventPayload.correlation((String)name, (String)type));
            }
        }
    }

    protected static String getElementValue(String name, FlowElement elementObject) {
        List elementList = (List)elementObject.getExtensionElements().get(name);
        if (elementList != null && elementList.size() > 0) {
            return ((ExtensionElement)elementList.get(0)).getElementText();
        }
        return null;
    }
}

