/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.flowable.form.model.SimpleFormModel;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.domain.ModelHistory;
import org.flowable.ui.modeler.model.FormSaveRepresentation;
import org.flowable.ui.modeler.model.ModelKeyRepresentation;
import org.flowable.ui.modeler.model.form.FormRepresentation;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableFormService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableFormService.class);
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ObjectMapper objectMapper;

    public FormRepresentation getForm(String formId) {
        Model model = this.modelService.getModel(formId);
        FormRepresentation form = this.createFormRepresentation(model);
        return form;
    }

    public FormRepresentation getFormHistory(String formId, String formHistoryId) {
        ModelHistory model = this.modelService.getModelHistory(formId, formHistoryId);
        FormRepresentation form = this.createFormRepresentation(model);
        return form;
    }

    public List<FormRepresentation> getForms(String[] formIds) {
        ArrayList<FormRepresentation> formRepresentations = new ArrayList<FormRepresentation>();
        if (formIds == null || formIds.length == 0) {
            throw new BadRequestException("No formIds provided in the request");
        }
        for (String formId : formIds) {
            Model model = this.modelService.getModel(formId);
            FormRepresentation form = this.createFormRepresentation(model);
            formRepresentations.add(form);
        }
        return formRepresentations;
    }

    public FormRepresentation saveForm(String formId, FormSaveRepresentation saveRepresentation) {
        String user = SecurityUtils.getCurrentUserId();
        Model model = this.modelService.getModel(formId);
        String formKey = saveRepresentation.getFormRepresentation().getKey();
        ModelKeyRepresentation modelKeyInfo = this.modelService.validateModelKey(model, model.getModelType(), formKey);
        if (modelKeyInfo.isKeyAlreadyExists()) {
            throw new BadRequestException("Model with provided key already exists " + formKey);
        }
        model.setName(saveRepresentation.getFormRepresentation().getName());
        model.setKey(formKey);
        model.setDescription(saveRepresentation.getFormRepresentation().getDescription());
        String editorJson = null;
        try {
            editorJson = this.objectMapper.writeValueAsString((Object)saveRepresentation.getFormRepresentation().getFormDefinition());
        }
        catch (Exception e) {
            LOGGER.error("Error while processing form json", (Throwable)e);
            throw new InternalServerErrorException("Form could not be saved " + formId);
        }
        String filteredImageString = saveRepresentation.getFormImageBase64().replace("data:image/png;base64,", "");
        byte[] imageBytes = Base64.getDecoder().decode(filteredImageString);
        model = this.modelService.saveModel(model, editorJson, imageBytes, saveRepresentation.isNewVersion(), saveRepresentation.getComment(), user);
        FormRepresentation result = new FormRepresentation(model);
        result.setFormDefinition(saveRepresentation.getFormRepresentation().getFormDefinition());
        return result;
    }

    protected FormRepresentation createFormRepresentation(AbstractModel model) {
        SimpleFormModel formDefinition = null;
        try {
            formDefinition = (SimpleFormModel)this.objectMapper.readValue(model.getModelEditorJson(), SimpleFormModel.class);
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing form", (Throwable)e);
            throw new InternalServerErrorException("Could not deserialize form definition");
        }
        FormRepresentation result = new FormRepresentation(model);
        result.setFormDefinition(formDefinition);
        return result;
    }
}

