/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.cmmn.converter.CmmnXmlConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.xml.converter.DmnXMLConverter;
import org.flowable.editor.dmn.converter.DmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.AppDefinition;
import org.flowable.ui.modeler.domain.AppModelDefinition;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.repository.ModelRepository;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseAppDefinitionService {
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ObjectMapper objectMapper;
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();
    protected BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
    protected DmnJsonConverter dmnJsonConverter = new DmnJsonConverter();
    protected DmnXMLConverter dmnXMLConverter = new DmnXMLConverter();
    protected CmmnJsonConverter cmmnJsonConverter = new CmmnJsonConverter();
    protected CmmnXmlConverter cmmnXMLConverter = new CmmnXmlConverter();

    protected Map<String, StartEvent> processNoneStartEvents(BpmnModel bpmnModel) {
        HashMap<String, StartEvent> startEventMap = new HashMap<String, StartEvent>();
        block0: for (Process process : bpmnModel.getProcesses()) {
            for (FlowElement flowElement : process.getFlowElements()) {
                StartEvent startEvent;
                if (!(flowElement instanceof StartEvent) || !CollectionUtils.isEmpty((Collection)(startEvent = (StartEvent)flowElement).getEventDefinitions())) continue;
                if (StringUtils.isEmpty((CharSequence)startEvent.getInitiator())) {
                    startEvent.setInitiator("initiator");
                }
                startEventMap.put(process.getId(), startEvent);
                continue block0;
            }
        }
        return startEventMap;
    }

    protected void processUserTasks(Collection<FlowElement> flowElements, Process process, Map<String, StartEvent> startEventMap) {
        for (FlowElement flowElement : flowElements) {
            if (flowElement instanceof UserTask) {
                UserTask userTask = (UserTask)flowElement;
                if (!"$INITIATOR".equals(userTask.getAssignee()) || startEventMap.get(process.getId()) == null) continue;
                userTask.setAssignee("${" + startEventMap.get(process.getId()).getInitiator() + "}");
                continue;
            }
            if (!(flowElement instanceof SubProcess)) continue;
            this.processUserTasks(((SubProcess)flowElement).getFlowElements(), process, startEventMap);
        }
    }

    protected String getAppDefinitionJson(Model appDefinitionModel, AppDefinition appDefinition) {
        ObjectNode appDefinitionNode = this.objectMapper.createObjectNode();
        appDefinitionNode.put("key", appDefinitionModel.getKey());
        appDefinitionNode.put("name", appDefinitionModel.getName());
        appDefinitionNode.put("description", appDefinitionModel.getDescription());
        appDefinitionNode.put("theme", appDefinition.getTheme());
        appDefinitionNode.put("icon", appDefinition.getIcon());
        appDefinitionNode.put("usersAccess", appDefinition.getUsersAccess());
        appDefinitionNode.put("groupsAccess", appDefinition.getGroupsAccess());
        return appDefinitionNode.toString();
    }

    protected AppDefinition resolveAppDefinition(Model appDefinitionModel) throws Exception {
        AppDefinition appDefinition = (AppDefinition)this.objectMapper.readValue(appDefinitionModel.getModelEditorJson(), AppDefinition.class);
        return appDefinition;
    }

    protected byte[] createDeployableZipArtifact(Model appDefinitionModel, AppDefinition appDefinition) {
        byte[] deployZipArtifact = null;
        HashMap<String, byte[]> deployableAssets = new HashMap<String, byte[]>();
        if (CollectionUtils.isNotEmpty(appDefinition.getModels()) || CollectionUtils.isNotEmpty(appDefinition.getCmmnModels())) {
            String appDefinitionJson = this.getAppDefinitionJson(appDefinitionModel, appDefinition);
            byte[] appDefinitionJsonBytes = appDefinitionJson.getBytes(StandardCharsets.UTF_8);
            deployableAssets.put(appDefinitionModel.getKey() + ".app", appDefinitionJsonBytes);
            HashMap<String, Model> formMap = new HashMap<String, Model>();
            HashMap<String, Model> decisionTableMap = new HashMap<String, Model>();
            HashMap<String, Model> caseModelMap = new HashMap<String, Model>();
            HashMap<String, Model> processModelMap = new HashMap<String, Model>();
            this.createDeployableAppModels(appDefinitionModel, appDefinition, deployableAssets, formMap, decisionTableMap, caseModelMap, processModelMap);
            if (formMap.size() > 0) {
                for (String formId : formMap.keySet()) {
                    Model formInfo = (Model)formMap.get(formId);
                    String formModelEditorJson = formInfo.getModelEditorJson();
                    byte[] formModelEditorJsonBytes = formModelEditorJson.getBytes(StandardCharsets.UTF_8);
                    deployableAssets.put("form-" + formInfo.getKey() + ".form", formModelEditorJsonBytes);
                }
            }
            if (decisionTableMap.size() > 0) {
                for (String decisionTableId : decisionTableMap.keySet()) {
                    Model decisionTableInfo = (Model)decisionTableMap.get(decisionTableId);
                    try {
                        JsonNode decisionTableNode = this.objectMapper.readTree(decisionTableInfo.getModelEditorJson());
                        DmnDefinition dmnDefinition = this.dmnJsonConverter.convertToDmn(decisionTableNode, decisionTableInfo.getId(), decisionTableInfo.getVersion(), decisionTableInfo.getLastUpdated());
                        byte[] dmnXMLBytes = this.dmnXMLConverter.convertToXML(dmnDefinition);
                        deployableAssets.put("dmn-" + decisionTableInfo.getKey() + ".dmn", dmnXMLBytes);
                    }
                    catch (Exception e) {
                        throw new InternalServerErrorException(String.format("Error converting decision table %s to XML", decisionTableInfo.getName()));
                    }
                }
            }
            deployZipArtifact = this.createDeployZipArtifact(deployableAssets);
        }
        return deployZipArtifact;
    }

    protected void createDeployableAppModels(Model appDefinitionModel, AppDefinition appDefinition, Map<String, byte[]> deployableAssets, Map<String, Model> formMap, Map<String, Model> decisionTableMap, Map<String, Model> caseModelMap, Map<String, Model> processModelMap) {
        ArrayList<AppModelDefinition> appModels = new ArrayList<AppModelDefinition>();
        if (appDefinition.getModels() != null) {
            appModels.addAll(appDefinition.getModels());
        }
        if (appDefinition.getCmmnModels() != null) {
            appModels.addAll(appDefinition.getCmmnModels());
        }
        for (AppModelDefinition appModelDef : appModels) {
            if (caseModelMap.containsKey(appModelDef.getId()) || processModelMap.containsKey(appModelDef.getId())) {
                return;
            }
            Model model = this.modelService.getModel(appModelDef.getId());
            if (model == null) {
                throw new BadRequestException(String.format("Model %s for app definition %s could not be found", appModelDef.getId(), appDefinitionModel.getId()));
            }
            this.createDeployableModels(model, deployableAssets, formMap, decisionTableMap, caseModelMap, processModelMap);
        }
    }

    protected void createDeployableModels(AbstractModel parentModel, Map<String, byte[]> deployableAssets, Map<String, Model> formMap, Map<String, Model> decisionTableMap, Map<String, Model> caseModelMap, Map<String, Model> processModelMap) {
        List<Model> referencedModels = this.modelRepository.findByParentModelId(parentModel.getId());
        for (Model childModel : referencedModels) {
            if (2 == childModel.getModelType()) {
                formMap.put(childModel.getId(), childModel);
                continue;
            }
            if (4 == childModel.getModelType()) {
                decisionTableMap.put(childModel.getId(), childModel);
                continue;
            }
            if (5 == childModel.getModelType()) {
                caseModelMap.put(childModel.getId(), childModel);
                this.createDeployableModels(childModel, deployableAssets, formMap, decisionTableMap, caseModelMap, processModelMap);
                continue;
            }
            if (0 != childModel.getModelType()) continue;
            processModelMap.put(childModel.getId(), childModel);
            this.createDeployableModels(childModel, deployableAssets, formMap, decisionTableMap, caseModelMap, processModelMap);
        }
        if (parentModel.getModelType() == null || parentModel.getModelType() == 0) {
            BpmnModel bpmnModel = this.modelService.getBpmnModel(parentModel, formMap, decisionTableMap);
            Map<String, StartEvent> startEventMap = this.processNoneStartEvents(bpmnModel);
            for (Process process : bpmnModel.getProcesses()) {
                this.processUserTasks(process.getFlowElements(), process, startEventMap);
            }
            byte[] modelXML = this.modelService.getBpmnXML(bpmnModel);
            deployableAssets.put(parentModel.getKey().replaceAll(" ", "") + ".bpmn", modelXML);
        } else {
            CmmnModel cmmnModel = this.modelService.getCmmnModel(parentModel, formMap, decisionTableMap, caseModelMap, processModelMap);
            byte[] modelXML = this.modelService.getCmmnXML(cmmnModel);
            deployableAssets.put(parentModel.getKey().replaceAll(" ", "") + ".cmmn", modelXML);
        }
    }

    /*
     * Exception decompiling
     */
    protected byte[] createDeployZipArtifact(Map<String, byte[]> deployableAssets) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

