/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.spring.boot.FlowableSecurityAutoConfiguration;
import org.flowable.spring.boot.idm.IdmEngineServicesAutoConfiguration;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.common.rest.idm.CurrentUserProvider;
import org.flowable.ui.common.rest.idm.OAuth2CurrentUserProvider;
import org.flowable.ui.common.security.ActuatorRequestMatcher;
import org.flowable.ui.common.security.ApiHttpSecurityCustomizer;
import org.flowable.ui.common.security.ClearFlowableCookieLogoutHandler;
import org.flowable.ui.common.security.CustomPersistentRememberMeServices;
import org.flowable.ui.common.security.DefaultApiHttpSecurityCustomizer;
import org.flowable.ui.common.security.DelegatingApiHttpSecurityCustomizer;
import org.flowable.ui.common.security.FixUserApiHttpSecurityCustomizer;
import org.flowable.ui.common.security.FlowableJwtGrantedAuthoritiesMapper;
import org.flowable.ui.common.security.FlowableOAuth2GrantedAuthoritiesMapper;
import org.flowable.ui.common.security.FlowableSecurityScopeProvider;
import org.flowable.ui.common.security.FlowableUiCustomFormLoginConfigurer;
import org.flowable.ui.common.security.IdmEnginePersistentTokenService;
import org.flowable.ui.common.security.JwtApiHttpSecurityCustomizer;
import org.flowable.ui.common.security.PersistentTokenService;
import org.flowable.ui.common.security.RemoteIdmAuthenticationProvider;
import org.flowable.ui.common.security.RemoteIdmPersistentTokenService;
import org.flowable.ui.common.security.RemoteIdmUserDetailsService;
import org.flowable.ui.common.security.SecurityScopeProvider;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.flowable.ui.common.service.idm.RemoteIdmServiceImpl;
import org.flowable.ui.common.service.idm.cache.RemoteIdmUserCache;
import org.flowable.ui.common.service.idm.cache.UserCache;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.info.InfoEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.client.servlet.OAuth2ClientAutoConfiguration;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.context.NullSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.XXssProtectionHeaderWriter;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={IdmEngineServicesAutoConfiguration.class})
@AutoConfigureBefore(value={FlowableSecurityAutoConfiguration.class, OAuth2ClientAutoConfiguration.class})
public class FlowableUiSecurityAutoConfiguration {
    private static final Customizer<ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry> DEFAULT_AUTHORIZE_REQUESTS = requests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.antMatchers(new String[]{"/app/rest/account"})).authenticated().antMatchers(new String[]{"/app/rest/runtime/app-definitions"})).authenticated().antMatchers(new String[]{"/idm-app/rest/authenticate"})).authenticated().antMatchers(new String[]{"/idm-app/rest/account"})).authenticated().antMatchers(new String[]{"/app/rest/**", "/workflow/"})).hasAuthority("access-task").antMatchers(new String[]{"/admin-app/**", "/admin/"})).hasAuthority("access-admin").antMatchers(new String[]{"/idm-app/**"})).hasAuthority("access-idm").antMatchers(new String[]{"/modeler-app/**", "/modeler/"})).hasAuthority("access-modeler").antMatchers(new String[]{"/"})).authenticated().antMatchers(new String[]{"/app/authentication"})).permitAll().antMatchers(new String[]{"/idm"})).permitAll();
    private static final Customizer<LogoutConfigurer<HttpSecurity>> DEFAULT_LOGOUT = logout -> logout.logoutUrl("/app/logout");
    private static final Customizer<HeadersConfigurer<HttpSecurity>> DEFAULT_HEADERS = headers -> headers.frameOptions().sameOrigin().addHeaderWriter((HeaderWriter)new XXssProtectionHeaderWriter());

    public FlowableUiSecurityAutoConfiguration(ObjectProvider<SecurityScopeProvider> securityScopeProvider) {
        SecurityUtils.setSecurityScopeProvider((SecurityScopeProvider)securityScopeProvider.getIfAvailable(FlowableSecurityScopeProvider::new));
    }

    @Bean
    @ConditionalOnMissingBean
    public RememberMeServices flowableUiRememberMeService(FlowableCommonAppProperties properties, UserDetailsService userDetailsService, PersistentTokenService persistentTokenService) {
        return new CustomPersistentRememberMeServices(properties, userDetailsService, persistentTokenService);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="flowable.common.app.security", name={"type"}, havingValue="idm", matchIfMissing=true)
    public ApiHttpSecurityCustomizer defaultApiHttpSecurityCustomizer() {
        return new DefaultApiHttpSecurityCustomizer();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={EndpointRequest.class})
    @Order(value=5)
    public static class ActuatorWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        protected final ApiHttpSecurityCustomizer apiHttpSecurityCustomizer;

        public ActuatorWebSecurityConfigurationAdapter(ApiHttpSecurityCustomizer apiHttpSecurityCustomizer) {
            this.apiHttpSecurityCustomizer = apiHttpSecurityCustomizer;
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable();
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.requestMatcher((RequestMatcher)new ActuatorRequestMatcher()).authorizeRequests().requestMatchers(new RequestMatcher[]{EndpointRequest.to((Class[])new Class[]{InfoEndpoint.class, HealthEndpoint.class})})).authenticated().requestMatchers(new RequestMatcher[]{EndpointRequest.toAnyEndpoint()})).hasAnyAuthority(new String[]{"access-admin"});
            this.apiHttpSecurityCustomizer.customize(http);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Order(value=10)
    @ConditionalOnProperty(prefix="flowable.common.app.security", name={"type"}, havingValue="oauth2")
    public static class OAuthWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        private static final Pattern PASSWORD_ALGORITHM_PATTERN = Pattern.compile("^\\{.+}.*$");
        protected final FlowableCommonAppProperties commonAppProperties;
        protected final ObjectProvider<PasswordEncoder> passwordEncoder;

        public OAuthWebSecurityConfigurerAdapter(FlowableCommonAppProperties commonAppProperties, ObjectProvider<PasswordEncoder> passwordEncoder) {
            this.commonAppProperties = commonAppProperties;
            this.passwordEncoder = passwordEncoder;
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)http.logout(logout -> {
                DEFAULT_LOGOUT.customize(logout);
                OidcClientInitiatedLogoutSuccessHandler logoutSuccessHandler = new OidcClientInitiatedLogoutSuccessHandler((ClientRegistrationRepository)this.getApplicationContext().getBean(ClientRegistrationRepository.class));
                logoutSuccessHandler.setPostLogoutRedirectUri("{baseUrl}");
                logout.logoutSuccessHandler((LogoutSuccessHandler)logoutSuccessHandler);
            }).csrf().disable()).headers(DEFAULT_HEADERS).authorizeRequests(DEFAULT_AUTHORIZE_REQUESTS);
            http.oauth2Login();
            http.oauth2Client();
        }

        @Bean
        public GrantedAuthoritiesMapper keycloakAuthoritiesMapper() {
            FlowableCommonAppProperties.OAuth2 oAuth2 = this.commonAppProperties.getSecurity().getOAuth2();
            String authoritiesAttribute = oAuth2.getAuthoritiesAttribute();
            String groupsAttribute = oAuth2.getGroupsAttribute();
            Collection<String> defaultAuthorities = oAuth2.getDefaultAuthorities();
            Collection<String> defaultGroups = oAuth2.getDefaultGroups();
            return new FlowableOAuth2GrantedAuthoritiesMapper(authoritiesAttribute, groupsAttribute, defaultAuthorities, defaultGroups);
        }

        @Bean
        @ConditionalOnClass(value={Jwt.class})
        @ConditionalOnMissingBean
        public ApiHttpSecurityCustomizer delegatingApiHttpSecurityCustomizer() {
            JwtAuthenticationConverter converter = new JwtAuthenticationConverter();
            FlowableCommonAppProperties.OAuth2 oAuth2 = this.commonAppProperties.getSecurity().getOAuth2();
            String authoritiesAttribute = oAuth2.getAuthoritiesAttribute();
            String groupsAttribute = oAuth2.getGroupsAttribute();
            Collection<String> defaultAuthorities = oAuth2.getDefaultAuthorities();
            Collection<String> defaultGroups = oAuth2.getDefaultGroups();
            converter.setJwtGrantedAuthoritiesConverter((Converter)new FlowableJwtGrantedAuthoritiesMapper(authoritiesAttribute, groupsAttribute, defaultAuthorities, defaultGroups));
            JwtApiHttpSecurityCustomizer jwtApiHttpSecurityCustomizer = new JwtApiHttpSecurityCustomizer(converter);
            String username = this.commonAppProperties.getIdmAdmin().getUser();
            String password = this.commonAppProperties.getIdmAdmin().getPassword();
            FixUserApiHttpSecurityCustomizer fixUserApiHttpSecurityCustomizer = new FixUserApiHttpSecurityCustomizer(username, this.deducePassword(password));
            return new DelegatingApiHttpSecurityCustomizer(Arrays.asList(fixUserApiHttpSecurityCustomizer, jwtApiHttpSecurityCustomizer));
        }

        @Bean
        @ConditionalOnMissingClass(value={"org.springframework.security.oauth2.jwt.Jwt"})
        @ConditionalOnMissingBean
        public ApiHttpSecurityCustomizer fixUserApiHttpSecurityCustomizer() {
            String username = this.commonAppProperties.getIdmAdmin().getUser();
            String password = this.commonAppProperties.getIdmAdmin().getPassword();
            return new FixUserApiHttpSecurityCustomizer(username, this.deducePassword(password));
        }

        @Bean
        @ConditionalOnMissingBean(name={"oauth2CurrentUserProvider"})
        public CurrentUserProvider oauth2CurrentUserProvider() {
            FlowableCommonAppProperties.OAuth2 oAuth2 = this.commonAppProperties.getSecurity().getOAuth2();
            OAuth2CurrentUserProvider currentUserProvider = new OAuth2CurrentUserProvider();
            PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
            mapper.from((Object)oAuth2.getFirstNameAttribute()).to(currentUserProvider::setFirstNameKey);
            mapper.from((Object)oAuth2.getLastNameAttribute()).to(currentUserProvider::setLastNameKey);
            mapper.from((Object)oAuth2.getFullNameAttribute()).to(currentUserProvider::setFullNameKey);
            mapper.from((Object)oAuth2.getEmailAttribute()).to(currentUserProvider::setEmailKey);
            return currentUserProvider;
        }

        protected String deducePassword(String password) {
            PasswordEncoder passwordEncoder = (PasswordEncoder)this.passwordEncoder.getIfAvailable();
            if (PASSWORD_ALGORITHM_PATTERN.matcher(password).matches()) {
                return password;
            }
            if (passwordEncoder != null) {
                return passwordEncoder.encode((CharSequence)password);
            }
            return password;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Order(value=10)
    @ConditionalOnProperty(prefix="flowable.common.app.security", name={"type"}, havingValue="idm", matchIfMissing=true)
    public static class FormLoginWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        @Autowired
        protected ObjectProvider<RememberMeServices> rememberMeServicesObjectProvider;
        @Autowired
        protected FlowableCommonAppProperties commonAppProperties;

        protected void configure(HttpSecurity http) throws Exception {
            RememberMeServices rememberMeServices = (RememberMeServices)this.rememberMeServicesObjectProvider.getIfAvailable();
            String key = null;
            if (rememberMeServices instanceof AbstractRememberMeServices) {
                key = ((AbstractRememberMeServices)rememberMeServices).getKey();
            }
            if (rememberMeServices != null) {
                http.rememberMe().key(key).rememberMeServices(rememberMeServices);
            }
            ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.exceptionHandling().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).logout(logout -> {
                DEFAULT_LOGOUT.customize(logout);
                logout.logoutSuccessUrl("/");
                logout.addLogoutHandler((LogoutHandler)new ClearFlowableCookieLogoutHandler());
            }).csrf().disable()).headers(DEFAULT_HEADERS).securityContext().securityContextRepository((SecurityContextRepository)new NullSecurityContextRepository()).and()).authorizeRequests(DEFAULT_AUTHORIZE_REQUESTS);
            http.formLogin().disable();
            http.apply(new FlowableUiCustomFormLoginConfigurer());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.flowable.ui.idm.service.GroupServiceImpl"})
    public static class LocalIdmConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public PersistentTokenService flowableUiPersistentTokenService(IdmIdentityService idmIdentityService) {
            return new IdmEnginePersistentTokenService(idmIdentityService);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.flowable.ui.idm.service.GroupServiceImpl"})
    public static class RemoteIdmConfiguration {
        @Bean
        public RemoteIdmService remoteIdmService(FlowableCommonAppProperties properties) {
            return new RemoteIdmServiceImpl(properties);
        }

        @Bean
        public UserCache remoteIdmUserCache(FlowableCommonAppProperties properties, RemoteIdmService remoteIdmService) {
            return new RemoteIdmUserCache(properties, remoteIdmService);
        }

        @Bean
        @ConditionalOnMissingBean
        public UserDetailsService flowableUiUserDetailsService(RemoteIdmService remoteIdmService) {
            return new RemoteIdmUserDetailsService(remoteIdmService);
        }

        @Bean
        @ConditionalOnMissingBean
        public PersistentTokenService flowableUiPersistentTokenService(RemoteIdmService remoteIdmService) {
            return new RemoteIdmPersistentTokenService(remoteIdmService);
        }

        @Bean
        public RemoteIdmAuthenticationProvider remoteIdmAuthenticationProvider(RemoteIdmService remoteIdmService) {
            return new RemoteIdmAuthenticationProvider(remoteIdmService);
        }
    }
}

