/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.rest.exception;

import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.BaseModelerRestException;
import org.flowable.ui.common.service.exception.ConflictingRequestException;
import org.flowable.ui.common.service.exception.ErrorInfo;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.common.service.exception.NonJsonResourceNotFoundException;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.common.service.exception.NotPermittedException;
import org.flowable.ui.common.service.exception.UnauthorizedException;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.LockedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class RestExceptionHandlerAdvice {
    private static final String UNAUTHORIZED_MESSAGE_KEY = "GENERAL.ERROR.UNAUTHORIZED";
    private static final String NOT_FOUND_MESSAGE_KEY = "GENERAL.ERROR.NOT-FOUND";
    private static final String BAD_REQUEST_MESSAGE_KEY = "GENERAL.ERROR.BAD-REQUEST";
    private static final String INTERNAL_SERVER_ERROR_MESSAGE_KEY = "GENERAL.ERROR.INTERNAL-SERVER_ERROR";
    private static final String FORBIDDEN_MESSAGE_KEY = "GENERAL.ERROR.FORBIDDEN";
    private static final String INACTIVE_USER_MESSAGE_KEY = "GENERAL.ERROR.INACTIVE_USER";

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NotFoundException.class})
    @ResponseBody
    public ErrorInfo handleNotFound(NotFoundException e) {
        return this.createInfoFromException(e, NOT_FOUND_MESSAGE_KEY);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NonJsonResourceNotFoundException.class})
    public void handleNonJsonResourceNotFound(NonJsonResourceNotFoundException e) {
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BadRequestException.class})
    @ResponseBody
    public ErrorInfo handleBadRequest(BadRequestException e) {
        return this.createInfoFromException(e, BAD_REQUEST_MESSAGE_KEY);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={InternalServerErrorException.class})
    @ResponseBody
    public ErrorInfo handleInternalServerError(InternalServerErrorException e) {
        return this.createInfoFromException(e, INTERNAL_SERVER_ERROR_MESSAGE_KEY);
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={NotPermittedException.class})
    @ResponseBody
    public ErrorInfo handleNoPermission(NotPermittedException e) {
        return this.createInfoFromException(e, FORBIDDEN_MESSAGE_KEY);
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={LockedException.class})
    @ResponseBody
    public ErrorInfo handleLockedUser(LockedException e) {
        ErrorInfo result = new ErrorInfo(e.getMessage());
        result.setMessageKey(INACTIVE_USER_MESSAGE_KEY);
        return result;
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseBody
    public ErrorInfo handleUnauthorized(UnauthorizedException e) {
        return this.createInfoFromException(e, UNAUTHORIZED_MESSAGE_KEY);
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={ConflictingRequestException.class})
    @ResponseBody
    public ErrorInfo handleConflict(ConflictingRequestException e) {
        return this.createInfoFromException(e, BAD_REQUEST_MESSAGE_KEY);
    }

    protected ErrorInfo createInfoFromException(BaseModelerRestException exception, String defaultMessageKey) {
        ErrorInfo result = null;
        result = new ErrorInfo(exception.getMessage());
        if (exception.getCustomData() != null) {
            result.setCustomData(exception.getCustomData());
        }
        if (exception.getMessageKey() != null) {
            result.setMessageKey(exception.getMessageKey());
        } else {
            result.setMessageKey(defaultMessageKey);
        }
        return result;
    }

    protected String getSafeMessageKey(String fragment) {
        if (fragment != null) {
            return fragment.toUpperCase();
        }
        return "";
    }
}

