/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.tenant;

import org.apache.commons.lang3.StringUtils;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.common.security.SecurityScope;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.tenant.TenantProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultTenantProvider
implements TenantProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTenantProvider.class);
    private String tenantId;

    public DefaultTenantProvider(FlowableCommonAppProperties commonAppProperties) {
        String configuredTenantId = commonAppProperties.getTenantId();
        if (!StringUtils.isBlank((CharSequence)configuredTenantId)) {
            configuredTenantId = configuredTenantId.trim();
            LOGGER.debug("Found configured tenantId: '{}'", (Object)configuredTenantId);
            this.tenantId = configuredTenantId;
        }
    }

    @Override
    public String getTenantId() {
        if (this.tenantId != null) {
            LOGGER.debug("Using configured tenantId: '{}'", (Object)this.tenantId);
            return this.tenantId;
        }
        SecurityScope currentSecurityScope = SecurityUtils.getCurrentSecurityScope();
        if (currentSecurityScope != null) {
            String tenantId = currentSecurityScope.getTenantId();
            LOGGER.debug("Using user tenantId: '{}'", (Object)tenantId);
            return tenantId;
        }
        LOGGER.debug("No tenantId");
        return null;
    }
}

