/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.service.idm.cache;

import java.util.ArrayList;
import org.flowable.ui.common.model.RemoteUser;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.flowable.ui.common.service.idm.cache.BaseUserCache;
import org.flowable.ui.common.service.idm.cache.UserCache;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class RemoteIdmUserCache
extends BaseUserCache {
    protected final RemoteIdmService remoteIdmService;

    public RemoteIdmUserCache(FlowableCommonAppProperties properties, RemoteIdmService remoteIdmService) {
        super(properties);
        this.remoteIdmService = remoteIdmService;
    }

    @Override
    protected UserCache.CachedUser loadUser(String userId) {
        RemoteUser user = this.remoteIdmService.getUser(userId);
        if (user == null) {
            throw new UsernameNotFoundException("User " + userId + " was not found in the database");
        }
        ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
        return new UserCache.CachedUser(user, grantedAuthorities);
    }
}

