/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;
import org.flowable.ui.common.security.SecurityUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.oauth2.core.user.OAuth2UserAuthority;

public class FlowableOAuth2GrantedAuthoritiesMapper
implements GrantedAuthoritiesMapper {
    protected final String authoritiesAttribute;
    protected final String groupsAttribute;
    protected final Collection<GrantedAuthority> defaultAuthorities;

    public FlowableOAuth2GrantedAuthoritiesMapper(String authoritiesAttribute, String groupsAttribute, Collection<String> defaultAuthorities, Collection<String> defaultGroups) {
        this.authoritiesAttribute = authoritiesAttribute;
        this.groupsAttribute = groupsAttribute;
        this.defaultAuthorities = new LinkedHashSet<GrantedAuthority>();
        if (defaultAuthorities != null) {
            for (String defaultAuthority : defaultAuthorities) {
                this.defaultAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(defaultAuthority));
            }
        }
        if (defaultGroups != null) {
            for (String defaultGroup : defaultGroups) {
                this.defaultAuthorities.add(SecurityUtils.createGroupAuthority(defaultGroup));
            }
        }
    }

    public Collection<? extends GrantedAuthority> mapAuthorities(Collection<? extends GrantedAuthority> authorities) {
        ArrayList<? extends GrantedAuthority> newAuthorities = new ArrayList<GrantedAuthority>(authorities);
        OAuth2UserAuthority userAuthority = this.getOAuth2UserAuthority(authorities);
        if (userAuthority instanceof OidcUserAuthority) {
            Object claim;
            OidcUserAuthority oidcUserAuthority = (OidcUserAuthority)userAuthority;
            if (StringUtils.isNotBlank((CharSequence)this.authoritiesAttribute)) {
                claim = oidcUserAuthority.getUserInfo().getClaim(this.authoritiesAttribute);
                Collection<String> extraAuthorities = this.asStringCollection(claim);
                for (String extraAuthority : extraAuthorities) {
                    newAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(extraAuthority));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.groupsAttribute)) {
                claim = oidcUserAuthority.getUserInfo().getClaim(this.groupsAttribute);
                Collection<String> groups = this.asStringCollection(claim);
                for (String group : groups) {
                    newAuthorities.add((GrantedAuthority)SecurityUtils.createGroupAuthority(group));
                }
            }
        } else if (userAuthority != null) {
            Object attribute;
            if (StringUtils.isNotBlank((CharSequence)this.authoritiesAttribute)) {
                attribute = userAuthority.getAttributes().get(this.authoritiesAttribute);
                Collection<String> extraAuthorities = this.asStringCollection(attribute);
                for (String extraAuthority : extraAuthorities) {
                    newAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(extraAuthority));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.groupsAttribute)) {
                attribute = userAuthority.getAttributes().get(this.groupsAttribute);
                Collection<String> groups = this.asStringCollection(attribute);
                for (String group : groups) {
                    newAuthorities.add((GrantedAuthority)SecurityUtils.createGroupAuthority(group));
                }
            }
        }
        newAuthorities.addAll(this.defaultAuthorities);
        return newAuthorities;
    }

    protected Collection<String> asStringCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof String) {
            return Arrays.asList(((String)value).split(","));
        }
        return Collections.emptyList();
    }

    protected OAuth2UserAuthority getOAuth2UserAuthority(Collection<? extends GrantedAuthority> authorities) {
        for (GrantedAuthority grantedAuthority : authorities) {
            if (!(grantedAuthority instanceof OAuth2UserAuthority)) continue;
            return (OAuth2UserAuthority)grantedAuthority;
        }
        return null;
    }
}

