/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.properties;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="flowable.common.app")
public class FlowableCommonAppProperties {
    private String tenantId;
    private String rolePrefix = "ROLE_";
    private String idmUrl;
    private String idmRedirectUrl;
    private String redirectOnAuthSuccess;
    @NestedConfigurationProperty
    private final Cache cacheLoginTokens = new Cache();
    @NestedConfigurationProperty
    private final Cache cacheLoginUsers = new Cache();
    @NestedConfigurationProperty
    private final Cache cacheUsers = new Cache();
    @NestedConfigurationProperty
    private final Admin idmAdmin = new Admin();
    @NestedConfigurationProperty
    private final Security security = new Security();

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public String getIdmUrl() {
        return this.idmUrl;
    }

    public void setIdmUrl(String idmUrl) {
        this.idmUrl = idmUrl;
    }

    public String getIdmRedirectUrl() {
        return this.idmRedirectUrl;
    }

    public void setIdmRedirectUrl(String idmRedirectUrl) {
        this.idmRedirectUrl = idmRedirectUrl;
    }

    public String getRedirectOnAuthSuccess() {
        return this.redirectOnAuthSuccess;
    }

    public void setRedirectOnAuthSuccess(String redirectOnAuthSuccess) {
        this.redirectOnAuthSuccess = redirectOnAuthSuccess;
    }

    public Cache getCacheLoginTokens() {
        return this.cacheLoginTokens;
    }

    public Cache getCacheLoginUsers() {
        return this.cacheLoginUsers;
    }

    public Cache getCacheUsers() {
        return this.cacheUsers;
    }

    public Admin getIdmAdmin() {
        return this.idmAdmin;
    }

    public Security getSecurity() {
        return this.security;
    }

    public String determineIdmAppUrl() {
        String idmAppUrl = this.getIdmUrl();
        Assert.hasText((String)idmAppUrl, (String)"`flowable.common.app.idm-url` must be set");
        if (!idmAppUrl.endsWith("/")) {
            idmAppUrl = idmAppUrl + "/";
        }
        return idmAppUrl;
    }

    public String determineIdmAppRedirectUrl() {
        String idmAppRedirectUrl = this.getIdmRedirectUrl();
        if (idmAppRedirectUrl != null && idmAppRedirectUrl.length() > 0) {
            if (!idmAppRedirectUrl.endsWith("/")) {
                idmAppRedirectUrl = idmAppRedirectUrl + "/";
            }
            return idmAppRedirectUrl;
        }
        return this.determineIdmAppUrl();
    }

    public static class Cookie {
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration maxAge = Duration.ofDays(31L);
        private String domain;
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration refreshAge = Duration.ofDays(1L);

        public Duration getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(Duration maxAge) {
            this.maxAge = maxAge;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public Duration getRefreshAge() {
            return this.refreshAge;
        }

        public void setRefreshAge(Duration refreshAge) {
            this.refreshAge = refreshAge;
        }
    }

    public static class OAuth2 {
        private String authoritiesAttribute;
        private String groupsAttribute;
        private Collection<String> defaultAuthorities;
        private Collection<String> defaultGroups;
        private String firstNameAttribute;
        private String lastNameAttribute;
        private String fullNameAttribute;
        private String emailAttribute;

        public String getAuthoritiesAttribute() {
            return this.authoritiesAttribute;
        }

        public void setAuthoritiesAttribute(String authoritiesAttribute) {
            this.authoritiesAttribute = authoritiesAttribute;
        }

        public String getGroupsAttribute() {
            return this.groupsAttribute;
        }

        public void setGroupsAttribute(String groupsAttribute) {
            this.groupsAttribute = groupsAttribute;
        }

        public Collection<String> getDefaultAuthorities() {
            return this.defaultAuthorities;
        }

        public void setDefaultAuthorities(Collection<String> defaultAuthorities) {
            this.defaultAuthorities = defaultAuthorities;
        }

        public Collection<String> getDefaultGroups() {
            return this.defaultGroups;
        }

        public void setDefaultGroups(Collection<String> defaultGroups) {
            this.defaultGroups = defaultGroups;
        }

        public String getFirstNameAttribute() {
            return this.firstNameAttribute;
        }

        public void setFirstNameAttribute(String firstNameAttribute) {
            this.firstNameAttribute = firstNameAttribute;
        }

        public String getLastNameAttribute() {
            return this.lastNameAttribute;
        }

        public void setLastNameAttribute(String lastNameAttribute) {
            this.lastNameAttribute = lastNameAttribute;
        }

        public String getFullNameAttribute() {
            return this.fullNameAttribute;
        }

        public void setFullNameAttribute(String fullNameAttribute) {
            this.fullNameAttribute = fullNameAttribute;
        }

        public String getEmailAttribute() {
            return this.emailAttribute;
        }

        public void setEmailAttribute(String emailAttribute) {
            this.emailAttribute = emailAttribute;
        }
    }

    public static class Security {
        private String rememberMeKey = "testKey";
        @NestedConfigurationProperty
        private final Cookie cookie = new Cookie();
        private long userValidityPeriod = 30000L;
        private String type = "idm";
        private final OAuth2 oAuth2 = new OAuth2();

        public String getRememberMeKey() {
            return this.rememberMeKey;
        }

        public void setRememberMeKey(String rememberMeKey) {
            this.rememberMeKey = rememberMeKey;
        }

        public Cookie getCookie() {
            return this.cookie;
        }

        public long getUserValidityPeriod() {
            return this.userValidityPeriod;
        }

        public void setUserValidityPeriod(long userValidityPeriod) {
            this.userValidityPeriod = userValidityPeriod;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public OAuth2 getOAuth2() {
            return this.oAuth2;
        }
    }

    public static class Admin {
        private String user = "admin";
        private String password;

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class Cache {
        private long maxSize = 2048L;
        private long maxAge = 30L;

        public long getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(long maxSize) {
            this.maxSize = maxSize;
        }

        public long getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(long maxAge) {
            this.maxAge = maxAge;
        }
    }
}

