/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.filter;

import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import org.flowable.ui.common.filter.FlowableCookieFilter;
import org.flowable.ui.common.filter.FlowableCookieFilterCallback;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;

public class FlowableCookieFilterRegistrationBean
extends FilterRegistrationBean {
    protected final RemoteIdmService remoteIdmService;
    protected final FlowableCommonAppProperties properties;
    protected FlowableCookieFilterCallback filterCallback;
    protected Collection<String> requiredPrivileges;

    public FlowableCookieFilterRegistrationBean(RemoteIdmService remoteIdmService, FlowableCommonAppProperties properties) {
        this.remoteIdmService = remoteIdmService;
        this.properties = properties;
    }

    @PostConstruct
    protected void initializeFilter() {
        if (this.getFilter() == null) {
            FlowableCookieFilter flowableCookieFilter = new FlowableCookieFilter(this.remoteIdmService, this.properties);
            flowableCookieFilter.setFilterCallback(this.filterCallback);
            flowableCookieFilter.setRequiredPrivileges(this.requiredPrivileges);
            flowableCookieFilter.initCaches();
            this.setFilter((Filter)flowableCookieFilter);
        }
    }

    @Autowired(required=false)
    public void setFilterCallback(FlowableCookieFilterCallback filterCallback) {
        this.filterCallback = filterCallback;
    }

    public void setRequiredPrivileges(Collection<String> requiredPrivileges) {
        this.requiredPrivileges = requiredPrivileges;
    }
}

