/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.ProcessInstanceService;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessInstancesClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstancesClientResource.class);
    @Autowired
    protected ProcessInstanceService clientService;
    protected ObjectMapper objectMapper = new ObjectMapper();

    @PostMapping(value={"/rest/admin/process-instances"}, consumes={"application/json"}, produces={"application/json"})
    public JsonNode listProcessInstances(@RequestBody ObjectNode bodyNode) {
        LOGGER.debug("REST request to get a list of process instances");
        JsonNode resultNode = null;
        try {
            ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.PROCESS);
            resultNode = this.clientService.listProcesInstances(bodyNode, serverConfig);
        }
        catch (Exception e) {
            LOGGER.error("Error processing process instance list request", (Throwable)e);
            throw new BadRequestException(e.getMessage());
        }
        return resultNode;
    }
}

