/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.flowable.ui.admin.domain.EndpointType;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.rest.client.AbstractClientResource;
import org.flowable.ui.admin.service.engine.FormDefinitionService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FormDefinitionClientResource
extends AbstractClientResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormDefinitionClientResource.class);
    @Autowired
    protected FormDefinitionService clientService;

    @GetMapping(value={"/rest/admin/form-definitions/{formDefinitionId}"}, produces={"application/json"})
    public JsonNode getFormDefinition(@PathVariable String formDefinitionId) throws BadRequestException {
        ServerConfig serverConfig = this.retrieveServerConfig(EndpointType.FORM);
        try {
            return this.clientService.getForm(serverConfig, formDefinitionId);
        }
        catch (FlowableServiceException e) {
            LOGGER.error("Error getting form definition {}", (Object)formDefinitionId, (Object)e);
            throw new BadRequestException(e.getMessage());
        }
    }
}

