/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.flowable.ui.admin.properties.FlowableAdminAppProperties;
import org.flowable.ui.admin.service.engine.AbstractEncryptingService;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EndpointUserProfileService
extends AbstractEncryptingService {
    @Autowired
    protected FlowableClientService clientUtil;

    public EndpointUserProfileService(FlowableAdminAppProperties properties) {
        super(properties);
    }

    public String getEndpointUserTenantIdUsingEncryptedPassword(String contextRoot, String restRoot, String serverAddress, Integer port, String userName, String encryptedPassword) {
        String decryptedPassword = this.decrypt(encryptedPassword);
        return this.getEndpointUserTenantId(contextRoot, restRoot, serverAddress, port, userName, decryptedPassword);
    }

    public String getEndpointUserTenantId(String contextRoot, String restRoot, String serverAddress, Integer port, String userName, String password) {
        JsonNode jsonNode = this.getEndpointUserProfile(contextRoot, restRoot, serverAddress, port, userName, password);
        if (jsonNode.has("tenantId") && !jsonNode.get("tenantId").isNull()) {
            JsonNode tenantIdNode = jsonNode.get("tenantId");
            return tenantIdNode.asText();
        }
        return null;
    }

    public JsonNode getEndpointUserProfile(String contextRoot, String restRoot, String serverAddress, Integer port, String userName, String password) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(contextRoot, restRoot, serverAddress, port, "enterprise/profile"));
        return this.clientUtil.executeRequest((HttpUriRequest)get, userName, password);
    }
}

