/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DecisionTableService {
    @Autowired
    protected FlowableClientService clientUtil;

    public JsonNode listDecisionTables(ServerConfig serverConfig, Map<String, String[]> parameterMap) {
        URIBuilder builder = this.clientUtil.createUriBuilder("dmn-repository/decision-tables");
        for (String name : parameterMap.keySet()) {
            builder.addParameter(name, parameterMap.get(name)[0]);
        }
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder.toString()));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getDecisionTable(ServerConfig serverConfig, String decisionTableId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "dmn-repository/decision-tables/" + decisionTableId));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getEditorJsonForDecisionTable(ServerConfig serverConfig, String decisionTableId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "enterprise/decisions/decision-tables/" + decisionTableId + "/editorJson"));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getProcessDefinitionDecisionTables(ServerConfig serverConfig, String processDefinitionId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "repository/process-definitions/" + processDefinitionId + "/decision-tables"));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getCaseDefinitionDecisionTables(ServerConfig serverConfig, String caseDefinitionId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "cmmn-repository/case-definitions/" + caseDefinitionId + "/decision-tables"));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }
}

