/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppDefinitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppDefinitionService.class);
    @Autowired
    protected FlowableClientService clientUtil;
    @Autowired
    protected ObjectMapper objectMapper;

    public JsonNode listAppDefinitions(ServerConfig serverConfig, Map<String, String[]> parameterMap) {
        URIBuilder builder = this.clientUtil.createUriBuilder("app-repository/app-definitions");
        for (String name : parameterMap.keySet()) {
            builder.addParameter(name, parameterMap.get(name)[0]);
        }
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder.toString()));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getAppDefinition(ServerConfig serverConfig, String appDefinitionId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "app-repository/app-definitions/" + appDefinitionId));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getAppDefinitionProcessDefinitions(ServerConfig serverConfig, String deploymentId) {
        return this.getDefinitions("repository/deployments?parentDeploymentId=" + deploymentId, "repository/process-definitions?deploymentId=", serverConfig);
    }

    public JsonNode getAppDefinitionCaseDefinitions(ServerConfig serverConfig, String deploymentId) {
        return this.getDefinitions("cmmn-repository/deployments?parentDeploymentId=" + deploymentId, "cmmn-repository/case-definitions?deploymentId=", serverConfig);
    }

    public JsonNode getAppDefinitionDecisionTables(ServerConfig serverConfig, String deploymentId) {
        return this.getDefinitions("dmn-repository/deployments?parentDeploymentId=" + deploymentId, "dmn-repository/decision-tables?deploymentId=", serverConfig);
    }

    public JsonNode getAppDefinitionFormDefinitions(ServerConfig serverConfig, String deploymentId) {
        return this.getDefinitions("form-repository/deployments?parentDeploymentId=" + deploymentId, "form-repository/form-definitions?deploymentId=", serverConfig);
    }

    protected JsonNode getDefinitions(String deploymentUrl, String definitionUrl, ServerConfig serverConfig) {
        JsonNode deploymentArrayNode;
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, deploymentUrl));
        JsonNode deploymentsNode = this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
        if (deploymentsNode != null && deploymentsNode.has("data") && !(deploymentArrayNode = deploymentsNode.get("data")).isNull() && deploymentArrayNode.isArray() && deploymentArrayNode.size() > 0) {
            String restDeploymentId = deploymentArrayNode.get(0).get("id").asText();
            HttpGet getDefinitions = new HttpGet(this.clientUtil.getServerUrl(serverConfig, definitionUrl + restDeploymentId));
            return this.clientUtil.executeRequest((HttpUriRequest)getDefinitions, serverConfig);
        }
        ObjectNode emptyDefinitionNode = this.objectMapper.createObjectNode();
        emptyDefinitionNode.put("size", 0);
        emptyDefinitionNode.putArray("data");
        return emptyDefinitionNode;
    }
}

