/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.identitylink.service.IdentityLinkServiceConfiguration;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.impl.persistence.entity.AbstractTaskServiceEntity;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.util.TaskVariableUtils;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInitializingList;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.flowable.variable.service.impl.util.CommandContextUtil;

public class HistoricTaskInstanceEntityImpl
extends AbstractTaskServiceEntity
implements HistoricTaskInstanceEntity {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String taskDefinitionId;
    protected String scopeId;
    protected String subScopeId;
    protected String scopeType;
    protected String scopeDefinitionId;
    protected String propagatedStageInstanceId;
    protected String state;
    protected Date createTime;
    protected Date inProgressStartTime;
    protected String inProgressStartedBy;
    protected Date claimTime;
    protected String claimedBy;
    protected Date suspendedTime;
    protected String suspendedBy;
    protected Date endTime;
    protected String completedBy;
    protected Long durationInMillis;
    protected String deleteReason;
    protected String name;
    protected String localizedName;
    protected String parentTaskId;
    protected String description;
    protected String localizedDescription;
    protected String owner;
    protected String assignee;
    protected String taskDefinitionKey;
    protected String formKey;
    protected int priority;
    protected Date inProgressStartDueDate;
    protected Date dueDate;
    protected String category;
    protected String tenantId = "";
    protected Date lastUpdateTime;
    protected List<HistoricVariableInstanceEntity> queryVariables;
    protected List<HistoricIdentityLinkEntity> queryIdentityLinks;
    protected List<HistoricIdentityLinkEntity> identityLinks = new ArrayList<HistoricIdentityLinkEntity>();
    protected boolean isIdentityLinksInitialized;

    public HistoricTaskInstanceEntityImpl() {
    }

    public HistoricTaskInstanceEntityImpl(TaskEntity task) {
        this.id = task.getId();
        this.taskDefinitionId = task.getTaskDefinitionId();
        this.processDefinitionId = task.getProcessDefinitionId();
        this.processInstanceId = task.getProcessInstanceId();
        this.executionId = task.getExecutionId();
        this.scopeId = task.getScopeId();
        this.subScopeId = task.getSubScopeId();
        this.scopeType = task.getScopeType();
        this.scopeDefinitionId = task.getScopeDefinitionId();
        this.propagatedStageInstanceId = task.getPropagatedStageInstanceId();
        this.state = task.getState();
        this.name = task.getName();
        this.parentTaskId = task.getParentTaskId();
        this.description = task.getDescription();
        this.owner = task.getOwner();
        this.assignee = task.getAssignee();
        this.createTime = task.getCreateTime();
        this.inProgressStartTime = task.getInProgressStartTime();
        this.inProgressStartedBy = task.getInProgressStartedBy();
        this.claimTime = task.getClaimTime();
        this.claimedBy = task.getClaimedBy();
        this.suspendedTime = task.getSuspendedTime();
        this.suspendedBy = task.getSuspendedBy();
        this.taskDefinitionKey = task.getTaskDefinitionKey();
        this.formKey = task.getFormKey();
        this.priority = task.getPriority();
        this.inProgressStartDueDate = task.getInProgressStartDueDate();
        this.dueDate = task.getDueDate();
        this.category = task.getCategory();
        if (task.getTenantId() != null) {
            this.tenantId = task.getTenantId();
        }
    }

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("name", this.name);
        persistentState.put("owner", this.owner);
        persistentState.put("assignee", this.assignee);
        persistentState.put("state", this.state);
        persistentState.put("createTime", this.createTime);
        persistentState.put("inProgressStartTime", this.inProgressStartTime);
        persistentState.put("inProgressStartedBy", this.inProgressStartedBy);
        persistentState.put("claimTime", this.claimTime);
        persistentState.put("claimedBy", this.claimedBy);
        persistentState.put("suspendedTime", this.suspendedTime);
        persistentState.put("suspendedBy", this.suspendedBy);
        persistentState.put("endTime", this.endTime);
        persistentState.put("completedBy", this.completedBy);
        persistentState.put("durationInMillis", this.durationInMillis);
        persistentState.put("description", this.description);
        persistentState.put("deleteReason", this.deleteReason);
        persistentState.put("taskDefinitionKey", this.taskDefinitionKey);
        persistentState.put("formKey", this.formKey);
        persistentState.put("priority", this.priority);
        persistentState.put("category", this.category);
        persistentState.put("executionId", this.executionId);
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("taskDefinitionId", this.taskDefinitionId);
        persistentState.put("scopeId", this.scopeId);
        persistentState.put("subScopeId", this.subScopeId);
        persistentState.put("scopeType", this.scopeType);
        persistentState.put("scopeDefinitionId", this.scopeDefinitionId);
        persistentState.put("propagatedStageInstanceId", this.propagatedStageInstanceId);
        persistentState.put("parentTaskId", this.parentTaskId);
        persistentState.put("inProgressStartDueDate", this.inProgressStartDueDate);
        persistentState.put("dueDate", this.dueDate);
        persistentState.put("lastUpdateTime", this.lastUpdateTime);
        return persistentState;
    }

    @Override
    public void markEnded(String deleteReason, Date endTime) {
        if (this.endTime == null) {
            this.deleteReason = deleteReason;
            this.endTime = endTime != null ? endTime : this.getTaskServiceConfiguration().getClock().getCurrentTime();
            if (endTime != null && this.createTime != null) {
                this.durationInMillis = endTime.getTime() - this.createTime.getTime();
            }
        }
    }

    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getTaskDefinitionId() {
        return this.taskDefinitionId;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    @Override
    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    @Override
    public void setSubScopeId(String subScopeId) {
        this.subScopeId = subScopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    @Override
    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }

    public String getScopeDefinitionId() {
        return this.scopeDefinitionId;
    }

    @Override
    public void setScopeDefinitionId(String scopeDefinitionId) {
        this.scopeDefinitionId = scopeDefinitionId;
    }

    public String getPropagatedStageInstanceId() {
        return this.propagatedStageInstanceId;
    }

    public String getState() {
        return this.state;
    }

    public Date getStartTime() {
        return this.getCreateTime();
    }

    public Date getInProgressStartTime() {
        return this.inProgressStartTime;
    }

    public String getInProgressStartedBy() {
        return this.inProgressStartedBy;
    }

    public Date getClaimTime() {
        return this.claimTime;
    }

    public String getClaimedBy() {
        return this.claimedBy;
    }

    public Date getSuspendedTime() {
        return this.suspendedTime;
    }

    public String getSuspendedBy() {
        return this.suspendedBy;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getCompletedBy() {
        return this.completedBy;
    }

    public Long getDurationInMillis() {
        return this.durationInMillis;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public void setTaskDefinitionId(String taskDefinitionId) {
        this.taskDefinitionId = taskDefinitionId;
    }

    @Override
    public void setState(String state) {
        this.state = state;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public void setInProgressStartTime(Date inProgressStartTime) {
        this.inProgressStartTime = inProgressStartTime;
    }

    @Override
    public void setInProgressStartedBy(String inProgressStartedBy) {
        this.inProgressStartedBy = inProgressStartedBy;
    }

    @Override
    public void setClaimTime(Date claimTime) {
        this.claimTime = claimTime;
    }

    @Override
    public void setClaimedBy(String claimedBy) {
        this.claimedBy = claimedBy;
    }

    @Override
    public void setSuspendedTime(Date suspendedTime) {
        this.suspendedTime = suspendedTime;
    }

    @Override
    public void setSuspendedBy(String suspendedBy) {
        this.suspendedBy = suspendedBy;
    }

    @Override
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Override
    public void setCompletedBy(String completedBy) {
        this.completedBy = completedBy;
    }

    @Override
    public void setDurationInMillis(Long durationInMillis) {
        this.durationInMillis = durationInMillis;
    }

    public String getDeleteReason() {
        return this.deleteReason;
    }

    @Override
    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    public String getName() {
        if (this.localizedName != null && this.localizedName.length() > 0) {
            return this.localizedName;
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setLocalizedName(String name) {
        this.localizedName = name;
    }

    public String getDescription() {
        if (this.localizedDescription != null && this.localizedDescription.length() > 0) {
            return this.localizedDescription;
        }
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setLocalizedDescription(String description) {
        this.localizedDescription = description;
    }

    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    @Override
    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getFormKey() {
        return this.formKey;
    }

    @Override
    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Date getInProgressStartDueDate() {
        return this.inProgressStartDueDate;
    }

    @Override
    public void setInProgressStartDueDate(Date inProgressStartDueDate) {
        this.inProgressStartDueDate = inProgressStartDueDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    @Override
    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Date getTime() {
        return this.getCreateTime();
    }

    public Long getWorkTimeInMillis() {
        if (this.endTime == null || this.claimTime == null) {
            return null;
        }
        return this.endTime.getTime() - this.claimTime.getTime();
    }

    @Override
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public Map<String, Object> getTaskLocalVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (HistoricVariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() == null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (HistoricVariableInstanceEntity variableInstance : this.queryVariables) {
                if (this.getProcessInstanceId() == null || !this.getProcessInstanceId().equals(variableInstance.getProcessInstanceId()) || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public Map<String, Object> getCaseVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (HistoricVariableInstanceEntity variableInstance : this.queryVariables) {
                if (!TaskVariableUtils.isCaseRelated((ValueFields)variableInstance) || !variableInstance.getScopeId().equals(this.getScopeId()) || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    @Override
    public List<HistoricVariableInstanceEntity> getQueryVariables() {
        if (this.queryVariables == null && Context.getCommandContext() != null) {
            this.queryVariables = new HistoricVariableInitializingList();
        }
        return this.queryVariables;
    }

    @Override
    public void setQueryVariables(List<HistoricVariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    public List<HistoricIdentityLinkEntity> getIdentityLinks() {
        if (!this.isIdentityLinksInitialized) {
            this.identityLinks = this.queryIdentityLinks == null ? this.getIdentityLinkServiceConfiguration().getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByTaskId(this.id) : this.queryIdentityLinks;
            this.isIdentityLinksInitialized = true;
        }
        return this.identityLinks;
    }

    public List<HistoricIdentityLinkEntity> getQueryIdentityLinks() {
        if (this.queryIdentityLinks == null) {
            this.queryIdentityLinks = new LinkedList<HistoricIdentityLinkEntity>();
        }
        return this.queryIdentityLinks;
    }

    public void setQueryIdentityLinks(List<HistoricIdentityLinkEntity> identityLinks) {
        this.queryIdentityLinks = identityLinks;
    }

    protected TaskServiceConfiguration getTaskServiceConfiguration() {
        return (TaskServiceConfiguration)((Object)this.getTaskEngineConfiguration().getServiceConfigurations().get("cfg.taskService"));
    }

    protected IdentityLinkServiceConfiguration getIdentityLinkServiceConfiguration() {
        return (IdentityLinkServiceConfiguration)this.getTaskEngineConfiguration().getServiceConfigurations().get("cfg.identityLinkService");
    }

    protected AbstractEngineConfiguration getTaskEngineConfiguration() {
        Map engineConfigurations = CommandContextUtil.getCommandContext().getEngineConfigurations();
        AbstractEngineConfiguration engineConfiguration = null;
        if ("cmmn".equals(this.scopeType)) {
            engineConfiguration = (AbstractEngineConfiguration)engineConfigurations.get("cfg.cmmnEngine");
        } else {
            engineConfiguration = (AbstractEngineConfiguration)engineConfigurations.get("cfg.processEngine");
            if (engineConfiguration == null) {
                engineConfiguration = (AbstractEngineConfiguration)engineConfigurations.get("cfg.cmmnEngine");
            }
        }
        return engineConfiguration;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append("HistoricTaskInstanceEntity[");
        strb.append("id=").append(this.id);
        strb.append(", key=").append(this.taskDefinitionKey);
        if (this.executionId != null) {
            strb.append(", processInstanceId=").append(this.processInstanceId).append(", executionId=").append(this.executionId).append(", processDefinitionId=").append(this.processDefinitionId);
        } else if (this.scopeId != null) {
            strb.append(", scopeInstanceId=").append(this.scopeId).append(", subScopeId=").append(this.subScopeId).append(", scopeDefinitionId=").append(this.scopeDefinitionId);
        }
        strb.append("]");
        return strb.toString();
    }
}

