/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.CacheAwareQuery;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.impl.db.SuspensionState;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.persistence.cache.EntityCache;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.task.api.DelegationState;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.impl.TaskQueryProperty;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.util.TaskVariableUtils;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.AbstractVariableQueryImpl;
import org.flowable.variable.service.impl.QueryVariableValue;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class TaskQueryImpl
extends AbstractVariableQueryImpl<TaskQuery, Task>
implements TaskQuery,
CacheAwareQuery<TaskEntity> {
    private static final long serialVersionUID = 1L;
    protected TaskServiceConfiguration taskServiceConfiguration;
    protected IdmIdentityService idmIdentityService;
    protected String taskId;
    protected String name;
    protected String nameLike;
    protected String nameLikeIgnoreCase;
    protected Collection<String> nameList;
    protected Collection<String> nameListIgnoreCase;
    protected String description;
    protected String descriptionLike;
    protected String descriptionLikeIgnoreCase;
    protected Integer priority;
    protected Integer minPriority;
    protected Integer maxPriority;
    protected String assignee;
    protected String assigneeLike;
    protected String assigneeLikeIgnoreCase;
    protected Collection<String> assigneeIds;
    protected String involvedUser;
    protected Collection<String> involvedGroups;
    private List<List<String>> safeInvolvedGroups;
    protected String owner;
    protected String ownerLike;
    protected String ownerLikeIgnoreCase;
    protected boolean unassigned;
    protected boolean withAssignee;
    protected boolean noDelegationState;
    protected DelegationState delegationState;
    protected String candidateUser;
    protected String candidateGroup;
    protected Collection<String> candidateGroups;
    private List<List<String>> safeCandidateGroups;
    protected boolean ignoreAssigneeValue;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String processInstanceId;
    protected Collection<String> processInstanceIds;
    protected boolean withoutProcessInstanceId;
    protected String executionId;
    protected String scopeId;
    protected String subScopeId;
    protected String scopeType;
    protected String scopeDefinitionId;
    protected String propagatedStageInstanceId;
    protected String processInstanceIdWithChildren;
    protected String caseInstanceIdWithChildren;
    protected Date createTime;
    protected Date createTimeBefore;
    protected Date createTimeAfter;
    protected String category;
    protected boolean withFormKey;
    protected String formKey;
    protected String taskDefinitionId;
    protected String key;
    protected String keyLike;
    protected Collection<String> keys;
    protected String processDefinitionKey;
    protected String processDefinitionKeyLike;
    protected String processDefinitionKeyLikeIgnoreCase;
    protected Collection<String> processDefinitionKeys;
    protected String processDefinitionId;
    protected String processDefinitionName;
    protected String processDefinitionNameLike;
    protected Collection<String> processCategoryInList;
    protected Collection<String> processCategoryNotInList;
    protected String deploymentId;
    protected Collection<String> deploymentIds;
    protected String cmmnDeploymentId;
    protected Collection<String> cmmnDeploymentIds;
    protected boolean withoutScopeId;
    protected String processInstanceBusinessKey;
    protected String processInstanceBusinessKeyLike;
    protected String processInstanceBusinessKeyLikeIgnoreCase;
    protected String caseDefinitionKey;
    protected String caseDefinitionKeyLike;
    protected String caseDefinitionKeyLikeIgnoreCase;
    protected Collection<String> caseDefinitionKeys;
    protected Date dueDate;
    protected Date dueBefore;
    protected Date dueAfter;
    protected boolean withoutDueDate;
    protected SuspensionState suspensionState;
    protected boolean excludeSubtasks;
    protected boolean includeTaskLocalVariables;
    protected boolean includeProcessVariables;
    protected boolean includeCaseVariables;
    protected boolean includeIdentityLinks;
    protected String userIdForCandidateAndAssignee;
    protected boolean bothCandidateAndAssigned;
    protected String locale;
    protected boolean withLocalizationFallback;
    protected boolean orActive;
    protected List<TaskQueryImpl> orQueryObjects = new ArrayList<TaskQueryImpl>();
    protected TaskQueryImpl currentOrQueryObject;
    private Collection<String> cachedCandidateGroups;

    public TaskQueryImpl() {
    }

    public TaskQueryImpl(CommandContext commandContext, TaskServiceConfiguration taskServiceConfiguration, VariableServiceConfiguration variableServiceConfiguration, IdmIdentityService idmIdentityService) {
        super(commandContext, variableServiceConfiguration);
        this.taskServiceConfiguration = taskServiceConfiguration;
        this.idmIdentityService = idmIdentityService;
    }

    public TaskQueryImpl(CommandExecutor commandExecutor, TaskServiceConfiguration taskServiceConfiguration, VariableServiceConfiguration variableServiceConfiguration, IdmIdentityService idmIdentityService) {
        super(commandExecutor, variableServiceConfiguration);
        this.taskServiceConfiguration = taskServiceConfiguration;
        this.idmIdentityService = idmIdentityService;
    }

    public TaskQueryImpl(CommandExecutor commandExecutor, String databaseType, TaskServiceConfiguration taskServiceConfiguration, VariableServiceConfiguration variableServiceConfiguration, IdmIdentityService idmIdentityService) {
        super(commandExecutor, variableServiceConfiguration);
        this.databaseType = databaseType;
        this.taskServiceConfiguration = taskServiceConfiguration;
        this.idmIdentityService = idmIdentityService;
    }

    public TaskQueryImpl taskId(String taskId) {
        if (taskId == null) {
            throw new FlowableIllegalArgumentException("Task id is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.taskId = taskId;
        } else {
            this.taskId = taskId;
        }
        return this;
    }

    public TaskQueryImpl taskName(String name) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("Task name is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.name = name;
        } else {
            this.name = name;
        }
        return this;
    }

    public TaskQuery taskNameIn(Collection<String> nameList) {
        if (nameList == null) {
            throw new FlowableIllegalArgumentException("Task name list is null");
        }
        if (nameList.isEmpty()) {
            throw new FlowableIllegalArgumentException("Task name list is empty");
        }
        for (String name : nameList) {
            if (name != null) continue;
            throw new FlowableIllegalArgumentException("None of the given task names can be null");
        }
        if (this.name != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskNameIn and name");
        }
        if (this.nameLike != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskNameIn and nameLike");
        }
        if (this.nameLikeIgnoreCase != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskNameIn and nameLikeIgnoreCase");
        }
        if (this.orActive) {
            this.currentOrQueryObject.nameList = nameList;
        } else {
            this.nameList = nameList;
        }
        return this;
    }

    public TaskQuery taskNameInIgnoreCase(Collection<String> nameList) {
        if (nameList == null) {
            throw new FlowableIllegalArgumentException("Task name list is null");
        }
        if (nameList.isEmpty()) {
            throw new FlowableIllegalArgumentException("Task name list is empty");
        }
        for (String name : nameList) {
            if (name != null) continue;
            throw new FlowableIllegalArgumentException("None of the given task names can be null");
        }
        if (this.name != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskNameInIgnoreCase and name");
        }
        if (this.nameLike != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskNameInIgnoreCase and nameLike");
        }
        if (this.nameLikeIgnoreCase != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskNameInIgnoreCase and nameLikeIgnoreCase");
        }
        int nameListSize = nameList.size();
        ArrayList<String> caseIgnoredNameList = new ArrayList<String>(nameListSize);
        for (String name : nameList) {
            caseIgnoredNameList.add(name.toLowerCase());
        }
        if (this.orActive) {
            this.currentOrQueryObject.nameListIgnoreCase = caseIgnoredNameList;
        } else {
            this.nameListIgnoreCase = caseIgnoredNameList;
        }
        return this;
    }

    public TaskQueryImpl taskNameLike(String nameLike) {
        if (nameLike == null) {
            throw new FlowableIllegalArgumentException("Task namelike is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.nameLike = nameLike;
        } else {
            this.nameLike = nameLike;
        }
        return this;
    }

    public TaskQuery taskNameLikeIgnoreCase(String nameLikeIgnoreCase) {
        if (nameLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("Task nameLikeIgnoreCase is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.nameLikeIgnoreCase = nameLikeIgnoreCase.toLowerCase();
        } else {
            this.nameLikeIgnoreCase = nameLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    public TaskQueryImpl taskDescription(String description) {
        if (description == null) {
            throw new FlowableIllegalArgumentException("Description is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.description = description;
        } else {
            this.description = description;
        }
        return this;
    }

    public TaskQuery taskDescriptionLike(String descriptionLike) {
        if (descriptionLike == null) {
            throw new FlowableIllegalArgumentException("Task descriptionlike is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.descriptionLike = descriptionLike;
        } else {
            this.descriptionLike = descriptionLike;
        }
        return this;
    }

    public TaskQuery taskDescriptionLikeIgnoreCase(String descriptionLikeIgnoreCase) {
        if (descriptionLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("Task descriptionLikeIgnoreCase is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.descriptionLikeIgnoreCase = descriptionLikeIgnoreCase.toLowerCase();
        } else {
            this.descriptionLikeIgnoreCase = descriptionLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    public TaskQuery taskPriority(Integer priority) {
        if (priority == null) {
            throw new FlowableIllegalArgumentException("Priority is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.priority = priority;
        } else {
            this.priority = priority;
        }
        return this;
    }

    public TaskQuery taskMinPriority(Integer minPriority) {
        if (minPriority == null) {
            throw new FlowableIllegalArgumentException("Min Priority is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.minPriority = minPriority;
        } else {
            this.minPriority = minPriority;
        }
        return this;
    }

    public TaskQuery taskMaxPriority(Integer maxPriority) {
        if (maxPriority == null) {
            throw new FlowableIllegalArgumentException("Max Priority is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.maxPriority = maxPriority;
        } else {
            this.maxPriority = maxPriority;
        }
        return this;
    }

    public TaskQueryImpl taskAssignee(String assignee) {
        if (assignee == null) {
            throw new FlowableIllegalArgumentException("Assignee is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.assignee = assignee;
        } else {
            this.assignee = assignee;
        }
        return this;
    }

    public TaskQueryImpl taskAssigneeLike(String assigneeLike) {
        if (assigneeLike == null) {
            throw new FlowableIllegalArgumentException("AssigneeLike is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.assigneeLike = assigneeLike;
        } else {
            this.assigneeLike = assigneeLike;
        }
        return this;
    }

    public TaskQuery taskAssigneeLikeIgnoreCase(String assigneeLikeIgnoreCase) {
        if (assigneeLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("assigneeLikeIgnoreCase is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.assigneeLikeIgnoreCase = assigneeLikeIgnoreCase.toLowerCase();
        } else {
            this.assigneeLikeIgnoreCase = assigneeLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    public TaskQuery taskAssigneeIds(Collection<String> assigneeIds) {
        if (assigneeIds == null) {
            throw new FlowableIllegalArgumentException("Task assignee list is null");
        }
        if (assigneeIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("Task assignee list is empty");
        }
        for (String assignee : assigneeIds) {
            if (assignee != null) continue;
            throw new FlowableIllegalArgumentException("None of the given task assignees can be null");
        }
        if (this.assignee != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskAssigneeIds and taskAssignee");
        }
        if (this.assigneeLike != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskAssigneeIds and taskAssigneeLike");
        }
        if (this.assigneeLikeIgnoreCase != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both taskAssigneeIds and taskAssigneeLikeIgnoreCase");
        }
        if (this.orActive) {
            this.currentOrQueryObject.assigneeIds = assigneeIds;
        } else {
            this.assigneeIds = assigneeIds;
        }
        return this;
    }

    public TaskQueryImpl taskOwner(String owner) {
        if (owner == null) {
            throw new FlowableIllegalArgumentException("Owner is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.owner = owner;
        } else {
            this.owner = owner;
        }
        return this;
    }

    public TaskQueryImpl taskOwnerLike(String ownerLike) {
        if (ownerLike == null) {
            throw new FlowableIllegalArgumentException("Owner is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.ownerLike = ownerLike;
        } else {
            this.ownerLike = ownerLike;
        }
        return this;
    }

    public TaskQuery taskOwnerLikeIgnoreCase(String ownerLikeIgnoreCase) {
        if (ownerLikeIgnoreCase == null) {
            throw new FlowableIllegalArgumentException("OwnerLikeIgnoreCase");
        }
        if (this.orActive) {
            this.currentOrQueryObject.ownerLikeIgnoreCase = ownerLikeIgnoreCase.toLowerCase();
        } else {
            this.ownerLikeIgnoreCase = ownerLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    public TaskQuery taskUnassigned() {
        if (this.orActive) {
            this.currentOrQueryObject.unassigned = true;
        } else {
            this.unassigned = true;
        }
        return this;
    }

    public TaskQuery taskAssigned() {
        if (this.orActive) {
            this.currentOrQueryObject.withAssignee = true;
        } else {
            this.withAssignee = true;
        }
        return this;
    }

    public TaskQuery taskDelegationState(DelegationState delegationState) {
        if (this.orActive) {
            if (delegationState == null) {
                this.currentOrQueryObject.noDelegationState = true;
            } else {
                this.currentOrQueryObject.delegationState = delegationState;
            }
        } else if (delegationState == null) {
            this.noDelegationState = true;
        } else {
            this.delegationState = delegationState;
        }
        return this;
    }

    public TaskQueryImpl taskCandidateUser(String candidateUser) {
        if (candidateUser == null) {
            throw new FlowableIllegalArgumentException("Candidate user is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.candidateUser = candidateUser;
        } else {
            this.candidateUser = candidateUser;
        }
        return this;
    }

    public TaskQueryImpl taskInvolvedUser(String involvedUser) {
        if (involvedUser == null) {
            throw new FlowableIllegalArgumentException("Involved user is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.involvedUser = involvedUser;
        } else {
            this.involvedUser = involvedUser;
        }
        return this;
    }

    public TaskQueryImpl taskInvolvedGroups(Collection<String> involvedGroups) {
        if (involvedGroups == null) {
            throw new FlowableIllegalArgumentException("Involved groups are null");
        }
        if (involvedGroups.isEmpty()) {
            throw new FlowableIllegalArgumentException("Involved groups are empty");
        }
        if (this.orActive) {
            this.currentOrQueryObject.involvedGroups = involvedGroups;
        } else {
            this.involvedGroups = involvedGroups;
        }
        return this;
    }

    public TaskQueryImpl taskCandidateGroup(String candidateGroup) {
        if (candidateGroup == null) {
            throw new FlowableIllegalArgumentException("Candidate group is null");
        }
        if (this.candidateGroups != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both candidateGroup and candidateGroupIn");
        }
        if (this.orActive) {
            this.currentOrQueryObject.candidateGroup = candidateGroup;
        } else {
            this.candidateGroup = candidateGroup;
        }
        return this;
    }

    public TaskQuery taskCandidateOrAssigned(String userIdForCandidateAndAssignee) {
        if (this.candidateGroup != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set candidateGroup");
        }
        if (this.candidateUser != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both candidateGroup and candidateUser");
        }
        if (this.orActive) {
            this.currentOrQueryObject.bothCandidateAndAssigned = true;
            this.currentOrQueryObject.userIdForCandidateAndAssignee = userIdForCandidateAndAssignee;
        } else {
            this.bothCandidateAndAssigned = true;
            this.userIdForCandidateAndAssignee = userIdForCandidateAndAssignee;
        }
        return this;
    }

    public TaskQuery taskCandidateGroupIn(Collection<String> candidateGroups) {
        if (candidateGroups == null) {
            throw new FlowableIllegalArgumentException("Candidate group list is null");
        }
        if (candidateGroups.isEmpty()) {
            throw new FlowableIllegalArgumentException("Candidate group list is empty");
        }
        if (this.candidateGroup != null) {
            throw new FlowableIllegalArgumentException("Invalid query usage: cannot set both candidateGroupIn and candidateGroup");
        }
        if (this.orActive) {
            this.currentOrQueryObject.candidateGroups = candidateGroups;
        } else {
            this.candidateGroups = candidateGroups;
        }
        return this;
    }

    public TaskQuery ignoreAssigneeValue() {
        if (this.orActive) {
            this.currentOrQueryObject.ignoreAssigneeValue = true;
        } else {
            this.ignoreAssigneeValue = true;
        }
        return this;
    }

    public TaskQuery taskTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("task tenant id is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.tenantId = tenantId;
        } else {
            this.tenantId = tenantId;
        }
        return this;
    }

    public TaskQuery taskTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("task tenant id is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.tenantIdLike = tenantIdLike;
        } else {
            this.tenantIdLike = tenantIdLike;
        }
        return this;
    }

    public TaskQuery taskWithoutTenantId() {
        if (this.orActive) {
            this.currentOrQueryObject.withoutTenantId = true;
        } else {
            this.withoutTenantId = true;
        }
        return this;
    }

    public TaskQueryImpl processInstanceId(String processInstanceId) {
        if (this.orActive) {
            this.currentOrQueryObject.processInstanceId = processInstanceId;
        } else {
            this.processInstanceId = processInstanceId;
        }
        return this;
    }

    public TaskQuery processInstanceIdIn(Collection<String> processInstanceIds) {
        if (processInstanceIds == null) {
            throw new FlowableIllegalArgumentException("Process instance id list is null");
        }
        if (processInstanceIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("Process instance id list is empty");
        }
        for (String processInstanceId : processInstanceIds) {
            if (processInstanceId != null) continue;
            throw new FlowableIllegalArgumentException("None of the given process instance ids can be null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.processInstanceIds = processInstanceIds;
        } else {
            this.processInstanceIds = processInstanceIds;
        }
        return this;
    }

    public TaskQueryImpl withoutProcessInstanceId() {
        if (this.orActive) {
            this.currentOrQueryObject.withoutProcessInstanceId = true;
        } else {
            this.withoutProcessInstanceId = true;
        }
        return this;
    }

    public TaskQueryImpl processInstanceBusinessKey(String processInstanceBusinessKey) {
        if (this.orActive) {
            this.currentOrQueryObject.processInstanceBusinessKey = processInstanceBusinessKey;
        } else {
            this.processInstanceBusinessKey = processInstanceBusinessKey;
        }
        return this;
    }

    public TaskQueryImpl processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        if (this.orActive) {
            this.currentOrQueryObject.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
        } else {
            this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
        }
        return this;
    }

    public TaskQuery processInstanceBusinessKeyLikeIgnoreCase(String processInstanceBusinessKeyLikeIgnoreCase) {
        if (this.orActive) {
            this.currentOrQueryObject.processInstanceBusinessKeyLikeIgnoreCase = processInstanceBusinessKeyLikeIgnoreCase.toLowerCase();
        } else {
            this.processInstanceBusinessKeyLikeIgnoreCase = processInstanceBusinessKeyLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    public TaskQueryImpl executionId(String executionId) {
        if (this.orActive) {
            this.currentOrQueryObject.executionId = executionId;
        } else {
            this.executionId = executionId;
        }
        return this;
    }

    public TaskQuery caseInstanceId(String caseInstanceId) {
        if (this.orActive) {
            this.currentOrQueryObject.scopeId(caseInstanceId);
            this.currentOrQueryObject.scopeType("cmmn");
        } else {
            this.scopeId(caseInstanceId);
            this.scopeType("cmmn");
        }
        return this;
    }

    public TaskQuery caseDefinitionId(String caseDefinitionId) {
        if (this.orActive) {
            this.currentOrQueryObject.scopeDefinitionId(caseDefinitionId);
            this.currentOrQueryObject.scopeType("cmmn");
        } else {
            this.scopeDefinitionId(caseDefinitionId);
            this.scopeType("cmmn");
        }
        return this;
    }

    public TaskQuery caseDefinitionKey(String caseDefinitionKey) {
        if (this.orActive) {
            this.currentOrQueryObject.caseDefinitionKey = caseDefinitionKey;
        } else {
            this.caseDefinitionKey = caseDefinitionKey;
        }
        return this;
    }

    public TaskQuery caseDefinitionKeyLike(String caseDefinitionKeyLike) {
        if (this.orActive) {
            this.currentOrQueryObject.caseDefinitionKeyLike = caseDefinitionKeyLike;
        } else {
            this.caseDefinitionKeyLike = caseDefinitionKeyLike;
        }
        return this;
    }

    public TaskQuery caseDefinitionKeyLikeIgnoreCase(String caseDefinitionKeyLikeIgnoreCase) {
        if (this.orActive) {
            this.currentOrQueryObject.caseDefinitionKeyLikeIgnoreCase = caseDefinitionKeyLikeIgnoreCase;
        } else {
            this.caseDefinitionKeyLikeIgnoreCase = caseDefinitionKeyLikeIgnoreCase;
        }
        return this;
    }

    public TaskQuery caseDefinitionKeyIn(Collection<String> caseDefinitionKeys) {
        if (this.orActive) {
            this.currentOrQueryObject.caseDefinitionKeys = caseDefinitionKeys;
        } else {
            this.caseDefinitionKeys = caseDefinitionKeys;
        }
        return this;
    }

    public TaskQuery processInstanceIdWithChildren(String processInstanceId) {
        if (this.orActive) {
            this.currentOrQueryObject.processInstanceIdWithChildren(processInstanceId);
        } else {
            this.processInstanceIdWithChildren = processInstanceId;
        }
        return this;
    }

    public TaskQuery caseInstanceIdWithChildren(String caseInstanceId) {
        if (this.orActive) {
            this.currentOrQueryObject.caseInstanceIdWithChildren(caseInstanceId);
        } else {
            this.caseInstanceIdWithChildren = caseInstanceId;
        }
        return this;
    }

    public TaskQuery planItemInstanceId(String planItemInstanceId) {
        if (this.orActive) {
            this.currentOrQueryObject.subScopeId(planItemInstanceId);
            this.currentOrQueryObject.scopeType("cmmn");
        } else {
            this.subScopeId(planItemInstanceId);
            this.scopeType("cmmn");
        }
        return this;
    }

    public TaskQueryImpl scopeId(String scopeId) {
        if (this.orActive) {
            this.currentOrQueryObject.scopeId = scopeId;
        } else {
            this.scopeId = scopeId;
        }
        return this;
    }

    public TaskQueryImpl subScopeId(String subScopeId) {
        if (this.orActive) {
            this.currentOrQueryObject.subScopeId = subScopeId;
        } else {
            this.subScopeId = subScopeId;
        }
        return this;
    }

    public TaskQueryImpl scopeType(String scopeType) {
        if (this.orActive) {
            this.currentOrQueryObject.scopeType = scopeType;
        } else {
            this.scopeType = scopeType;
        }
        return this;
    }

    public TaskQueryImpl scopeDefinitionId(String scopeDefinitionId) {
        if (this.orActive) {
            this.currentOrQueryObject.scopeDefinitionId = scopeDefinitionId;
        } else {
            this.scopeDefinitionId = scopeDefinitionId;
        }
        return this;
    }

    public TaskQuery propagatedStageInstanceId(String propagatedStageInstanceId) {
        if (this.orActive) {
            this.currentOrQueryObject.propagatedStageInstanceId = propagatedStageInstanceId;
        } else {
            this.propagatedStageInstanceId = propagatedStageInstanceId;
        }
        return this;
    }

    public TaskQueryImpl taskCreatedOn(Date createTime) {
        if (this.orActive) {
            this.currentOrQueryObject.createTime = createTime;
        } else {
            this.createTime = createTime;
        }
        return this;
    }

    public TaskQuery taskCreatedBefore(Date before) {
        if (this.orActive) {
            this.currentOrQueryObject.createTimeBefore = before;
        } else {
            this.createTimeBefore = before;
        }
        return this;
    }

    public TaskQuery taskCreatedAfter(Date after) {
        if (this.orActive) {
            this.currentOrQueryObject.createTimeAfter = after;
        } else {
            this.createTimeAfter = after;
        }
        return this;
    }

    public TaskQuery taskCategory(String category) {
        if (this.orActive) {
            this.currentOrQueryObject.category = category;
        } else {
            this.category = category;
        }
        return this;
    }

    public TaskQuery taskWithFormKey() {
        if (this.orActive) {
            this.currentOrQueryObject.withFormKey = true;
        } else {
            this.withFormKey = true;
        }
        return this;
    }

    public TaskQuery taskFormKey(String formKey) {
        if (formKey == null) {
            throw new FlowableIllegalArgumentException("Task formKey is null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.formKey = formKey;
        } else {
            this.formKey = formKey;
        }
        return this;
    }

    public TaskQuery taskDefinitionId(String taskDefinitionId) {
        if (this.orActive) {
            this.currentOrQueryObject.taskDefinitionId = taskDefinitionId;
        } else {
            this.taskDefinitionId = taskDefinitionId;
        }
        return this;
    }

    public TaskQuery taskDefinitionKey(String key) {
        if (this.orActive) {
            this.currentOrQueryObject.key = key;
        } else {
            this.key = key;
        }
        return this;
    }

    public TaskQuery taskDefinitionKeyLike(String keyLike) {
        if (this.orActive) {
            this.currentOrQueryObject.keyLike = keyLike;
        } else {
            this.keyLike = keyLike;
        }
        return this;
    }

    public TaskQuery taskDefinitionKeys(Collection<String> keys) {
        if (this.orActive) {
            this.currentOrQueryObject.keys = keys;
        } else {
            this.keys = keys;
        }
        return this;
    }

    public TaskQuery taskVariableValueEquals(String variableName, Object variableValue) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueEquals(variableName, variableValue);
        } else {
            this.variableValueEquals(variableName, variableValue);
        }
        return this;
    }

    public TaskQuery taskVariableValueEquals(Object variableValue) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueEquals(variableValue);
        } else {
            this.variableValueEquals(variableValue);
        }
        return this;
    }

    public TaskQuery taskVariableValueEqualsIgnoreCase(String name, String value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueEqualsIgnoreCase(name, value);
        } else {
            this.variableValueEqualsIgnoreCase(name, value);
        }
        return this;
    }

    public TaskQuery taskVariableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueNotEqualsIgnoreCase(name, value);
        } else {
            this.variableValueNotEqualsIgnoreCase(name, value);
        }
        return this;
    }

    public TaskQuery taskVariableValueNotEquals(String variableName, Object variableValue) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueNotEquals(variableName, variableValue);
        } else {
            this.variableValueNotEquals(variableName, variableValue);
        }
        return this;
    }

    public TaskQuery taskVariableValueGreaterThan(String name, Object value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueGreaterThan(name, value);
        } else {
            this.variableValueGreaterThan(name, value);
        }
        return this;
    }

    public TaskQuery taskVariableValueGreaterThanOrEqual(String name, Object value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueGreaterThanOrEqual(name, value);
        } else {
            this.variableValueGreaterThanOrEqual(name, value);
        }
        return this;
    }

    public TaskQuery taskVariableValueLessThan(String name, Object value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueLessThan(name, value);
        } else {
            this.variableValueLessThan(name, value);
        }
        return this;
    }

    public TaskQuery taskVariableValueLessThanOrEqual(String name, Object value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueLessThanOrEqual(name, value);
        } else {
            this.variableValueLessThanOrEqual(name, value);
        }
        return this;
    }

    public TaskQuery taskVariableValueLike(String name, String value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueLike(name, value);
        } else {
            this.variableValueLike(name, value);
        }
        return this;
    }

    public TaskQuery taskVariableValueLikeIgnoreCase(String name, String value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueLikeIgnoreCase(name, value);
        } else {
            this.variableValueLikeIgnoreCase(name, value);
        }
        return this;
    }

    public TaskQuery taskVariableExists(String name) {
        if (this.orActive) {
            this.currentOrQueryObject.variableExists(name);
        } else {
            this.variableExists(name);
        }
        return this;
    }

    public TaskQuery taskVariableNotExists(String name) {
        if (this.orActive) {
            this.currentOrQueryObject.variableNotExists(name);
        } else {
            this.variableNotExists(name);
        }
        return this;
    }

    public TaskQuery processVariableValueEquals(String variableName, Object variableValue) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueEquals(variableName, variableValue, false);
        } else {
            this.variableValueEquals(variableName, variableValue, false);
        }
        return this;
    }

    public TaskQuery processVariableValueNotEquals(String variableName, Object variableValue) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueNotEquals(variableName, variableValue, false);
        } else {
            this.variableValueNotEquals(variableName, variableValue, false);
        }
        return this;
    }

    public TaskQuery processVariableValueEquals(Object variableValue) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueEquals(variableValue, false);
        } else {
            this.variableValueEquals(variableValue, false);
        }
        return this;
    }

    public TaskQuery processVariableValueEqualsIgnoreCase(String name, String value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueEqualsIgnoreCase(name, value, false);
        } else {
            this.variableValueEqualsIgnoreCase(name, value, false);
        }
        return this;
    }

    public TaskQuery processVariableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueNotEqualsIgnoreCase(name, value, false);
        } else {
            this.variableValueNotEqualsIgnoreCase(name, value, false);
        }
        return this;
    }

    public TaskQuery processVariableValueGreaterThan(String name, Object value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueGreaterThan(name, value, false);
        } else {
            this.variableValueGreaterThan(name, value, false);
        }
        return this;
    }

    public TaskQuery processVariableValueGreaterThanOrEqual(String name, Object value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueGreaterThanOrEqual(name, value, false);
        } else {
            this.variableValueGreaterThanOrEqual(name, value, false);
        }
        return this;
    }

    public TaskQuery processVariableValueLessThan(String name, Object value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueLessThan(name, value, false);
        } else {
            this.variableValueLessThan(name, value, false);
        }
        return this;
    }

    public TaskQuery processVariableValueLessThanOrEqual(String name, Object value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueLessThanOrEqual(name, value, false);
        } else {
            this.variableValueLessThanOrEqual(name, value, false);
        }
        return this;
    }

    public TaskQuery processVariableValueLike(String name, String value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueLike(name, value, false);
        } else {
            this.variableValueLike(name, value, false);
        }
        return this;
    }

    public TaskQuery processVariableValueLikeIgnoreCase(String name, String value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueLikeIgnoreCase(name, value, false);
        } else {
            this.variableValueLikeIgnoreCase(name, value, false);
        }
        return this;
    }

    public TaskQuery processVariableExists(String name) {
        if (this.orActive) {
            this.currentOrQueryObject.variableExists(name, false);
        } else {
            this.variableExists(name, false);
        }
        return this;
    }

    public TaskQuery processVariableNotExists(String name) {
        if (this.orActive) {
            this.currentOrQueryObject.variableNotExists(name, false);
        } else {
            this.variableNotExists(name, false);
        }
        return this;
    }

    public TaskQuery caseVariableValueEquals(String variableName, Object variableValue) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueEquals(variableName, variableValue, "cmmn");
        } else {
            this.variableValueEquals(variableName, variableValue, "cmmn");
        }
        return this;
    }

    public TaskQuery caseVariableValueEquals(Object variableValue) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueEquals(variableValue, "cmmn");
        } else {
            this.variableValueEquals(variableValue, "cmmn");
        }
        return this;
    }

    public TaskQuery caseVariableValueEqualsIgnoreCase(String name, String value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueEqualsIgnoreCase(name, value, "cmmn");
        } else {
            this.variableValueEqualsIgnoreCase(name, value, "cmmn");
        }
        return this;
    }

    public TaskQuery caseVariableValueNotEquals(String variableName, Object variableValue) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueNotEquals(variableName, variableValue, "cmmn");
        } else {
            this.variableValueNotEquals(variableName, variableValue, "cmmn");
        }
        return this;
    }

    public TaskQuery caseVariableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueNotEqualsIgnoreCase(name, "cmmn");
        } else {
            this.variableValueNotEqualsIgnoreCase(name, value, "cmmn");
        }
        return this;
    }

    public TaskQuery caseVariableValueGreaterThan(String name, Object value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueGreaterThan(name, value, "cmmn");
        } else {
            this.variableValueGreaterThan(name, value, "cmmn");
        }
        return this;
    }

    public TaskQuery caseVariableValueGreaterThanOrEqual(String name, Object value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueGreaterThanOrEqual(name, value, "cmmn");
        } else {
            this.variableValueGreaterThanOrEqual(name, value, "cmmn");
        }
        return this;
    }

    public TaskQuery caseVariableValueLessThan(String name, Object value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueLessThan(name, value, "cmmn");
        } else {
            this.variableValueLessThan(name, value, "cmmn");
        }
        return this;
    }

    public TaskQuery caseVariableValueLessThanOrEqual(String name, Object value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueLessThanOrEqual(name, value, "cmmn");
        } else {
            this.variableValueLessThanOrEqual(name, value, "cmmn");
        }
        return this;
    }

    public TaskQuery caseVariableValueLike(String name, String value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueLike(name, value, "cmmn");
        } else {
            this.variableValueLike(name, value, "cmmn");
        }
        return this;
    }

    public TaskQuery caseVariableValueLikeIgnoreCase(String name, String value) {
        if (this.orActive) {
            this.currentOrQueryObject.variableValueLikeIgnoreCase(name, value, "cmmn");
        } else {
            this.variableValueLikeIgnoreCase(name, value, "cmmn");
        }
        return this;
    }

    public TaskQuery caseVariableExists(String name) {
        if (this.orActive) {
            this.currentOrQueryObject.variableExists(name, "cmmn");
        } else {
            this.variableExists(name, "cmmn");
        }
        return this;
    }

    public TaskQuery caseVariableNotExists(String name) {
        if (this.orActive) {
            this.currentOrQueryObject.variableNotExists(name, "cmmn");
        } else {
            this.variableNotExists(name, "cmmn");
        }
        return this;
    }

    public TaskQuery processDefinitionKey(String processDefinitionKey) {
        if (this.orActive) {
            this.currentOrQueryObject.processDefinitionKey = processDefinitionKey;
        } else {
            this.processDefinitionKey = processDefinitionKey;
        }
        return this;
    }

    public TaskQuery processDefinitionKeyLike(String processDefinitionKeyLike) {
        if (this.orActive) {
            this.currentOrQueryObject.processDefinitionKeyLike = processDefinitionKeyLike;
        } else {
            this.processDefinitionKeyLike = processDefinitionKeyLike;
        }
        return this;
    }

    public TaskQuery processDefinitionKeyLikeIgnoreCase(String processDefinitionKeyLikeIgnoreCase) {
        if (this.orActive) {
            this.currentOrQueryObject.processDefinitionKeyLikeIgnoreCase = processDefinitionKeyLikeIgnoreCase.toLowerCase();
        } else {
            this.processDefinitionKeyLikeIgnoreCase = processDefinitionKeyLikeIgnoreCase.toLowerCase();
        }
        return this;
    }

    public TaskQuery processDefinitionKeyIn(Collection<String> processDefinitionKeys) {
        if (this.orActive) {
            this.currentOrQueryObject.processDefinitionKeys = processDefinitionKeys;
        } else {
            this.processDefinitionKeys = processDefinitionKeys;
        }
        return this;
    }

    public TaskQuery processDefinitionId(String processDefinitionId) {
        if (this.orActive) {
            this.currentOrQueryObject.processDefinitionId = processDefinitionId;
        } else {
            this.processDefinitionId = processDefinitionId;
        }
        return this;
    }

    public TaskQuery processDefinitionName(String processDefinitionName) {
        if (this.orActive) {
            this.currentOrQueryObject.processDefinitionName = processDefinitionName;
        } else {
            this.processDefinitionName = processDefinitionName;
        }
        return this;
    }

    public TaskQuery processDefinitionNameLike(String processDefinitionNameLike) {
        if (this.orActive) {
            this.currentOrQueryObject.processDefinitionNameLike = processDefinitionNameLike;
        } else {
            this.processDefinitionNameLike = processDefinitionNameLike;
        }
        return this;
    }

    public TaskQuery processCategoryIn(Collection<String> processCategoryInList) {
        if (processCategoryInList == null) {
            throw new FlowableIllegalArgumentException("Process category list is null");
        }
        if (processCategoryInList.isEmpty()) {
            throw new FlowableIllegalArgumentException("Process category list is empty");
        }
        for (String processCategory : processCategoryInList) {
            if (processCategory != null) continue;
            throw new FlowableIllegalArgumentException("None of the given process categories can be null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.processCategoryInList = processCategoryInList;
        } else {
            this.processCategoryInList = processCategoryInList;
        }
        return this;
    }

    public TaskQuery processCategoryNotIn(Collection<String> processCategoryNotInList) {
        if (processCategoryNotInList == null) {
            throw new FlowableIllegalArgumentException("Process category list is null");
        }
        if (processCategoryNotInList.isEmpty()) {
            throw new FlowableIllegalArgumentException("Process category list is empty");
        }
        for (String processCategory : processCategoryNotInList) {
            if (processCategory != null) continue;
            throw new FlowableIllegalArgumentException("None of the given process categories can be null");
        }
        if (this.orActive) {
            this.currentOrQueryObject.processCategoryNotInList = processCategoryNotInList;
        } else {
            this.processCategoryNotInList = processCategoryNotInList;
        }
        return this;
    }

    public TaskQuery deploymentId(String deploymentId) {
        if (this.orActive) {
            this.currentOrQueryObject.deploymentId = deploymentId;
        } else {
            this.deploymentId = deploymentId;
        }
        return this;
    }

    public TaskQuery deploymentIdIn(Collection<String> deploymentIds) {
        if (this.orActive) {
            this.currentOrQueryObject.deploymentIds = deploymentIds;
        } else {
            this.deploymentIds = deploymentIds;
        }
        return this;
    }

    public TaskQuery cmmnDeploymentId(String cmmnDeploymentId) {
        if (this.orActive) {
            this.currentOrQueryObject.cmmnDeploymentId = cmmnDeploymentId;
        } else {
            this.cmmnDeploymentId = cmmnDeploymentId;
        }
        return this;
    }

    public TaskQuery cmmnDeploymentIdIn(Collection<String> cmmnDeploymentIds) {
        if (this.orActive) {
            this.currentOrQueryObject.cmmnDeploymentIds = cmmnDeploymentIds;
        } else {
            this.cmmnDeploymentIds = cmmnDeploymentIds;
        }
        return this;
    }

    public TaskQuery withoutScopeId() {
        if (this.orActive) {
            this.currentOrQueryObject.withoutScopeId = true;
        } else {
            this.withoutScopeId = true;
        }
        return this;
    }

    public TaskQuery dueDate(Date dueDate) {
        if (this.orActive) {
            this.currentOrQueryObject.dueDate = dueDate;
            this.currentOrQueryObject.withoutDueDate = false;
        } else {
            this.dueDate = dueDate;
            this.withoutDueDate = false;
        }
        return this;
    }

    public TaskQuery taskDueDate(Date dueDate) {
        return this.dueDate(dueDate);
    }

    public TaskQuery dueBefore(Date dueBefore) {
        if (this.orActive) {
            this.currentOrQueryObject.dueBefore = dueBefore;
            this.currentOrQueryObject.withoutDueDate = false;
        } else {
            this.dueBefore = dueBefore;
            this.withoutDueDate = false;
        }
        return this;
    }

    public TaskQuery taskDueBefore(Date dueDate) {
        return this.dueBefore(dueDate);
    }

    public TaskQuery dueAfter(Date dueAfter) {
        if (this.orActive) {
            this.currentOrQueryObject.dueAfter = dueAfter;
            this.currentOrQueryObject.withoutDueDate = false;
        } else {
            this.dueAfter = dueAfter;
            this.withoutDueDate = false;
        }
        return this;
    }

    public TaskQuery taskDueAfter(Date dueDate) {
        return this.dueAfter(dueDate);
    }

    public TaskQuery withoutDueDate() {
        if (this.orActive) {
            this.currentOrQueryObject.withoutDueDate = true;
        } else {
            this.withoutDueDate = true;
        }
        return this;
    }

    public TaskQuery withoutTaskDueDate() {
        return this.withoutDueDate();
    }

    public TaskQuery excludeSubtasks() {
        if (this.orActive) {
            this.currentOrQueryObject.excludeSubtasks = true;
        } else {
            this.excludeSubtasks = true;
        }
        return this;
    }

    public TaskQuery suspended() {
        if (this.orActive) {
            this.currentOrQueryObject.suspensionState = SuspensionState.SUSPENDED;
        } else {
            this.suspensionState = SuspensionState.SUSPENDED;
        }
        return this;
    }

    public TaskQuery active() {
        if (this.orActive) {
            this.currentOrQueryObject.suspensionState = SuspensionState.ACTIVE;
        } else {
            this.suspensionState = SuspensionState.ACTIVE;
        }
        return this;
    }

    public TaskQuery locale(String locale) {
        this.locale = locale;
        return this;
    }

    public TaskQuery withLocalizationFallback() {
        this.withLocalizationFallback = true;
        return this;
    }

    public TaskQuery includeTaskLocalVariables() {
        this.includeTaskLocalVariables = true;
        return this;
    }

    public TaskQuery includeProcessVariables() {
        this.includeProcessVariables = true;
        return this;
    }

    public TaskQuery includeCaseVariables() {
        this.includeCaseVariables = true;
        return this;
    }

    public TaskQuery limitTaskVariables(Integer taskVariablesLimit) {
        return this;
    }

    public TaskQuery includeIdentityLinks() {
        this.includeIdentityLinks = true;
        return this;
    }

    public Collection<String> getCandidateGroups() {
        if (this.candidateGroup != null) {
            ArrayList<String> candidateGroupList = new ArrayList<String>(1);
            candidateGroupList.add(this.candidateGroup);
            return candidateGroupList;
        }
        if (this.candidateGroups != null) {
            return this.candidateGroups;
        }
        if (this.candidateUser != null) {
            if (this.cachedCandidateGroups == null) {
                this.cachedCandidateGroups = this.getGroupsForCandidateUser(this.candidateUser);
            }
            return this.cachedCandidateGroups;
        }
        if (this.userIdForCandidateAndAssignee != null) {
            if (this.cachedCandidateGroups == null) {
                this.cachedCandidateGroups = this.getGroupsForCandidateUser(this.userIdForCandidateAndAssignee);
            }
            return this.cachedCandidateGroups;
        }
        return null;
    }

    protected Collection<String> getGroupsForCandidateUser(String candidateUser) {
        ArrayList<String> groupIds = new ArrayList<String>();
        if (this.idmIdentityService != null) {
            List groups = this.idmIdentityService.createGroupQuery().groupMember(candidateUser).list();
            for (Group group : groups) {
                groupIds.add(group.getId());
            }
        }
        return groupIds;
    }

    protected void ensureVariablesInitialized() {
        for (QueryVariableValue var : this.queryVariableValues) {
            var.initialize(this.variableServiceConfiguration);
        }
        for (TaskQueryImpl orQueryObject : this.orQueryObjects) {
            orQueryObject.ensureVariablesInitialized();
        }
    }

    public TaskQuery or() {
        if (this.orActive) {
            throw new FlowableException("the query is already in an or statement");
        }
        this.orActive = true;
        this.currentOrQueryObject = this.commandContext != null ? new TaskQueryImpl(this.commandContext, this.taskServiceConfiguration, this.variableServiceConfiguration, this.idmIdentityService) : new TaskQueryImpl(this.commandExecutor, this.taskServiceConfiguration, this.variableServiceConfiguration, this.idmIdentityService);
        this.orQueryObjects.add(this.currentOrQueryObject);
        return this;
    }

    public TaskQuery endOr() {
        if (!this.orActive) {
            throw new FlowableException("endOr() can only be called after calling or()");
        }
        this.orActive = false;
        this.currentOrQueryObject = null;
        return this;
    }

    public TaskQuery orderByTaskId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.TASK_ID);
    }

    public TaskQuery orderByTaskName() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.NAME);
    }

    public TaskQuery orderByTaskDescription() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DESCRIPTION);
    }

    public TaskQuery orderByTaskPriority() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.PRIORITY);
    }

    public TaskQuery orderByProcessInstanceId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.PROCESS_INSTANCE_ID);
    }

    public TaskQuery orderByExecutionId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.EXECUTION_ID);
    }

    public TaskQuery orderByProcessDefinitionId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.PROCESS_DEFINITION_ID);
    }

    public TaskQuery orderByTaskAssignee() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.ASSIGNEE);
    }

    public TaskQuery orderByTaskOwner() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.OWNER);
    }

    public TaskQuery orderByTaskCreateTime() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.CREATE_TIME);
    }

    public TaskQuery orderByDueDate() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DUE_DATE);
    }

    public TaskQuery orderByTaskDueDate() {
        return this.orderByDueDate();
    }

    public TaskQuery orderByTaskDefinitionKey() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.TASK_DEFINITION_KEY);
    }

    public TaskQuery orderByDueDateNullsFirst() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DUE_DATE, Query.NullHandlingOnOrder.NULLS_FIRST);
    }

    public TaskQuery orderByDueDateNullsLast() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DUE_DATE, Query.NullHandlingOnOrder.NULLS_LAST);
    }

    public TaskQuery orderByCategory() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.CATEGORY);
    }

    public TaskQuery orderByTenantId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.TENANT_ID);
    }

    public List<Task> executeList(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        List<Task> tasks = null;
        if (this.taskServiceConfiguration.getTaskQueryInterceptor() != null) {
            this.taskServiceConfiguration.getTaskQueryInterceptor().beforeTaskQueryExecute((TaskQuery)this);
        }
        if (this.includeTaskLocalVariables || this.includeProcessVariables || this.includeIdentityLinks || this.includeCaseVariables) {
            tasks = this.taskServiceConfiguration.getTaskEntityManager().findTasksWithRelatedEntitiesByQueryCriteria(this);
            if (this.taskId != null) {
                if (this.includeProcessVariables || this.includeCaseVariables) {
                    this.addCachedVariableForQueryById(commandContext, tasks, false);
                } else if (this.includeTaskLocalVariables) {
                    this.addCachedVariableForQueryById(commandContext, tasks, true);
                }
            }
        } else {
            tasks = this.taskServiceConfiguration.getTaskEntityManager().findTasksByQueryCriteria(this);
        }
        if (tasks != null && this.taskServiceConfiguration.getInternalTaskLocalizationManager() != null && this.taskServiceConfiguration.isEnableLocalization()) {
            for (Task task : tasks) {
                this.taskServiceConfiguration.getInternalTaskLocalizationManager().localize(task, this.locale, this.withLocalizationFallback);
            }
        }
        if (this.taskServiceConfiguration.getTaskQueryInterceptor() != null) {
            this.taskServiceConfiguration.getTaskQueryInterceptor().afterTaskQueryExecute((TaskQuery)this, tasks);
        }
        return tasks;
    }

    protected void addCachedVariableForQueryById(CommandContext commandContext, List<Task> results, boolean local) {
        for (Task task : results) {
            if (!Objects.equals(this.taskId, task.getId())) continue;
            EntityCache entityCache = (EntityCache)commandContext.getSession(EntityCache.class);
            List cachedVariableEntities = entityCache.findInCache(VariableInstanceEntity.class);
            for (VariableInstanceEntity cachedVariableEntity : cachedVariableEntities) {
                if (local) {
                    if (!task.getId().equals(cachedVariableEntity.getTaskId())) continue;
                    ((TaskEntity)task).getQueryVariables().add(cachedVariableEntity);
                    continue;
                }
                if (!TaskVariableUtils.doesVariableBelongToTask((ValueFields)cachedVariableEntity, (TaskInfo)task)) continue;
                ((TaskEntity)task).getQueryVariables().add(cachedVariableEntity);
            }
        }
    }

    public void enhanceCachedValue(TaskEntity task) {
        if (this.includeProcessVariables && task.getProcessInstanceId() != null) {
            task.getQueryVariables().addAll(this.variableServiceConfiguration.getVariableService().findVariableInstancesByExecutionId(task.getProcessInstanceId()));
        } else if (this.includeCaseVariables && TaskVariableUtils.isCaseRelated((TaskInfo)task)) {
            task.getQueryVariables().addAll(this.variableServiceConfiguration.getVariableService().findVariableInstanceByScopeIdAndScopeType(task.getScopeId(), task.getScopeType()));
        } else if (this.includeTaskLocalVariables) {
            task.getQueryVariables().addAll(task.getVariableInstanceEntities().values());
        }
    }

    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        if (this.taskServiceConfiguration.getTaskQueryInterceptor() != null) {
            this.taskServiceConfiguration.getTaskQueryInterceptor().beforeTaskQueryExecute((TaskQuery)this);
        }
        return this.taskServiceConfiguration.getTaskEntityManager().findTaskCountByQueryCriteria(this);
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public Collection<String> getNameList() {
        return this.nameList;
    }

    public Collection<String> getNameListIgnoreCase() {
        return this.nameListIgnoreCase;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public boolean getUnassigned() {
        return this.unassigned;
    }

    public boolean isWithAssignee() {
        return this.withAssignee;
    }

    public DelegationState getDelegationState() {
        return this.delegationState;
    }

    public boolean getNoDelegationState() {
        return this.noDelegationState;
    }

    public String getDelegationStateString() {
        return this.delegationState != null ? this.delegationState.toString() : null;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public boolean isIgnoreAssigneeValue() {
        return this.ignoreAssigneeValue;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public Collection<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public boolean isWithoutProcessInstanceId() {
        return this.withoutProcessInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public boolean isWithoutScopeId() {
        return this.withoutScopeId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public String getScopeDefinitionId() {
        return this.scopeDefinitionId;
    }

    public String getPropagatedStageInstanceId() {
        return this.propagatedStageInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getId() {
        return this.taskId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionLike() {
        return this.descriptionLike;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getCreateTimeBefore() {
        return this.createTimeBefore;
    }

    public Date getCreateTimeAfter() {
        return this.createTimeAfter;
    }

    public String getTaskDefinitionId() {
        return this.taskDefinitionId;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public Collection<String> getKeys() {
        return this.keys;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public String getProcessInstanceBusinessKey() {
        return this.processInstanceBusinessKey;
    }

    public String getProcessInstanceIdWithChildren() {
        return this.processInstanceIdWithChildren;
    }

    public String getCaseInstanceIdWithChildren() {
        return this.caseInstanceIdWithChildren;
    }

    public boolean getExcludeSubtasks() {
        return this.excludeSubtasks;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getUserIdForCandidateAndAssignee() {
        return this.userIdForCandidateAndAssignee;
    }

    public List<TaskQueryImpl> getOrQueryObjects() {
        return this.orQueryObjects;
    }

    public void setOrQueryObjects(List<TaskQueryImpl> orQueryObjects) {
        this.orQueryObjects = orQueryObjects;
    }

    public Integer getMinPriority() {
        return this.minPriority;
    }

    public Integer getMaxPriority() {
        return this.maxPriority;
    }

    public String getAssigneeLike() {
        return this.assigneeLike;
    }

    public Collection<String> getAssigneeIds() {
        return this.assigneeIds;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public Collection<String> getInvolvedGroups() {
        return this.involvedGroups;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getOwnerLike() {
        return this.ownerLike;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isWithFormKey() {
        return this.withFormKey;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public String getProcessDefinitionKeyLike() {
        return this.processDefinitionKeyLike;
    }

    public Collection<String> getProcessDefinitionKeys() {
        return this.processDefinitionKeys;
    }

    public String getProcessDefinitionNameLike() {
        return this.processDefinitionNameLike;
    }

    public Collection<String> getProcessCategoryInList() {
        return this.processCategoryInList;
    }

    public Collection<String> getProcessCategoryNotInList() {
        return this.processCategoryNotInList;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public Collection<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public String getCmmnDeploymentId() {
        return this.cmmnDeploymentId;
    }

    public Collection<String> getCmmnDeploymentIds() {
        return this.cmmnDeploymentIds;
    }

    public String getProcessInstanceBusinessKeyLike() {
        return this.processInstanceBusinessKeyLike;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public Date getDueBefore() {
        return this.dueBefore;
    }

    public Date getDueAfter() {
        return this.dueAfter;
    }

    public boolean isWithoutDueDate() {
        return this.withoutDueDate;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public boolean isIncludeTaskLocalVariables() {
        return this.includeTaskLocalVariables;
    }

    public boolean isIncludeProcessVariables() {
        return this.includeProcessVariables;
    }

    public boolean isIncludeCaseVariables() {
        return this.includeCaseVariables;
    }

    public boolean isIncludeIdentityLinks() {
        return this.includeIdentityLinks;
    }

    public boolean isBothCandidateAndAssigned() {
        return this.bothCandidateAndAssigned;
    }

    public String getNameLikeIgnoreCase() {
        return this.nameLikeIgnoreCase;
    }

    public String getDescriptionLikeIgnoreCase() {
        return this.descriptionLikeIgnoreCase;
    }

    public String getAssigneeLikeIgnoreCase() {
        return this.assigneeLikeIgnoreCase;
    }

    public String getOwnerLikeIgnoreCase() {
        return this.ownerLikeIgnoreCase;
    }

    public String getProcessInstanceBusinessKeyLikeIgnoreCase() {
        return this.processInstanceBusinessKeyLikeIgnoreCase;
    }

    public String getProcessDefinitionKeyLikeIgnoreCase() {
        return this.processDefinitionKeyLikeIgnoreCase;
    }

    public String getLocale() {
        return this.locale;
    }

    public boolean isOrActive() {
        return this.orActive;
    }

    public boolean isUnassigned() {
        return this.unassigned;
    }

    public boolean isNoDelegationState() {
        return this.noDelegationState;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getCaseDefinitionKeyLike() {
        return this.caseDefinitionKeyLike;
    }

    public String getCaseDefinitionKeyLikeIgnoreCase() {
        return this.caseDefinitionKeyLikeIgnoreCase;
    }

    public Collection<String> getCaseDefinitionKeys() {
        return this.caseDefinitionKeys;
    }

    public boolean isExcludeSubtasks() {
        return this.excludeSubtasks;
    }

    public boolean isWithLocalizationFallback() {
        return this.withLocalizationFallback;
    }

    public List<Task> list() {
        this.cachedCandidateGroups = null;
        return super.list();
    }

    public List<Task> listPage(int firstResult, int maxResults) {
        this.cachedCandidateGroups = null;
        return super.listPage(firstResult, maxResults);
    }

    public long count() {
        this.cachedCandidateGroups = null;
        return super.count();
    }

    public List<List<String>> getSafeCandidateGroups() {
        return this.safeCandidateGroups;
    }

    public void setSafeCandidateGroups(List<List<String>> safeCandidateGroups) {
        this.safeCandidateGroups = safeCandidateGroups;
    }

    public List<List<String>> getSafeInvolvedGroups() {
        return this.safeInvolvedGroups;
    }

    public void setSafeInvolvedGroups(List<List<String>> safeInvolvedGroups) {
        this.safeInvolvedGroups = safeInvolvedGroups;
    }
}

