/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import java.io.IOException;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.flowable.spring.SpringAsyncExecutor;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.AbstractProcessEngineAutoConfiguration;
import org.flowable.spring.boot.DataSourceProcessEngineAutoConfiguration;
import org.flowable.spring.boot.FlowableProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@AutoConfigureBefore(value={DataSourceProcessEngineAutoConfiguration.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class JpaProcessEngineAutoConfiguration {

    @Configuration
    @ConditionalOnClass(name={"javax.persistence.EntityManagerFactory"})
    @EnableConfigurationProperties(value={FlowableProperties.class})
    public static class JpaConfiguration
    extends AbstractProcessEngineAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public PlatformTransactionManager transactionManager(EntityManagerFactory emf) {
            return new JpaTransactionManager(emf);
        }

        @Bean
        @ConditionalOnMissingBean
        public SpringProcessEngineConfiguration springProcessEngineConfiguration(DataSource dataSource, EntityManagerFactory entityManagerFactory, PlatformTransactionManager transactionManager, SpringAsyncExecutor springAsyncExecutor) throws IOException {
            SpringProcessEngineConfiguration config = this.baseSpringProcessEngineConfiguration(dataSource, transactionManager, springAsyncExecutor);
            config.setJpaEntityManagerFactory((Object)entityManagerFactory);
            config.setTransactionManager(transactionManager);
            config.setJpaHandleTransaction(false);
            config.setJpaCloseEntityManager(false);
            return config;
        }
    }
}

