/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.identity;

import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.IdentityService;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.User;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.flowable.rest.service.api.RestResponseFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseGroupResource {
    @Autowired
    protected RestResponseFactory restResponseFactory;
    @Autowired
    protected IdentityService identityService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected Group getGroupFromRequest(String groupId) {
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        if (group == null) {
            throw new FlowableObjectNotFoundException("Could not find a group with id '" + groupId + "'.", User.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessGroupInfoById(group);
        }
        return group;
    }
}

